/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.piechart;

import org.eclipse.linuxtools.dataviewers.piechart.PieChart;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.swtchart.ISeries;

public class PieChartPaintListener
implements PaintListener {
    private PieChart chart;
    private Control plotArea;
    private String[] seriesNames;
    private static final int X_GAP = 10;
    protected static final Color WHITE = Display.getDefault().getSystemColor(1);
    protected static final Color BLACK = Display.getDefault().getSystemColor(2);

    public PieChartPaintListener(PieChart chart, Control plotArea) {
        this(chart, plotArea, new String[0]);
    }

    public PieChartPaintListener(PieChart chart, Control plotArea, String[] seriesNames) {
        this.chart = chart;
        this.plotArea = plotArea;
        this.seriesNames = seriesNames;
    }

    public void paintControl(PaintEvent e) {
        GC gc = e.gc;
        Rectangle bounds = this.plotArea == null ? gc.getClipping() : this.plotArea.getBounds();
        double[][] series = this.getPieSeriesArray();
        if (series.length == 0) {
            Rectangle allBounds = this.chart.getBounds();
            Font font = new Font((Device)Display.getDefault(), "Arial", 15, 1);
            gc.setForeground(BLACK);
            gc.setFont(font);
            String text = "No data";
            Point textSize = e.gc.textExtent(text);
            gc.drawText(text, (allBounds.width - textSize.x) / 2, (allBounds.height - textSize.y) / 2);
            font.dispose();
            return;
        }
        int width = (bounds.width - bounds.x) / series.length;
        int x = bounds.x;
        int i = 0;
        while (i < series.length) {
            double[] s = series[i];
            this.drawPieChart(e, i, s, new Rectangle(x, bounds.y, width, bounds.height));
            x += width;
            ++i;
        }
    }

    private void drawPieChart(PaintEvent e, int chartnum, double[] series, Rectangle bounds) {
        int nelemSeries = series.length;
        double sumTotal = 0.0;
        int i = 0;
        while (i < nelemSeries) {
            sumTotal += series[i];
            ++i;
        }
        GC gc = e.gc;
        gc.setLineWidth(1);
        int pieWidth = Math.min(bounds.width - 10, bounds.height);
        int pieX = bounds.x + (bounds.width - pieWidth) / 2;
        int pieY = bounds.y + (bounds.height - pieWidth) / 2;
        if (sumTotal == 0.0) {
            gc.drawOval(pieX, pieY, pieWidth, pieWidth);
        } else {
            double factor = 100.0 / sumTotal;
            int sweepAngle = 0;
            int incrementAngle = 0;
            int initialAngle = 90;
            int i2 = 0;
            while (i2 < nelemSeries) {
                gc.setBackground(new Color((Device)e.display, this.chart.sliceColor(i2)));
                if (i2 == nelemSeries - 1) {
                    sweepAngle = 360 - incrementAngle;
                } else {
                    double angle = series[i2] * factor * 3.6;
                    sweepAngle = (int)Math.round(angle);
                }
                gc.fillArc(pieX, pieY, pieWidth, pieWidth, initialAngle, -sweepAngle);
                gc.drawArc(pieX, pieY, pieWidth, pieWidth, initialAngle, -sweepAngle);
                incrementAngle += sweepAngle;
                initialAngle += -sweepAngle;
                ++i2;
            }
        }
        if (chartnum < this.seriesNames.length) {
            Font font = new Font((Device)Display.getDefault(), "Arial", 15, 1);
            gc.setForeground(BLACK);
            gc.setBackground(WHITE);
            gc.setFont(font);
            String text = this.seriesNames[chartnum];
            Point textSize = e.gc.textExtent(text);
            gc.drawText(text, pieX + (pieWidth - textSize.x) / 2, pieY + pieWidth + textSize.y);
            font.dispose();
        }
    }

    private double[][] getPieSeriesArray() {
        ISeries[] series = this.chart.getSeriesSet().getSeries();
        if (series == null || series.length == 0) {
            return new double[0][0];
        }
        double[][] result = new double[series[0].getXSeries().length][series.length];
        int i = 0;
        while (i < result.length) {
            int j = 0;
            while (j < result[i].length) {
                double[] d = series[j].getXSeries();
                result[i][j] = d != null && d.length > 0 ? d[i] : 0.0;
                ++j;
            }
            ++i;
        }
        return result;
    }
}

