/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.traditional;

import java.math.BigInteger;
import org.eclipse.cdt.debug.ui.memory.traditional.AbstractPane;
import org.eclipse.cdt.debug.ui.memory.traditional.Rendering;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalMemoryByte;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRendering;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRenderingMessages;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class TextPane
extends AbstractPane {
    public TextPane(Rendering parent) {
        super(parent);
    }

    protected int getCellCharacterCount() {
        return this.fRendering.getBytesPerColumn() / this.fRendering.getBytesPerCharacter();
    }

    protected String getCellText(MemoryByte[] bytes) {
        return this.fRendering.formatText(bytes, this.fRendering.isTargetLittleEndian(), this.fRendering.getTextMode());
    }

    protected void editCell(BigInteger address, int subCellPosition, char character) {
        try {
            MemoryByte[] bytes = this.fRendering.getBytes(this.fCaretAddress, this.fRendering.getBytesPerColumn());
            String cellText = this.getCellText(bytes);
            if (cellText == null) {
                return;
            }
            StringBuffer cellTextBuffer = new StringBuffer(cellText);
            cellTextBuffer.setCharAt(subCellPosition, character);
            byte[] byteData = cellTextBuffer.toString().getBytes(this.fRendering.getCharacterSet(this.fRendering.getTextMode()));
            if (byteData.length != bytes.length) {
                return;
            }
            TraditionalMemoryByte[] bytesToSet = new TraditionalMemoryByte[bytes.length];
            int i = 0;
            while (i < byteData.length) {
                bytesToSet[i] = new TraditionalMemoryByte(byteData[i]);
                if (bytes[i].getValue() != byteData[i]) {
                    bytesToSet[i].setEdited(true);
                } else {
                    bytesToSet[i].setChanged(bytes[i].isChanged());
                }
                ++i;
            }
            this.fRendering.getViewportCache().setEditedValue(address, bytesToSet);
            this.advanceCursor();
            this.redraw();
        }
        catch (Exception exception) {}
    }

    protected int getCellWidth() {
        GC gc = new GC((Drawable)this);
        gc.setFont(this.fRendering.getFont());
        int width = gc.getAdvanceWidth('F');
        gc.dispose();
        return this.fRendering.getBytesPerColumn() / this.fRendering.getBytesPerCharacter() * width;
    }

    public Point computeSize(int wHint, int hHint) {
        return new Point(this.fRendering.getColumnCount() * this.getCellWidth() + this.fRendering.getRenderSpacing(), 100);
    }

    protected Point getCellLocation(BigInteger cellAddress) {
        try {
            BigInteger address = this.fRendering.getViewportStartAddress();
            int cellOffset = cellAddress.subtract(address).intValue();
            int row = (cellOffset *= this.fRendering.getAddressableSize()) / (this.fRendering.getColumnCount() * this.fRendering.getBytesPerColumn() / this.fRendering.getBytesPerCharacter());
            int col = (cellOffset -= row * this.fRendering.getColumnCount() * this.fRendering.getBytesPerColumn() / this.fRendering.getBytesPerCharacter()) / this.fRendering.getBytesPerColumn() / this.fRendering.getBytesPerCharacter();
            int x = col * this.getCellWidth() + this.fRendering.getCellPadding();
            int y = row * this.getCellHeight() + this.fRendering.getCellPadding();
            return new Point(x, y);
        }
        catch (Exception e) {
            this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_DETERMINE_CELL_LOCATION"), e);
            return null;
        }
    }

    private BigInteger getCellAddressAt(int x, int y) throws DebugException {
        BigInteger address = this.fRendering.getViewportStartAddress();
        int col = x / this.getCellWidth();
        int row = y / this.getCellHeight();
        if (col >= this.fRendering.getColumnCount()) {
            return null;
        }
        address = address.add(BigInteger.valueOf(row * this.fRendering.getColumnCount() * this.fRendering.getAddressesPerColumn() / this.fRendering.getBytesPerCharacter()));
        address = address.add(BigInteger.valueOf(col * this.fRendering.getAddressesPerColumn()));
        return address;
    }

    protected void positionCaret(int x, int y) {
        try {
            BigInteger cellAddress = this.getCellAddressAt(x, y);
            if (cellAddress != null) {
                Point cellPosition = this.getCellLocation(cellAddress);
                int offset = x - cellPosition.x;
                int x2 = offset / this.getCellCharacterWidth();
                if (x2 == this.getCellCharacterCount()) {
                    cellAddress = cellAddress.add(BigInteger.valueOf(this.fRendering.getAddressesPerColumn()));
                    x2 = 0;
                    cellPosition = this.getCellLocation(cellAddress);
                }
                this.fCaret.setLocation(cellPosition.x + x2 * this.getCellCharacterWidth(), cellPosition.y);
                this.fCaretAddress = cellAddress;
                this.fSubCellCaretPosition = x2;
                this.setCaretAddress(this.fCaretAddress);
            }
        }
        catch (Exception e) {
            this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_POSITION_CURSOR"), e);
        }
    }

    protected BigInteger getViewportAddress(int col, int row) throws DebugException {
        BigInteger address = this.fRendering.getViewportStartAddress();
        address = address.add(BigInteger.valueOf((row * this.fRendering.getColumnCount() + col) * this.fRendering.getAddressesPerColumn() / this.fRendering.getBytesPerCharacter()));
        return address;
    }

    protected void paint(PaintEvent pe) {
        super.paint(pe);
        GC gc = pe.gc;
        gc.setFont(this.fRendering.getFont());
        int cellHeight = this.getCellHeight();
        int cellWidth = this.getCellWidth();
        int columns = this.fRendering.getColumnCount();
        boolean isLittleEndian = this.fRendering.isTargetLittleEndian();
        gc.setForeground(this.fRendering.getTraditionalRendering().getColorBackground());
        gc.fillRectangle(columns * cellWidth, 0, this.getBounds().width, this.getBounds().height);
        try {
            BigInteger start = this.fRendering.getViewportStartAddress();
            int i = 0;
            while (i < this.getBounds().height / cellHeight) {
                int col = 0;
                while (col < columns) {
                    gc.setFont(this.fRendering.getFont());
                    if (this.isOdd(col)) {
                        gc.setForeground(this.fRendering.getTraditionalRendering().getColorText());
                    } else {
                        gc.setForeground(this.fRendering.getTraditionalRendering().getColorTextAlternate());
                    }
                    BigInteger cellAddress = start.add(BigInteger.valueOf((i * columns + col) * this.fRendering.getAddressesPerColumn()));
                    MemoryByte[] bytes = this.fRendering.getBytes(cellAddress, this.fRendering.getBytesPerColumn());
                    boolean drawBox = false;
                    if (this.fRendering.getSelection().isSelected(cellAddress)) {
                        gc.setBackground(this.fRendering.getTraditionalRendering().getColorSelection());
                        gc.fillRectangle(cellWidth * col, cellHeight * i, cellWidth, cellHeight);
                        gc.setForeground(this.fRendering.getTraditionalRendering().getColorBackground());
                    } else {
                        gc.setBackground(this.fRendering.getTraditionalRendering().getColorBackground());
                        gc.fillRectangle(cellWidth * col, cellHeight * i, cellWidth, cellHeight);
                        this.applyCustomColor(gc, (TraditionalMemoryByte[])bytes, col);
                        drawBox = this.shouldDrawBox((TraditionalMemoryByte[])bytes, col);
                    }
                    gc.drawText(this.fRendering.formatText(bytes, isLittleEndian, this.fRendering.getTextMode()), cellWidth * col, cellHeight * i + this.fRendering.getCellPadding());
                    if (drawBox) {
                        gc.setForeground(this.fRendering.getTraditionalRendering().getColorTextAlternate());
                        gc.drawRectangle(cellWidth * col - (col == 0 ? 0 : 1), cellHeight * i, cellWidth - (col == 0 ? 1 : 0), cellHeight - 1);
                    }
                    if (this.fRendering.isDebug()) {
                        gc.drawRectangle(cellWidth * col, cellHeight * i + this.fRendering.getCellPadding(), cellWidth, cellHeight);
                    }
                    ++col;
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_PAINT"), e);
        }
    }

    protected void applyCustomColor(GC gc, TraditionalMemoryByte[] bytes, int col) {
        boolean anyByteEditing = false;
        int n = 0;
        while (n < bytes.length && !anyByteEditing) {
            if (bytes[n] instanceof TraditionalMemoryByte && bytes[n].isEdited()) {
                anyByteEditing = true;
            }
            ++n;
        }
        TraditionalRendering ren = this.fRendering.getTraditionalRendering();
        if (this.isOdd(col)) {
            gc.setForeground(ren.getColorText());
        } else {
            gc.setForeground(ren.getColorTextAlternate());
        }
        gc.setBackground(ren.getColorBackground());
        if (anyByteEditing) {
            gc.setForeground(ren.getColorEdit());
            gc.setFont(ren.getFontEdit(gc.getFont()));
        } else {
            boolean isColored = false;
            int i = 0;
            while (i < this.fRendering.getHistoryDepth() && !isColored) {
                int n2 = 0;
                while (n2 < bytes.length) {
                    if (bytes[n2].isChanged(i)) {
                        if (i == 0) {
                            gc.setForeground(ren.getColorsChanged()[i]);
                        } else {
                            gc.setBackground(ren.getColorsChanged()[i]);
                        }
                        gc.setFont(ren.getFontChanged(gc.getFont()));
                        isColored = true;
                        break;
                    }
                    ++n2;
                }
                ++i;
            }
        }
    }
}

