/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.view.annotatedsource;

import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.IAnnotationProvider;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.ISTAnnotationColumn;
import org.eclipse.linuxtools.internal.gcov.Activator;
import org.eclipse.linuxtools.internal.gcov.parser.Line;
import org.eclipse.linuxtools.internal.gcov.parser.SourceFile;
import org.eclipse.linuxtools.internal.gcov.view.annotatedsource.CoverageAnnotationColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class GcovAnnotationProvider
implements IAnnotationProvider {
    private final ISTAnnotationColumn column;
    private final SourceFile sourceFile;
    private final int lineCount;
    private boolean initialized = false;
    private boolean COLORIZE_CODE;
    private boolean USE_GRADIENT;
    private Color GREEN_MAX;
    private Color GREEN_MIN;
    private Color RED;
    private final Color[] GREENCOLORS = new Color[129];

    public GcovAnnotationProvider(SourceFile sourceFile) {
        this.sourceFile = sourceFile;
        this.lineCount = sourceFile.getLines().size();
        this.column = new CoverageAnnotationColumn(sourceFile);
    }

    private void initColors() {
        int i = 0;
        while (i < this.GREENCOLORS.length) {
            this.GREENCOLORS[i] = null;
            ++i;
        }
        Display d = PlatformUI.getWorkbench().getDisplay();
        IPreferenceStore prefs_store = Activator.getDefault().getPreferenceStore();
        this.COLORIZE_CODE = prefs_store.getBoolean("PREFKEY_COV_USE_COLORS");
        this.USE_GRADIENT = prefs_store.getBoolean("PREFKEY_COV_USE_GRADIENT");
        this.GREEN_MAX = new Color((Device)d, StringConverter.asRGB((String)prefs_store.getString("PREFKEY_COV_MAX_COLOR")));
        this.GREEN_MIN = new Color((Device)d, StringConverter.asRGB((String)prefs_store.getString("PREFKEY_COV_MIN_COLOR")));
        this.RED = new Color((Device)d, StringConverter.asRGB((String)prefs_store.getString("PREFKEY_COV_0_COLOR")));
        this.initialized = true;
    }

    public Color getColor(int ln) {
        ArrayList<Line> lines;
        Line line;
        int index;
        if (!this.initialized) {
            this.initColors();
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (this.COLORIZE_CODE && (index = ln + 1) < this.lineCount && (line = (lines = this.sourceFile.getLines()).get(index)).exists()) {
            long count = line.getCount();
            if (count == 0L) {
                return this.RED;
            }
            if (!this.USE_GRADIENT || count == this.sourceFile.getmaxLineCount()) {
                return this.GREEN_MAX;
            }
            int colorIndex = 128 - (int)(128L * count / this.sourceFile.getmaxLineCount());
            if (this.GREENCOLORS[colorIndex] == null) {
                int r = this.GREEN_MIN.getRed() + (this.GREEN_MAX.getRed() - this.GREEN_MIN.getRed()) / colorIndex;
                int v = this.GREEN_MIN.getGreen() + (this.GREEN_MAX.getGreen() - this.GREEN_MIN.getGreen()) / colorIndex;
                int b = this.GREEN_MIN.getBlue() + (this.GREEN_MAX.getBlue() - this.GREEN_MIN.getBlue()) / colorIndex;
                this.GREENCOLORS[colorIndex] = new Color((Device)display, r, v, b);
            }
            return this.GREENCOLORS[colorIndex];
        }
        return display.getSystemColor(1);
    }

    public ISTAnnotationColumn getColumn() {
        return this.column;
    }

    public void dispose() {
        if (this.GREEN_MAX != null) {
            this.GREEN_MAX.dispose();
        }
        if (this.GREEN_MIN != null) {
            this.GREEN_MIN.dispose();
        }
        if (this.RED != null) {
            this.RED.dispose();
        }
        Color[] colorArray = this.GREENCOLORS;
        int n = this.GREENCOLORS.length;
        int n2 = 0;
        while (n2 < n) {
            Color c = colorArray[n2];
            if (c != null) {
                c.dispose();
            }
            ++n2;
        }
    }
}

