/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.ui.internal.commit.CommitEditorInput;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;

public class CommitEditorInputFactory
implements IElementFactory {
    public static final String ID = "org.eclipse.egit.ui.internal.commit.CommitEditorInputFactory";
    public static final String COMMIT = "commit";
    public static final String PATH = "path";

    public static void saveState(IMemento memento, CommitEditorInput input) {
        RepositoryCommit commit = input.getCommit();
        memento.putString(COMMIT, commit.getRevCommit().name());
        memento.putString(PATH, commit.getRepository().getDirectory().getAbsolutePath());
    }

    protected Repository getRepository(IMemento memento) {
        String path = memento.getString(PATH);
        if (path == null) {
            return null;
        }
        File gitDir = new File(path);
        if (!gitDir.exists()) {
            return null;
        }
        try {
            return Activator.getDefault().getRepositoryCache().lookupRepository(gitDir);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected RevCommit getCommit(IMemento memento, Repository repository) {
        String id = memento.getString(COMMIT);
        if (id == null) {
            return null;
        }
        RevWalk walk = new RevWalk(repository);
        try {
            RevCommit commit = walk.parseCommit((AnyObjectId)ObjectId.fromString((String)id));
            RevCommit[] revCommitArray = commit.getParents();
            int n = revCommitArray.length;
            int n2 = 0;
            while (n2 < n) {
                RevCommit parent = revCommitArray[n2];
                walk.parseBody((RevObject)parent);
                ++n2;
            }
            RevCommit revCommit = commit;
            return revCommit;
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            walk.release();
        }
    }

    public IAdaptable createElement(IMemento memento) {
        Repository repository = this.getRepository(memento);
        if (repository == null) {
            return null;
        }
        RevCommit commit = this.getCommit(memento, repository);
        if (commit == null) {
            return null;
        }
        return new CommitEditorInput(new RepositoryCommit(repository, commit));
    }
}

