/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.blame.BlameOperation;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.handlers.HandlerUtil;

public class ShowBlameHandler
extends AbstractHistoryCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IFileRevision revision;
        RevCommit commit;
        String path;
        Repository repo;
        GitHistoryPage page;
        block8: {
            page = this.getPage();
            Object input = page.getInputInternal().getSingleItem();
            if (input == null) {
                return null;
            }
            repo = this.getRepository(event);
            if (repo == null) {
                return null;
            }
            path = this.getPath(repo, page);
            if (path == null) {
                return null;
            }
            commit = (RevCommit)this.getSelection(page).getFirstElement();
            if (commit == null) {
                return null;
            }
            revision = CompareUtils.getFileRevision(path, commit, repo, null);
            if (revision != null) break block8;
            return null;
        }
        try {
            IStorage storage = revision.getStorage((IProgressMonitor)new NullProgressMonitor());
            BlameOperation op = new BlameOperation(repo, storage, path, commit, HandlerUtil.getActiveShell((ExecutionEvent)event), page.getSite().getPage());
            JobUtil.scheduleUserJob((IEGitOperation)op, (String)UIText.ShowBlameHandler_JobName, (Object)JobFamilies.BLAME);
        }
        catch (IOException e) {
            Activator.showError(UIText.ShowBlameHandler_errorMessage, e);
        }
        catch (CoreException e) {
            Activator.showError(UIText.ShowBlameHandler_errorMessage, e);
        }
        return null;
    }

    private String getPath(Repository repo, GitHistoryPage page) {
        Object input = page.getInputInternal().getSingleItem();
        if (input == null) {
            return null;
        }
        if (input instanceof IFile) {
            IFile file = (IFile)input;
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)file);
            if (mapping != null) {
                return mapping.getRepoRelativePath((IResource)file);
            }
        } else if (input instanceof File) {
            return this.getRepoRelativePath(repo, (File)input);
        }
        return null;
    }
}

