/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.egit.core.op.CreateLocalBranchOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RemoteSelectionCombo;
import org.eclipse.egit.ui.internal.components.UpstreamConfigComponent;
import org.eclipse.egit.ui.internal.push.AddRemotePage;
import org.eclipse.egit.ui.internal.push.AddRemoteWizard;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PushBranchPage
extends WizardPage {
    private final Repository repository;
    private final Ref ref;
    private boolean showNewRemoteButton = true;
    private RemoteConfig remoteConfig;
    private List<RemoteConfig> remoteConfigs;
    private RemoteSelectionCombo remoteSelectionCombo;
    private Text branchNameText;
    private CreateLocalBranchOperation.UpstreamConfig upstreamConfig = CreateLocalBranchOperation.UpstreamConfig.NONE;
    private UpstreamConfigComponent upstreamConfigComponent;
    private AddRemotePage addRemotePage;

    public PushBranchPage(Repository repository, Ref ref) {
        super(UIText.PushBranchPage_PageName);
        this.setTitle(UIText.PushBranchPage_PageTitle);
        this.setMessage(UIText.PushBranchPage_PageMessage);
        this.repository = repository;
        this.ref = ref;
    }

    public void setShowNewRemoteButton(boolean showNewRemoteButton) {
        this.showNewRemoteButton = showNewRemoteButton;
    }

    AddRemotePage getAddRemotePage() {
        return this.addRemotePage;
    }

    RemoteConfig getRemoteConfig() {
        return this.remoteConfig;
    }

    String getBranchName() {
        return this.branchNameText.getText();
    }

    boolean isConfigureUpstreamSelected() {
        return this.upstreamConfig != CreateLocalBranchOperation.UpstreamConfig.NONE;
    }

    boolean isRebaseSelected() {
        return this.upstreamConfig == CreateLocalBranchOperation.UpstreamConfig.REBASE;
    }

    public void createControl(Composite parent) {
        try {
            this.remoteConfigs = RemoteConfig.getAllRemoteConfigs((Config)this.repository.getConfig());
        }
        catch (URISyntaxException e) {
            this.remoteConfigs = new ArrayList<RemoteConfig>();
            this.handleError(e);
        }
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        Composite inputPanel = new Composite(main, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)inputPanel);
        inputPanel.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        Label remoteLabel = new Label(inputPanel, 0);
        remoteLabel.setText(UIText.PushBranchPage_RemoteLabel);
        int remoteSelectionSpan = this.showNewRemoteButton ? 1 : 2;
        this.remoteSelectionCombo = new RemoteSelectionCombo(inputPanel, 0, RemoteSelectionCombo.SelectionType.PUSH);
        GridDataFactory.fillDefaults().grab(true, false).span(remoteSelectionSpan, 1).applyTo((Control)this.remoteSelectionCombo);
        this.setRemoteConfigs();
        this.remoteSelectionCombo.addRemoteSelectionListener(new RemoteSelectionCombo.IRemoteSelectionListener(){

            public void remoteSelected(RemoteConfig rc) {
                PushBranchPage.this.remoteConfig = rc;
                PushBranchPage.this.checkPage();
            }
        });
        if (this.showNewRemoteButton) {
            Button newRemoteButton = new Button(inputPanel, 8);
            newRemoteButton.setText(UIText.PushBranchPage_NewRemoteButton);
            GridDataFactory.fillDefaults().applyTo((Control)newRemoteButton);
            newRemoteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PushBranchPage.this.showNewRemoteDialog();
                }
            });
        }
        Label branchNameLabel = new Label(inputPanel, 0);
        branchNameLabel.setText(UIText.PushBranchPage_BranchNameLabel);
        this.branchNameText = new Text(inputPanel, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.branchNameText);
        this.branchNameText.setText(this.getSuggestedBranchName());
        this.upstreamConfigComponent = new UpstreamConfigComponent(inputPanel, 0);
        this.upstreamConfigComponent.getContainer().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(3, 1).create());
        this.upstreamConfigComponent.addUpstreamConfigSelectionListener(new UpstreamConfigComponent.UpstreamConfigSelectionListener(){

            public void upstreamConfigSelected(CreateLocalBranchOperation.UpstreamConfig newUpstreamConfig) {
                PushBranchPage.this.upstreamConfig = newUpstreamConfig;
                PushBranchPage.this.checkPage();
            }
        });
        this.setDefaultUpstreamConfig();
        this.setControl((Control)main);
        this.checkPage();
        this.branchNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PushBranchPage.this.checkPage();
            }
        });
    }

    private void setRemoteConfigs() {
        this.remoteSelectionCombo.setItems(this.remoteConfigs);
        String branchName = Repository.shortenRefName((String)this.ref.getName());
        String remoteName = this.repository.getConfig().getString("branch", branchName, "remote");
        if (remoteName != null) {
            for (RemoteConfig rc : this.remoteConfigs) {
                if (!remoteName.equals(rc.getName())) continue;
                this.remoteSelectionCombo.setSelectedRemote(rc);
            }
        }
        this.remoteConfig = this.remoteSelectionCombo.getSelectedRemote();
    }

    private void setDefaultUpstreamConfig() {
        CreateLocalBranchOperation.UpstreamConfig defaultUpstreamConfig = CreateLocalBranchOperation.UpstreamConfig.getDefault((Repository)this.repository, (String)("refs/remotes/origin/" + Repository.shortenRefName((String)this.ref.getName())));
        this.upstreamConfigComponent.setUpstreamConfig(defaultUpstreamConfig);
        this.upstreamConfig = defaultUpstreamConfig;
    }

    private void showNewRemoteDialog() {
        AddRemoteWizard wizard = new AddRemoteWizard(this.repository);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        int result = dialog.open();
        if (result == 0) {
            URIish uri = wizard.getUri();
            String remoteName = wizard.getRemoteName();
            this.addRemotePage = wizard.getAddRemotePage();
            this.setSelectedRemote(remoteName, uri);
        }
    }

    private void checkPage() {
        block9: {
            String branchName;
            block8: {
                block7: {
                    try {
                        if (this.remoteConfig != null) break block7;
                        this.setErrorMessage(UIText.PushBranchPage_ChooseRemoteError);
                    }
                    catch (Throwable throwable) {
                        this.setPageComplete(this.getErrorMessage() == null);
                        throw throwable;
                    }
                    this.setPageComplete(this.getErrorMessage() == null);
                    return;
                }
                branchName = this.branchNameText.getText();
                if (branchName.length() != 0) break block8;
                this.setErrorMessage(UIText.PushBranchPage_ChooseBranchNameError);
                this.setPageComplete(this.getErrorMessage() == null);
                return;
            }
            if (Repository.isValidRefName((String)("refs/heads/" + branchName))) break block9;
            this.setErrorMessage(UIText.PushBranchPage_InvalidBranchNameError);
            this.setPageComplete(this.getErrorMessage() == null);
            return;
        }
        if (this.branchAlreadyHasUpstreamConfiguration() && this.isConfigureUpstreamSelected()) {
            this.setMessage(UIText.PushBranchPage_UpstreamConfigOverwriteWarning, 2);
        } else {
            this.setMessage(UIText.PushBranchPage_PageMessage);
        }
        this.setErrorMessage(null);
        this.setPageComplete(this.getErrorMessage() == null);
    }

    void setSelectedRemote(String remoteName, URIish urIish) {
        try {
            RemoteConfig config = new RemoteConfig((Config)this.repository.getConfig(), remoteName);
            config.addURI(urIish);
            this.remoteSelectionCombo.setItems(Arrays.asList(config));
            this.remoteConfig = config;
            this.remoteSelectionCombo.setEnabled(false);
            this.checkPage();
        }
        catch (URISyntaxException e) {
            this.handleError(e);
        }
    }

    private String getSuggestedBranchName() {
        return Repository.shortenRefName((String)this.ref.getName());
    }

    private boolean branchAlreadyHasUpstreamConfiguration() {
        StoredConfig config = this.repository.getConfig();
        BranchConfig branchConfig = new BranchConfig((Config)config, Repository.shortenRefName((String)this.ref.getName()));
        String trackingBranch = branchConfig.getTrackingBranch();
        return trackingBranch != null;
    }

    private void handleError(URISyntaxException e) {
        Activator.handleError(e.getMessage(), e, false);
        this.setErrorMessage(e.getMessage());
    }
}

