/*
 * Decompiled with CFR 0.152.
 */
package cdt.code.comments.core;

public class Examples {
    private static String constantPropExample = "\nFor Example:\n{\n.\n.\n i=5;\n j=i;\n .\n.\n}\n** Becomes **\n{\n.\n.\n i=5;\n j=5;\n .\n.\n}";
    private static String copyPropExample = "\nFor Example:\n{\n.\n.\n i=y;\n j=5+i/3;\n .\n.\n}\n** Becomes **\n{\n.\n.\n i=y;\n j=5+y/3;\n .\n.\n}";
    private static String classInliningExample = "\nFor Example:\npublic class A {\n  private B bObj = new B();\n  public void action1(){ bObj.methodIncX();}\n}\n\npublic class B{\nprivate int x;\npublic void methodIncX(){ x++; }\n}\n\n\n** Becomes: **\n\npublic class AB {\nprivate int bObj_x;\npublic void action1(){ bObj_methodIncX(); }\npublic void bObj_methodIncX() { bObj_x++; }\n}\n\nWatch out for:\n1. Fields with the same names.\n2. If B's c'tor is called at A.\n3. If B inherits from another class.\n4. If there are functions called from A that take b as an argument.\n5. If b is public and is used outside of A.";
    private static String structureSplittingExample = "\nFor Example:\n#define NUM_OF_ELL_IN_STRU  16\n\ntypedef struct {\n  unsigned int firstInStruct[NUM_OF_ELL_IN_STRU];\n  unsigned int midInStruct;\n  unsigned int secondInStruct[NUM_OF_ELL_IN_STRU-1];\n}  ArrayType;\n\n\n** If midInStruct is used more frequently than other fields\nthen the code should become like: **\n\ntypedef struct {\n  unsigned int midInStruct;\n}  ArrayType_1;\ntypedef struct {\n  unsigned int firstInStruct[NUM_OF_ELL_IN_STRU];\n  unsigned int secondInStruct[NUM_OF_ELL_IN_STRU-1];\n}  ArrayType_2;\n\nWatch out that:\n1. In order to get a useful splitting each time the stucture is used there should be a field\n   or a collection of small fields that is used more frequently than the others at that time!";
    private static String strengthReductionExample = "\n\nFor Example:\ni *= 1024;\nCan be written as:\ni <<= 10;\n";
    private static String algebricSimpExample = "\nFor Example:\n{\n.\n.\n i=3*j+0 .\n.\n}\n** Becomes **\n{\n.\n.\n i=3*j\n .\n.\n}";
    private static String deadCodeEliminationExample = "\nFor Example:\n{\n int i,j,z;\n .\n.\n}\n** If j is the only var which isn't used in the whole scope, the code will become **\n{\n int i,z;\n .\n.\n}";

    public static String getConstantPropExample() {
        return constantPropExample;
    }

    public static String getCopyPropExample() {
        return copyPropExample;
    }

    public static String getClassInliningExample() {
        return classInliningExample;
    }

    public static String getStructureSplittingExample() {
        return structureSplittingExample;
    }

    public static String getAlgebricSimpExample() {
        return algebricSimpExample;
    }

    public static String getDeadCodeEliminationExample() {
        return deadCodeEliminationExample;
    }

    public static String getStrengthReducExample() {
        return strengthReductionExample;
    }

    public static String getFunctionSpecializationExample(String commentText) {
        return "Consider creating a specialized function as follows:\n" + commentText + "\n";
    }
}

