/*
 * Decompiled with CFR 0.152.
 */
package cpd.checkers.core;

import cpd.checkers.core.COperatorGroup;
import cpd.checkers.core.CheckVisitor;
import cpd.checkers.core.ExpressionExtractor;
import cpd.checkers.core.OperandsSet;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;

public class CheckExpressions
extends CheckVisitor {
    OperandsSet m_lValues;
    OperandsSet m_rValues;
    Boolean m_bCompoundAssignmentUsed;
    Boolean m_bUnaryExpressionUsed;
    Boolean Left_index = true;
    int m_nExpressionCounter;
    private Boolean m_bFirstTimeVisiting = false;

    public CheckExpressions(boolean IsExitPoint, boolean IsReportComment) {
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.m_bCompoundAssignmentUsed = false;
        this.m_bUnaryExpressionUsed = false;
        this.m_lValues = new OperandsSet();
        this.m_rValues = new OperandsSet();
        this.m_bExitPoint = IsExitPoint;
    }

    public CheckExpressions(boolean IsExitPoint) {
        this(IsExitPoint, true);
    }

    private boolean IndexChecking(IASTExpression left, IASTExpression right) {
        if (left.getChildren().length > 0 && right.getChildren().length > 0 && !left.getChildren()[0].getRawSignature().equals(right.getChildren()[0].getRawSignature())) {
            return false;
        }
        if (left.getChildren().length < 2 || right.getChildren().length < 2) {
            return true;
        }
        if (left.getChildren().length > 1 && left.getChildren()[1].getChildren().length > 0 && left.getChildren()[1].getChildren()[0] != null) {
            left.getChildren()[1].getChildren()[0].getRawSignature();
        }
        if (right.getChildren().length > 1 && right.getChildren()[1].getChildren().length > 0 && right.getChildren()[1].getChildren()[0] != null) {
            right.getChildren()[1].getChildren()[0].getRawSignature();
        }
        int index1 = 0;
        int index2 = 0;
        if (left.getChildren().length > 1) {
            char character;
            char ascii;
            if (left.getChildren()[1].getChildren().length == 1) {
                index1 = 0;
            } else if (left.getChildren()[1].getChildren().length > 1 && left.getChildren()[1].getChildren()[1] != null && (ascii = (character = left.getChildren()[1].getChildren()[1].getRawSignature().charAt(0))) < '9') {
                index1 = Integer.parseInt(left.getChildren()[1].getChildren()[1].getRawSignature());
            }
            if (right.getChildren()[1].getChildren().length == 1) {
                index2 = 0;
            } else if (right.getChildren().length > 1 && right.getChildren()[1].getChildren().length > 1 && right.getChildren()[1].getChildren()[1] != null && (ascii = (character = right.getChildren()[1].getChildren()[1].getRawSignature().charAt(0))) < '9') {
                index2 = Integer.parseInt(right.getChildren()[1].getChildren()[1].getRawSignature());
            }
            if (!left.getRawSignature().contains("+") && right.getRawSignature().contains("+")) {
                return true;
            }
            if (left.getRawSignature().contains("+") && right.getRawSignature().contains("+")) {
                return index2 > index1;
            }
            if (left.getRawSignature().contains("-") && !right.getRawSignature().contains("-")) {
                return true;
            }
            if (left.getRawSignature().contains("-") && right.getRawSignature().contains("-") && index2 < index1) {
                return true;
            }
        }
        return false;
    }

    public int visit(IASTExpression stmt) {
        IASTUnaryExpression UnaryStmt;
        int nOperType;
        boolean cfr_ignored_0 = stmt instanceof IASTForStatement;
        if (stmt instanceof IASTBinaryExpression) {
            IASTBinaryExpression BinaryExp = (IASTBinaryExpression)stmt;
            int nOperatorType = ((IASTBinaryExpression)stmt).getOperator();
            if (COperatorGroup.IsCompoundAssignmentOperator(nOperatorType).booleanValue()) {
                if (!((IASTBinaryExpression)stmt).getOperand1().getChildren()[0].getRawSignature().equals(((IASTBinaryExpression)stmt).getOperand1().getRawSignature())) {
                    ++this.m_nExpressionCounter;
                    this.m_lValues.add(BinaryExp.getOperand1().getChildren()[0].getRawSignature());
                    if (!this.IndexChecking(BinaryExp.getOperand1(), BinaryExp.getOperand2())) {
                        this.Left_index = false;
                    }
                    if (BinaryExp.getOperand2().getChildren().length == 1 || BinaryExp.getOperand2() instanceof IASTArraySubscriptExpression) {
                        this.m_rValues.add(BinaryExp.getOperand2().getRawSignature());
                    } else {
                        ExpressionExtractor ExtracorVisitor = new ExpressionExtractor(this.m_rValues);
                        BinaryExp.getOperand2().accept((ASTVisitor)ExtracorVisitor);
                    }
                }
            } else if (COperatorGroup.IsCompoundAssignmentOperator(BinaryExp.getOperator()).booleanValue()) {
                this.m_bCompoundAssignmentUsed = true;
                return 1;
            }
        } else if (stmt instanceof IASTUnaryExpression && COperatorGroup.IsUnaryModifier(nOperType = (UnaryStmt = (IASTUnaryExpression)stmt).getOperator()).booleanValue()) {
            this.m_bUnaryExpressionUsed = true;
            return 1;
        }
        return 3;
    }

    public int visit(IASTStatement stmt) {
        if (!this.m_bFirstTimeVisiting.booleanValue()) {
            this.RootNode = stmt.getParent();
            this.m_bFirstTimeVisiting = true;
        }
        return 3;
    }

    public CheckVisitor CreateNewVisitor(boolean IsExitPoint) {
        return new CheckExpressions(IsExitPoint);
    }

    @Override
    public CheckVisitor CreateNewVisitor(boolean IsExitPoint, boolean IsReportComment) {
        return new CheckExpressions(IsExitPoint, IsReportComment);
    }

    private Boolean IsSimpleParallezible() {
        OperandsSet intersection = OperandsSet.intersection(this.m_lValues, this.m_rValues);
        if (intersection.isEmpty() && !this.m_bCompoundAssignmentUsed.booleanValue() && this.Left_index.booleanValue() && !this.m_bUnaryExpressionUsed.booleanValue() && this.m_nExpressionCounter > 0) {
            CheckExpressions.already_sample[this.loop_num] = true;
        }
        if (!intersection.isEmpty() || this.m_bCompoundAssignmentUsed.booleanValue() || !this.Left_index.booleanValue() || !this.m_bUnaryExpressionUsed.booleanValue()) {
            // empty if block
        }
        ++this.loop_num;
        if (intersection.isEmpty() && !this.m_bCompoundAssignmentUsed.booleanValue() && this.Left_index.booleanValue() && !this.m_bUnaryExpressionUsed.booleanValue() && this.m_nExpressionCounter > 0) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean IsHaving() {
        if (this.getIsReportComment() && this.IsSimpleParallezible().booleanValue()) {
            return true;
        }
        return false;
    }

    @Override
    public String MsgInfo() {
        return "Simple parallelzable loop";
    }

    @Override
    public String HoverInfo() {
        String sHoverInfo = String.format("/*\tC-OCA: Simple parallelizable loop.\n\tCan be parallelized by defining an init array for: %s.\n\t(see more details at: http://www.optca.org/omp-transformations.html#_Toc461635025 )*/\n", this.m_lValues.toString());
        m_sHoverString.insertCommentBeforNode(this.RootNode, sHoverInfo);
        return this.MsgInfo();
    }

    @Override
    public String ExtraInfo() {
        return "One can add an initialization loop and then use the OMP pragma directive to parallelize the loop. \nSee example below: \nFor the following original sequential loop: \nfor (int i=0; i<100; i++) \n{ \narray[i] += array[i+C];   \\\\ C is a constant value larger than 0\nx= i+C;\n} \n\n One can transform it into the following 2 parallelizable loops:\n\n array_t initArray[100]; \n\n #pragma omp parallel for \nfor (int i=0; i<100; i++) \n {\ninitArray[i] = array[i];\n initX[i] = x;\n }\n\n #pragma omp parallel for \nfor (int i=0; i<100; i++) \n{\narray[i] = initArray[i] + initArray[i+C]; \ninitX[i]=i+c;\n}\nx=initX[99];";
    }
}

