/*
 * Decompiled with CFR 0.152.
 */
package cpd.checkers.core;

import cpd.checkers.core.COperatorGroup;
import cpd.checkers.core.CheckVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;

public class CheckInitArray
extends CheckVisitor {
    private boolean m_bIsHaving;
    private String m_sHoverInfo;
    private Stack<IASTNode> m_stackInsideLoop;
    private HashMap<String, HashSet<String>> m_mapInitArrayConstraints;

    public CheckInitArray(boolean IsExitPoint, boolean IsReportComment) {
        this.shouldVisitStatements = true;
        this.shouldVisitExpressions = true;
        this.m_bIsHaving = false;
        this.m_sHoverInfo = "";
        this.m_stackInsideLoop = new Stack();
        this.m_mapInitArrayConstraints = new HashMap();
        this.m_bExitPoint = IsExitPoint;
    }

    public CheckInitArray(boolean IsExitPoint) {
        this(IsExitPoint, true);
    }

    @Override
    public Boolean IsHaving() {
        if (this.getIsReportComment() && this.m_bIsHaving) {
            return true;
        }
        return false;
    }

    public CheckVisitor CreateNewVisitor(boolean IsExitPoint) {
        return new CheckInitArray(IsExitPoint);
    }

    @Override
    public CheckVisitor CreateNewVisitor(boolean IsExitPoint, boolean IsReportComment) {
        return new CheckInitArray(IsExitPoint, IsReportComment);
    }

    @Override
    public String MsgInfo() {
        return "Initialization array";
    }

    @Override
    public String HoverInfo() {
        return this.m_sHoverInfo;
    }

    @Override
    public String ExtraInfo() {
        return this.HoverInfo();
    }

    public int visit(IASTStatement stmt) {
        if (stmt instanceof IASTForStatement || stmt instanceof IASTDoStatement || stmt instanceof IASTWhileStatement) {
            if (this.m_stackInsideLoop.empty()) {
                this.RootNode = stmt;
            }
            this.m_stackInsideLoop.push((IASTNode)stmt);
        }
        return 3;
    }

    public int leave(IASTStatement stmt) {
        if (stmt instanceof IASTForStatement || stmt instanceof IASTDoStatement || stmt instanceof IASTWhileStatement) {
            if (this.m_stackInsideLoop.size() == 1 && this.m_mapInitArrayConstraints.size() > 0) {
                this.m_sHoverInfo = "/*\tC-OCA: Array initialization should be considered:\n";
                this.m_bIsHaving = true;
                for (Map.Entry<String, HashSet<String>> entry : this.m_mapInitArrayConstraints.entrySet()) {
                    this.m_sHoverInfo = String.valueOf(this.m_sHoverInfo) + "\t" + entry.getKey() + ":\n";
                    for (String constraint : entry.getValue()) {
                        this.m_sHoverInfo = String.valueOf(this.m_sHoverInfo) + "\t\t" + constraint + "\n";
                    }
                }
                this.m_sHoverInfo = String.valueOf(this.m_sHoverInfo) + "(see more details at: http://www.optca.org/omp-transformations.html#_Toc461635025) */\n";
                m_sHoverString.insertCommentBeforNode(this.RootNode, this.m_sHoverInfo);
            }
            this.m_stackInsideLoop.pop();
        }
        return 3;
    }

    private boolean isArraySubscriptDependant(String ArrayName, IASTInitializerClause ArrayInit1, IASTInitializerClause ArrayInit2) {
        boolean bIsConstraint = false;
        if (ArrayInit1 instanceof IASTBinaryExpression) {
            IASTBinaryExpression ArrayInitExpression1 = (IASTBinaryExpression)ArrayInit1;
            if (!(ArrayInit2 instanceof IASTIdExpression) && ArrayInit2 instanceof IASTBinaryExpression) {
                IASTBinaryExpression ArrayInitExpression2 = (IASTBinaryExpression)ArrayInit2;
                block0 : switch (ArrayInitExpression1.getOperator()) {
                    case 4: {
                        switch (ArrayInitExpression2.getOperator()) {
                            case 4: {
                                bIsConstraint = true;
                                break block0;
                            }
                            case 5: {
                                bIsConstraint = false;
                                break block0;
                            }
                        }
                        break;
                    }
                    case 5: {
                        switch (ArrayInitExpression2.getOperator()) {
                            case 4: {
                                bIsConstraint = true;
                                break block0;
                            }
                            case 5: {
                                bIsConstraint = true;
                                break block0;
                            }
                        }
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (ArrayInit1 instanceof IASTIdExpression) {
            if (ArrayInit2 instanceof IASTBinaryExpression) {
                IASTBinaryExpression ArrayInitExpression2 = (IASTBinaryExpression)ArrayInit2;
                switch (ArrayInitExpression2.getOperator()) {
                    case 4: {
                        bIsConstraint = true;
                        break;
                    }
                }
            } else if (ArrayInit2 instanceof IASTIdExpression) {
                bIsConstraint = true;
            }
        }
        return bIsConstraint;
    }

    public int visit(IASTExpression expr) {
        IASTBinaryExpression BinaryExpression;
        int nOperatorType;
        if (expr instanceof IASTBinaryExpression && (COperatorGroup.IsAssignmentOperator(nOperatorType = (BinaryExpression = (IASTBinaryExpression)expr).getOperator()).booleanValue() || COperatorGroup.IsCompoundAssignmentOperator(nOperatorType).booleanValue())) {
            IASTExpression Operand1 = BinaryExpression.getOperand1();
            IASTExpression Operand2 = BinaryExpression.getOperand2();
            if (Operand1 instanceof IASTArraySubscriptExpression && Operand2 instanceof IASTArraySubscriptExpression) {
                IASTArraySubscriptExpression ArrayOperand1 = (IASTArraySubscriptExpression)Operand1;
                IASTArraySubscriptExpression ArrayOperand2 = (IASTArraySubscriptExpression)Operand2;
                if (ArrayOperand1.getArrayExpression().getRawSignature().toString().equals(ArrayOperand2.getArrayExpression().getRawSignature().toString())) {
                    boolean bIsConstraint = false;
                    String sArrayName = ArrayOperand1.getArrayExpression().getRawSignature().toString();
                    bIsConstraint = this.isArraySubscriptDependant(sArrayName, ArrayOperand1.getArgument(), ArrayOperand2.getArgument());
                    if (bIsConstraint) {
                        HashSet<String> SetArrayConstraint = null;
                        SetArrayConstraint = this.m_mapInitArrayConstraints.containsKey(sArrayName) ? this.m_mapInitArrayConstraints.get(sArrayName) : new HashSet<String>();
                        SetArrayConstraint.add(String.valueOf(ArrayOperand1.getArgument().getRawSignature()) + " < " + ArrayOperand2.getArgument().getRawSignature());
                        this.m_mapInitArrayConstraints.put(sArrayName, SetArrayConstraint);
                    }
                }
            }
        }
        return 3;
    }
}

