/*
 * Decompiled with CFR 0.152.
 */
package cpd.checkers.core;

import cpd.checkers.core.CheckVisitor;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;

public class CheckLoopExit
extends CheckVisitor {
    private boolean m_bIsHaving;
    private String m_sHoverInfo;
    private boolean m_bInsideSwitch;
    private Stack<IASTNode> m_stackInsideLoop;

    public CheckLoopExit(boolean IsExitPoint, boolean IsReportComment) {
        this.shouldVisitStatements = true;
        this.m_bIsHaving = false;
        this.m_sHoverInfo = "";
        this.m_bInsideSwitch = false;
        this.m_stackInsideLoop = new Stack();
        this.m_bExitPoint = IsExitPoint;
    }

    public CheckLoopExit(boolean IsExitPoint) {
        this(IsExitPoint, true);
    }

    @Override
    public Boolean IsHaving() {
        if (this.getIsReportComment() && this.m_bIsHaving) {
            return true;
        }
        return false;
    }

    public CheckVisitor CreateNewVisitor(boolean IsExitPoint) {
        return new CheckLoopExit(IsExitPoint);
    }

    @Override
    public CheckVisitor CreateNewVisitor(boolean IsExitPoint, boolean IsReportComment) {
        return new CheckLoopExit(IsExitPoint, IsReportComment);
    }

    @Override
    public String MsgInfo() {
        return "Loop execution break";
    }

    @Override
    public String HoverInfo() {
        return this.m_sHoverInfo;
    }

    @Override
    public String ExtraInfo() {
        return this.HoverInfo();
    }

    public int visit(IASTStatement stmt) {
        if (stmt instanceof IASTSwitchStatement) {
            this.m_bInsideSwitch = true;
        } else if (stmt instanceof IASTForStatement || stmt instanceof IASTDoStatement || stmt instanceof IASTWhileStatement) {
            this.m_stackInsideLoop.push((IASTNode)stmt);
        } else if (this.m_stackInsideLoop.size() == 1) {
            if (stmt instanceof IASTBreakStatement) {
                if (!this.m_bInsideSwitch) {
                    m_sHoverString.insertCommentBeforNode((IASTNode)stmt, "/*\tC-OCA: Consider applying 'break' statement emulation for parallelization.\n\t\t\t (see details at: http://www.optca.org/omp-transformations.html#_Toc461635026 ) */\n");
                    this.m_bIsHaving = true;
                }
            } else if (stmt instanceof IASTReturnStatement) {
                m_sHoverString.insertCommentBeforNode((IASTNode)stmt, "/*\tC-OCA: Consider applying 'return' statement emulation for parallelization. */\n");
                this.m_bIsHaving = true;
            }
        }
        return 3;
    }

    public int leave(IASTStatement stmt) {
        if (stmt instanceof IASTSwitchStatement) {
            this.m_bInsideSwitch = false;
        } else if (stmt instanceof IASTForStatement || stmt instanceof IASTDoStatement || stmt instanceof IASTWhileStatement) {
            this.m_stackInsideLoop.pop();
        }
        return 3;
    }
}

