/*
 * Decompiled with CFR 0.152.
 */
package cpd.checkers.core;

import cpd.checkers.core.COperatorGroup;
import cpd.checkers.core.CheckVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;

public class CheckReductionClause
extends CheckVisitor {
    private int m_nExpressionCounter;
    private Boolean m_bHasAssigmentExpressions;
    private String m_strVarName;
    private String m_strOperator;
    private Boolean m_bUnaryExpressionUsed;
    private Boolean m_bFirstTimeVisiting = false;
    private Boolean m_bIsScalarVar = false;

    public CheckReductionClause(boolean IsExitPoint, boolean IsReportComment) {
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.m_nExpressionCounter = 0;
        this.m_bHasAssigmentExpressions = false;
        this.m_bUnaryExpressionUsed = false;
        this.m_bIsScalarVar = false;
        this.m_strVarName = new String("");
        this.m_strOperator = new String("");
        this.m_bExitPoint = IsExitPoint;
    }

    public CheckReductionClause(boolean IsExitPoint) {
        this(IsExitPoint, true);
    }

    public int visit(IASTExpression stmt) {
        IASTUnaryExpression UnaryStmt;
        int nOperType;
        if (stmt instanceof IASTBinaryExpression) {
            int nOperatorType = ((IASTBinaryExpression)stmt).getOperator();
            if (COperatorGroup.IsAssignmentOperator(nOperatorType).booleanValue()) {
                this.m_bHasAssigmentExpressions = true;
                return 1;
            }
            if (COperatorGroup.IsCompoundAssignmentOperator(nOperatorType).booleanValue()) {
                ++this.m_nExpressionCounter;
                if (this.m_nExpressionCounter == 1) {
                    IASTBinaryExpression BinaryExp = (IASTBinaryExpression)stmt;
                    this.m_strVarName = BinaryExp.getOperand1().getChildren()[0].getRawSignature();
                    this.m_strOperator = COperatorGroup.CompoundAssignmentToString(nOperatorType);
                    if (BinaryExp.getOperand1().getChildren()[0].getRawSignature().equals(BinaryExp.getOperand1().getRawSignature())) {
                        this.m_bIsScalarVar = true;
                    }
                }
            }
        } else if (stmt instanceof IASTUnaryExpression && COperatorGroup.IsUnaryModifier(nOperType = (UnaryStmt = (IASTUnaryExpression)stmt).getOperator()).booleanValue()) {
            this.m_bUnaryExpressionUsed = true;
            return 1;
        }
        return 3;
    }

    public int visit(IASTStatement stmt) {
        if (!this.m_bFirstTimeVisiting.booleanValue()) {
            this.RootNode = stmt.getParent();
            this.m_bFirstTimeVisiting = true;
        }
        return 3;
    }

    Boolean IsHavingReductionClause() {
        Boolean retval = this.m_nExpressionCounter == 1 && this.m_bHasAssigmentExpressions == false && this.m_bUnaryExpressionUsed == false ? Boolean.valueOf(true) : Boolean.valueOf(false);
        return retval;
    }

    @Override
    public Boolean IsHaving() {
        if (this.getIsReportComment() && this.IsHavingReductionClause().booleanValue()) {
            return true;
        }
        return false;
    }

    public CheckVisitor CreateNewVisitor(boolean IsExitPoint) {
        return new CheckReductionClause(IsExitPoint);
    }

    @Override
    public CheckVisitor CreateNewVisitor(boolean IsExitPoint, boolean IsReportComment) {
        return new CheckReductionClause(IsExitPoint, IsReportComment);
    }

    @Override
    public String MsgInfo() {
        return "Loop Recurrence";
    }

    @Override
    public String HoverInfo() {
        String sHoverInfo = this.m_bIsScalarVar != false ? String.format("/*\tC-OCA: Loop containing paralellizable scalar reduction.\n\tCan be parallelized by the omp reduction directive \ton variable '%s' with operator '%s' \n\t(for more details see: http://www.optca.org/omp-transformations.html#_Toc461635029) */\n", this.m_strVarName, this.m_strOperator) : String.format("/*\tC-OCA: Loop containing paralellizable recurrence.\n\tCan be parallelized by parallel prefix \ton array '%s' with operator '%s' \n\t(for more details see: http://www.optca.org/omp-transformations.html#_Toc461635029) */\n", this.m_strVarName, this.m_strOperator);
        m_sHoverString.insertCommentBeforNode(this.RootNode, sHoverInfo);
        return this.MsgInfo();
    }

    @Override
    public String ExtraInfo() {
        String strInfo = String.format("#pragma omp parallel for reduction ( %s : %s )\n\nFor cumulative array operations of the following form:\n\tfor(i=1; i<n; i++) {\n\t\tX[i] *= X[i-1];\n\t}\nNeed to consider the following parallelization code which requires logarithmic number of sequential steps assuming n is a power of 2:\n\tfor(j=1; j<log(n); j++) {\n\t\t#pragma omp parallel for\n\t\tfor (i=2^(j-1)+1; i<n; i++) {\n\t\t\tX[i] *= X[i-2^(j-1)];\n\t\t}\n\t}\n\nYou can add the OpenMp pragma for Parallization \n#pragma omp parallel for reduction Example: Before \nfor(i=0;i<10;i++)\n{\n\ta*=A[i];\n}\nExample: After \n#pragma omp parallel for reduction( a : * )\nfor(i=0;i<10;i++)\n{\n\ta*=A[i];\n}\nIn this case you should add", this.m_strVarName, this.m_strOperator);
        return strInfo;
    }
}

