/*
 * Decompiled with CFR 0.152.
 */
package cpd.checkers.core;

import cpd.checkers.core.CheckVisitor;
import cpd.checkers.core.OperandsSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;

public class CheckScalarExpansion
extends CheckVisitor {
    private boolean m_bIsHaving;
    private String m_sHoverInfo;
    private Stack<IASTNode> m_stackInsideLoop;
    private HashMap<String, Integer> mapLValue = new HashMap();
    private HashMap<String, Integer> mapRValue = new HashMap();
    private OperandsSet condSet;

    public CheckScalarExpansion(boolean IsExitPoint, boolean IsReportComment) {
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.m_bIsHaving = false;
        this.m_sHoverInfo = "";
        this.m_bExitPoint = IsExitPoint;
        this.m_stackInsideLoop = new Stack();
        this.mapLValue = new HashMap();
        this.mapRValue = new HashMap();
        this.condSet = new OperandsSet();
    }

    public CheckScalarExpansion(boolean IsExitPoint) {
        this(IsExitPoint, true);
    }

    @Override
    public Boolean IsHaving() {
        if (this.getIsReportComment() && this.m_bIsHaving) {
            return true;
        }
        return false;
    }

    public CheckVisitor CreateNewVisitor(boolean IsExitPoint) {
        return new CheckScalarExpansion(IsExitPoint);
    }

    @Override
    public CheckVisitor CreateNewVisitor(boolean IsExitPoint, boolean IsReportComment) {
        return new CheckScalarExpansion(IsExitPoint, IsReportComment);
    }

    @Override
    public String MsgInfo() {
        return "Scalar expansion";
    }

    @Override
    public String HoverInfo() {
        return this.m_sHoverInfo;
    }

    @Override
    public String ExtraInfo() {
        return this.HoverInfo();
    }

    public int visit(IASTStatement stmt) {
        if (stmt instanceof IASTForStatement || stmt instanceof IASTDoStatement || stmt instanceof IASTWhileStatement) {
            if (stmt instanceof IASTForStatement) {
                IASTExpression conditionExp = ((IASTForStatement)stmt).getConditionExpression();
                String strChild1 = conditionExp.getChildren()[0].getRawSignature();
                String strChild2 = conditionExp.getChildren()[1].getRawSignature();
                this.condSet.add(strChild1);
                this.condSet.add(strChild2);
            }
            if (this.m_stackInsideLoop.empty()) {
                this.RootNode = stmt;
            }
            this.m_stackInsideLoop.push((IASTNode)stmt);
        }
        return 3;
    }

    public int leave(IASTStatement stmt) {
        if (stmt instanceof IASTForStatement || stmt instanceof IASTDoStatement || stmt instanceof IASTWhileStatement) {
            if (this.m_stackInsideLoop.size() == 1) {
                LinkedList<String> listLiteralExpansion = new LinkedList<String>();
                for (Map.Entry<String, Integer> entry : this.mapLValue.entrySet()) {
                    if (this.mapRValue.containsKey(entry.getKey())) {
                        if (entry.getValue() >= this.mapRValue.get(entry.getKey())) continue;
                        listLiteralExpansion.addLast(entry.getKey());
                        continue;
                    }
                    listLiteralExpansion.addLast(entry.getKey());
                }
                if (listLiteralExpansion.size() > 0) {
                    this.m_bIsHaving = true;
                    this.m_sHoverInfo = "/*\tC-OCA: Scalar expansion may need to be considered for the following scalar variables:\n";
                    for (String Literal : listLiteralExpansion) {
                        this.m_sHoverInfo = String.valueOf(this.m_sHoverInfo) + "\t\t" + Literal + "\n";
                    }
                    this.m_sHoverInfo = String.valueOf(this.m_sHoverInfo) + "*/\n";
                    m_sHoverString.insertCommentBeforNode(this.RootNode, this.m_sHoverInfo);
                }
            }
            this.m_stackInsideLoop.pop();
        }
        return 3;
    }

    private IASTStatement getEnclosingStatement(IASTNode expr) {
        IASTNode EnclosingNode = expr.getParent();
        while (!(EnclosingNode instanceof IASTStatement)) {
            EnclosingNode = EnclosingNode.getParent();
        }
        return (IASTStatement)EnclosingNode;
    }

    private IASTNode getEnclosingExpression(IASTNode expr) {
        IASTNode EnclosingNode = expr.getParent();
        while (!(EnclosingNode instanceof IASTExpression) && !(EnclosingNode instanceof IASTDeclarator) && EnclosingNode != null) {
            EnclosingNode = EnclosingNode.getParent();
        }
        return EnclosingNode;
    }

    public int visit(IASTExpression expr) {
        boolean bLValue = false;
        if (expr instanceof IASTIdExpression) {
            IASTNode EnclosingExpression = this.getEnclosingExpression((IASTNode)expr);
            if (EnclosingExpression instanceof IASTBinaryExpression) {
                IASTBinaryExpression BinaryExpression = (IASTBinaryExpression)EnclosingExpression;
                if (BinaryExpression.isLValue() && BinaryExpression.getOperand1().getRawSignature().contains(expr.getRawSignature())) {
                    bLValue = true;
                }
                if (BinaryExpression.getOperand2().getRawSignature().contains(expr.getRawSignature())) {
                    // empty if block
                }
            } else if (EnclosingExpression instanceof IASTUnaryExpression) {
                bLValue = true;
            } else if (EnclosingExpression instanceof IASTDeclarator) {
                bLValue = true;
            } else if (EnclosingExpression == null) {
                // empty if block
            }
            if (bLValue) {
                for (String co : this.condSet) {
                    if (!expr.getRawSignature().equals(co)) continue;
                    bLValue = false;
                    break;
                }
            }
            IASTStatement EnclosingStatement = this.getEnclosingStatement((IASTNode)expr);
            int iStatementLocation = EnclosingStatement.getNodeLocations()[0].getNodeOffset();
            if (bLValue) {
                this.mapLValue.put(expr.getRawSignature(), iStatementLocation);
            }
        }
        return 3;
    }
}

