/*
 * Decompiled with CFR 0.152.
 */
package cpd.checkers.core;

import cpd.checkers.core.CheckVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;

public class ScalarParallelization
extends CheckVisitor {
    private boolean m_bIsHaving;
    private Stack<IASTNode> m_stackInsideLoop;

    public ScalarParallelization(boolean IsExitPoint, boolean IsReportComment) {
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.m_bIsHaving = false;
        this.m_stackInsideLoop = new Stack();
        this.m_bExitPoint = IsExitPoint;
    }

    public ScalarParallelization(boolean IsExitPoint) {
        this(IsExitPoint, true);
    }

    @Override
    public Boolean IsHaving() {
        if (this.getIsReportComment() && this.m_bIsHaving) {
            return true;
        }
        return false;
    }

    public CheckVisitor CreateNewVisitor(boolean IsExitPoint) {
        return new ScalarParallelization(IsExitPoint);
    }

    @Override
    public CheckVisitor CreateNewVisitor(boolean IsExitPoint, boolean IsReportComment) {
        return new ScalarParallelization(IsExitPoint, IsReportComment);
    }

    @Override
    public String MsgInfo() {
        return "Local scalar parallelization";
    }

    @Override
    public String HoverInfo() {
        return this.MsgInfo();
    }

    @Override
    public String ExtraInfo() {
        return this.HoverInfo();
    }

    private void handleLocalScalarVariable(IASTForStatement stmt, VariableDeclarationsVisitor VariableDeclVisit) {
        if (VariableDeclVisit.getVariableDeclarationsSize() > 0) {
            HashSet<IASTDeclarationStatement> VariableDecl = VariableDeclVisit.getVariableDeclarations();
            for (IASTDeclarationStatement DeclStmt : VariableDecl) {
                IASTDeclaration Decl = DeclStmt.getDeclaration();
                if (!(Decl instanceof IASTSimpleDeclaration)) continue;
                IASTSimpleDeclaration SimpleDecl = (IASTSimpleDeclaration)Decl;
                IASTDeclarator[] Declarators = SimpleDecl.getDeclarators();
                String DeclaratorString = "";
                IASTDeclarator[] iASTDeclaratorArray = Declarators;
                int n = Declarators.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTDeclarator Declarator = iASTDeclaratorArray[n2];
                    if (!DeclaratorString.isEmpty()) {
                        DeclaratorString = String.valueOf(DeclaratorString) + ", ";
                    }
                    DeclaratorString = String.valueOf(DeclaratorString) + Declarator.getName();
                    ++n2;
                }
                String sHoverInfo = "/*\tC-OCA: '" + DeclaratorString + "' is OK for parallelization as it is local: \n" + "\tNeed to make sure it is always initialized or writen before read. */\n";
                m_sHoverString.insertCommentBeforNode((IASTNode)DeclStmt, sHoverInfo);
                this.m_bIsHaving = true;
            }
        }
    }

    private void handleExternalScalarVariable(IASTForStatement stmt, VariableDeclarationsVisitor VariableDeclVisit) {
        HashSet<IASTDeclarationStatement> VariableDecl = VariableDeclVisit.getVariableDeclarations();
        HashMap<String, Boolean> VariableDeclMap = new HashMap<String, Boolean>();
        for (IASTDeclarationStatement DeclStmt : VariableDecl) {
            IASTDeclarator[] Declarators;
            IASTDeclaration Decl = DeclStmt.getDeclaration();
            if (!(Decl instanceof IASTSimpleDeclaration)) continue;
            IASTSimpleDeclaration SimpleDecl = (IASTSimpleDeclaration)Decl;
            IASTDeclarator[] iASTDeclaratorArray = Declarators = SimpleDecl.getDeclarators();
            int n = Declarators.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclarator Declarator = iASTDeclaratorArray[n2];
                VariableDeclMap.put(Declarator.getName().toString(), false);
                ++n2;
            }
        }
        ExpressionStatementVisitor ExprStmtVisit = new ExpressionStatementVisitor(VariableDeclMap);
        stmt.accept((ASTVisitor)ExprStmtVisit);
        HashMap<String, Boolean> VariableExternalMap = ExprStmtVisit.getVariableExternals();
        for (Map.Entry<String, Boolean> entry : VariableExternalMap.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            String sHoverInfo = "/*\tC-OCA: " + entry.getKey() + " external scalar variable is OK for parallelization as a shared variable. */\n";
            m_sHoverString.insertCommentBeforNode((IASTNode)stmt, sHoverInfo);
        }
    }

    public int visit(IASTStatement stmt) {
        if (stmt instanceof IASTForStatement && this.m_stackInsideLoop.isEmpty()) {
            VariableDeclarationsVisitor VariableDeclVisit = new VariableDeclarationsVisitor();
            stmt.accept((ASTVisitor)VariableDeclVisit);
            this.handleLocalScalarVariable((IASTForStatement)stmt, VariableDeclVisit);
            this.handleExternalScalarVariable((IASTForStatement)stmt, VariableDeclVisit);
        }
        if (stmt instanceof IASTForStatement || stmt instanceof IASTDoStatement || stmt instanceof IASTWhileStatement) {
            this.m_stackInsideLoop.push((IASTNode)stmt);
        }
        return 3;
    }

    public int leave(IASTStatement stmt) {
        if (stmt instanceof IASTForStatement || stmt instanceof IASTDoStatement || stmt instanceof IASTWhileStatement) {
            this.m_stackInsideLoop.pop();
        }
        return 3;
    }

    private class ExpressionStatementVisitor
    extends ASTVisitor {
        private HashMap<String, Boolean> m_mapVariableDeclMap;
        private HashMap<String, Boolean> m_mapVariableExternal;

        public ExpressionStatementVisitor(HashMap<String, Boolean> VariableDeclMap) {
            this.shouldVisitExpressions = true;
            this.m_mapVariableDeclMap = VariableDeclMap;
            this.m_mapVariableExternal = new HashMap();
        }

        public HashMap<String, Boolean> getVariableExternals() {
            return this.m_mapVariableExternal;
        }

        public int visit(IASTExpression Expression2) {
            block10: {
                IASTIdExpression IdExpression;
                block9: {
                    IdExpression = null;
                    if (!(Expression2 instanceof IASTBinaryExpression)) break block9;
                    IASTBinaryExpression BinaryExpression = (IASTBinaryExpression)Expression2;
                    switch (BinaryExpression.getOperator()) {
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: {
                            if (BinaryExpression.getOperand1() instanceof IASTIdExpression && this.m_mapVariableDeclMap.get((IdExpression = (IASTIdExpression)BinaryExpression.getOperand1()).getName().toString()) == null) {
                                this.m_mapVariableExternal.put(IdExpression.getName().toString(), true);
                            }
                            if (BinaryExpression.getOperand2() instanceof IASTIdExpression && this.m_mapVariableDeclMap.get((IdExpression = (IASTIdExpression)BinaryExpression.getOperand2()).getName().toString()) == null && this.m_mapVariableExternal.get(IdExpression.getName().toString()) == null) {
                                this.m_mapVariableExternal.put(IdExpression.getName().toString(), false);
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                    break block10;
                }
                if (Expression2 instanceof IASTUnaryExpression) {
                    IASTUnaryExpression UnaryExpression = (IASTUnaryExpression)Expression2;
                    switch (UnaryExpression.getOperator()) {
                        case 0: 
                        case 1: 
                        case 9: 
                        case 10: {
                            if (!(UnaryExpression.getOperand() instanceof IASTIdExpression) || this.m_mapVariableDeclMap.get((IdExpression = (IASTIdExpression)UnaryExpression.getOperand()).getName().toString()) != null) break;
                            this.m_mapVariableExternal.put(IdExpression.getName().toString(), true);
                            break;
                        }
                    }
                }
            }
            return 3;
        }
    }

    private class VariableDeclarationsVisitor
    extends ASTVisitor {
        private HashSet<IASTDeclarationStatement> DeclStmt;

        public VariableDeclarationsVisitor() {
            this.shouldVisitStatements = true;
            this.DeclStmt = new HashSet();
        }

        public int visit(IASTStatement stmt) {
            if (stmt instanceof IASTDeclarationStatement) {
                this.DeclStmt.add((IASTDeclarationStatement)stmt);
            }
            return 3;
        }

        public HashSet<IASTDeclarationStatement> getVariableDeclarations() {
            return this.DeclStmt;
        }

        public int getVariableDeclarationsSize() {
            return this.DeclStmt.size();
        }
    }
}

