/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.io;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class BitBuffer {
    public static final int BIT_CHAR = 8;
    public static final int BIT_SHORT = 16;
    public static final int BIT_INT = 32;
    public static final int BIT_FLOAT = 32;
    public static final int BIT_LONG = 64;
    private ByteBuffer buf;
    private int pos;
    private ByteOrder byteOrder;

    public BitBuffer() {
        this(null, ByteOrder.BIG_ENDIAN);
    }

    public BitBuffer(ByteBuffer buf) {
        this(buf, ByteOrder.BIG_ENDIAN);
    }

    public BitBuffer(ByteBuffer buf, ByteOrder order) {
        this.setByteBuffer(buf);
        this.setByteOrder(order);
        this.position(0);
    }

    public int getInt() {
        return this.getInt(32, true);
    }

    public int getInt(int length, boolean signed) {
        int val = 0;
        if (!this.canRead(length)) {
            throw new BufferOverflowException();
        }
        if (length == 0) {
            return 0;
        }
        boolean gotIt = false;
        if (this.pos % 8 == 0) {
            switch (length) {
                case 8: {
                    val = signed ? (int)this.buf.get(this.pos / 8) : this.buf.get(this.pos / 8) & 0xFF;
                    gotIt = true;
                    break;
                }
                case 16: {
                    if (signed) {
                        val = this.buf.getShort(this.pos / 8);
                    } else {
                        short a = this.buf.getShort(this.pos / 8);
                        val = a & 0xFFFF;
                    }
                    gotIt = true;
                    break;
                }
                case 32: {
                    val = this.buf.getInt(this.pos / 8);
                    gotIt = true;
                    break;
                }
            }
        }
        if (!gotIt) {
            val = this.byteOrder == ByteOrder.LITTLE_ENDIAN ? this.getIntLE(this.pos, length, signed) : this.getIntBE(this.pos, length, signed);
        }
        this.pos += length;
        return val;
    }

    private int getIntBE(int index, int length, boolean signed) {
        int lshift;
        int cmask;
        int mask;
        boolean isNeg;
        assert (length > 0 && length <= 32);
        int end = index + length;
        int startByte = index / 8;
        int endByte = (end + 7) / 8;
        int value = 0;
        int currByte = startByte;
        int cache = this.buf.get(currByte) & 0xFF;
        boolean bl = isNeg = (cache & 1 << 8 - index % 8 - 1) != 0;
        if (signed && isNeg) {
            value = -1;
        }
        if (startByte == endByte - 1) {
            int cmask2 = cache >>> (8 - end % 8) % 8;
            if (length % 8 > 0) {
                int mask2 = ~(-1 << length);
                cmask2 &= mask2;
            }
            value <<= length;
            return value |= cmask2;
        }
        int cshift = index % 8;
        if (cshift > 0) {
            mask = ~(-1 << 8 - cshift);
            cmask = cache & mask;
            lshift = 8 - cshift;
            value <<= lshift;
            value |= cmask;
            ++currByte;
        }
        while (currByte < endByte - 1) {
            value <<= 8;
            value |= this.buf.get(currByte) & 0xFF;
            ++currByte;
        }
        lshift = end % 8;
        if (lshift > 0) {
            mask = ~(-1 << lshift);
            cmask = this.buf.get(currByte) & 0xFF;
            cmask >>>= 8 - lshift;
            value <<= lshift;
            value |= (cmask &= mask);
        } else {
            value <<= 8;
            value |= this.buf.get(currByte) & 0xFF;
        }
        return value;
    }

    private int getIntLE(int index, int length, boolean signed) {
        int cmask;
        int mask;
        boolean isNeg;
        assert (length > 0 && length <= 32);
        int end = index + length;
        int startByte = index / 8;
        int endByte = (end + 7) / 8;
        int value = 0;
        int currByte = endByte - 1;
        int cache = this.buf.get(currByte) & 0xFF;
        int mod = end % 8;
        int lshift = mod > 0 ? mod : 8;
        boolean bl = isNeg = (cache & 1 << lshift - 1) != 0;
        if (signed && isNeg) {
            value = -1;
        }
        if (startByte == endByte - 1) {
            int cmask2 = cache >>> index % 8;
            if (length % 8 > 0) {
                int mask2 = ~(-1 << length);
                cmask2 &= mask2;
            }
            value <<= length;
            return value |= cmask2;
        }
        int cshift = end % 8;
        if (cshift > 0) {
            mask = ~(-1 << cshift);
            cmask = cache & mask;
            value <<= cshift;
            value |= cmask;
            --currByte;
        }
        while (currByte >= startByte + 1) {
            value <<= 8;
            value |= this.buf.get(currByte) & 0xFF;
            --currByte;
        }
        lshift = index % 8;
        if (lshift > 0) {
            mask = ~(-1 << 8 - lshift);
            cmask = this.buf.get(currByte) & 0xFF;
            cmask >>>= lshift;
            value <<= 8 - lshift;
            value |= (cmask &= mask);
        } else {
            value <<= 8;
            value |= this.buf.get(currByte) & 0xFF;
        }
        return value;
    }

    public void putInt(int value) {
        this.putInt(32, value);
    }

    public void putInt(int length, int value) {
        int curPos = this.pos;
        if (!this.canRead(length)) {
            throw new BufferOverflowException();
        }
        if (length == 0) {
            return;
        }
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            this.putIntLE(curPos, length, value);
        } else {
            this.putIntBE(curPos, length, value);
        }
        this.pos += length;
    }

    private void putIntBE(int index, int length, int value) {
        int b;
        int cmask;
        int mask;
        assert (length > 0 && length <= 32);
        int end = index + length;
        int startByte = index / 8;
        int endByte = (end + 7) / 8;
        int correctedValue = value;
        if (length < 32) {
            correctedValue &= ~(-1 << length);
        }
        if (startByte == endByte - 1) {
            int lshift = (8 - end % 8) % 8;
            int mask2 = ~(-1 << lshift);
            if (index % 8 > 0) {
                mask2 |= -1 << 8 - index % 8;
            }
            int cmask2 = correctedValue << lshift;
            int b2 = this.buf.get(startByte) & 0xFF;
            this.buf.put(startByte, (byte)(b2 & mask2 | (cmask2 &= ~mask2)));
            return;
        }
        int currByte = endByte - 1;
        int cshift = end % 8;
        if (cshift > 0) {
            int lshift = 8 - cshift;
            mask = ~(-1 << lshift);
            cmask = correctedValue << lshift;
            b = this.buf.get(currByte) & 0xFF;
            this.buf.put(currByte, (byte)(b & mask | (cmask &= ~mask)));
            correctedValue >>>= cshift;
            --currByte;
        }
        while (currByte >= startByte + 1) {
            this.buf.put(currByte, (byte)correctedValue);
            correctedValue >>>= 8;
            --currByte;
        }
        if (index % 8 > 0) {
            mask = -1 << 8 - index % 8;
            cmask = correctedValue & ~mask;
            b = this.buf.get(currByte) & 0xFF;
            this.buf.put(currByte, (byte)(b & mask | cmask));
        } else {
            this.buf.put(currByte, (byte)correctedValue);
        }
    }

    private void putIntLE(int index, int length, int value) {
        int b;
        int cmask;
        int mask;
        assert (length > 0 && length <= 32);
        int end = index + length;
        int startByte = index / 8;
        int endByte = (end + 7) / 8;
        int correctedValue = value;
        if (length < 32) {
            correctedValue &= ~(-1 << length);
        }
        if (startByte == endByte - 1) {
            int lshift = index % 8;
            int mask2 = ~(-1 << lshift);
            if (end % 8 > 0) {
                mask2 |= -1 << end % 8;
            }
            int cmask2 = correctedValue << lshift;
            int b2 = this.buf.get(startByte) & 0xFF;
            this.buf.put(startByte, (byte)(b2 & mask2 | (cmask2 &= ~mask2)));
            return;
        }
        int currByte = startByte;
        int cshift = index % 8;
        if (cshift > 0) {
            mask = ~(-1 << cshift);
            cmask = correctedValue << cshift;
            b = this.buf.get(currByte) & 0xFF;
            this.buf.put(currByte, (byte)(b & mask | (cmask &= ~mask)));
            correctedValue >>>= 8 - cshift;
            ++currByte;
        }
        while (currByte < endByte - 1) {
            this.buf.put(currByte, (byte)correctedValue);
            correctedValue >>>= 8;
            ++currByte;
        }
        if (end % 8 > 0) {
            mask = -1 << end % 8;
            cmask = correctedValue & ~mask;
            b = this.buf.get(currByte) & 0xFF;
            this.buf.put(currByte, (byte)(b & mask | cmask));
        } else {
            this.buf.put(currByte, (byte)correctedValue);
        }
    }

    public boolean canRead(int length) {
        if (this.buf == null) {
            return false;
        }
        return this.pos + length <= this.buf.capacity() * 8;
    }

    public void setByteOrder(ByteOrder order) {
        this.byteOrder = order;
        if (this.buf != null) {
            this.buf.order(order);
        }
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void position(int newPosition) {
        this.pos = newPosition;
    }

    public int position() {
        return this.pos;
    }

    public void setByteBuffer(ByteBuffer buf) {
        this.buf = buf;
        if (buf != null) {
            this.buf.order(this.byteOrder);
        }
        this.clear();
    }

    public ByteBuffer getByteBuffer() {
        return this.buf;
    }

    public void clear() {
        this.position(0);
        if (this.buf == null) {
            return;
        }
        this.buf.clear();
    }
}

