/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources;

import org.eclipse.linuxtools.lttng2.kernel.core.trace.LttngKernelTrace;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class ResourcesEntry
extends TimeGraphEntry {
    private final int fId;
    private final LttngKernelTrace fTrace;
    private final Type fType;
    private final int fQuark;

    public ResourcesEntry(int quark, LttngKernelTrace trace, String name, long startTime, long endTime, Type type, int id) {
        super(name, startTime, endTime);
        this.fId = id;
        this.fTrace = trace;
        this.fType = type;
        this.fQuark = quark;
    }

    public ResourcesEntry(LttngKernelTrace trace, String name, long startTime, long endTime, int id) {
        this(-1, trace, name, startTime, endTime, Type.NULL, id);
    }

    public ResourcesEntry(int quark, LttngKernelTrace trace, long startTime, long endTime, Type type, int id) {
        this(quark, trace, String.valueOf(type.toString()) + " " + id, startTime, endTime, type, id);
    }

    public int getId() {
        return this.fId;
    }

    public LttngKernelTrace getTrace() {
        return this.fTrace;
    }

    public Type getType() {
        return this.fType;
    }

    public int getQuark() {
        return this.fQuark;
    }

    public boolean hasTimeEvents() {
        return this.fType != Type.NULL;
    }

    public void addChild(ResourcesEntry entry) {
        int index = 0;
        while (index < this.getChildren().size()) {
            ResourcesEntry other = (ResourcesEntry)((Object)this.getChildren().get(index));
            if (entry.getType().compareTo(other.getType()) < 0 || entry.getType().equals((Object)other.getType()) && entry.getId() < other.getId()) break;
            ++index;
        }
        entry.setParent(this);
        this.getChildren().add(index, entry);
    }

    public static enum Type {
        NULL,
        CPU,
        IRQ,
        SOFT_IRQ;

    }
}

