/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.charts.provider;

import java.util.List;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTViewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.ISTDataViewersField;
import org.eclipse.linuxtools.dataviewers.charts.provider.IChartField;
import org.eclipse.linuxtools.dataviewers.piechart.PieChart;
import org.eclipse.linuxtools.internal.dataviewers.charts.Activator;
import org.eclipse.linuxtools.internal.dataviewers.charts.view.ChartView;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IBarSeries;
import org.swtchart.ISeries;
import org.swtchart.ITitle;
import org.swtchart.LineStyle;

public class ChartFactory {
    public static final Chart producePieChart(Object[] objects, ISTDataViewersField nameField, List<IChartField> valFields, String title) {
        try {
            Color WHITE = PlatformUI.getWorkbench().getDisplay().getSystemColor(1);
            Color BLACK = PlatformUI.getWorkbench().getDisplay().getSystemColor(2);
            Color GRAD = PlatformUI.getWorkbench().getDisplay().getSystemColor(22);
            ChartView view = (ChartView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.dataviewers.charts.view", String.valueOf(ChartView.getSecId()), 1);
            String[] pieChartNames = new String[valFields.size()];
            int i = 0;
            while (i < valFields.size()) {
                pieChartNames[i] = valFields.get(i).getColumnHeaderText();
                ++i;
            }
            PieChart chart = new PieChart(view.getParent(), 0, pieChartNames);
            chart.setBackground(WHITE);
            chart.setBackgroundInPlotArea(GRAD);
            chart.getTitle().setText(title);
            chart.getTitle().setForeground(BLACK);
            chart.getLegend().setPosition(131072);
            String[] valueLabels = new String[objects.length];
            int i2 = 0;
            while (i2 < objects.length) {
                valueLabels[i2] = nameField.getValue(objects[i2]);
                ++i2;
            }
            double[][] doubleValues = new double[objects.length][valFields.size()];
            int i3 = 0;
            while (i3 < valFields.size()) {
                int j = 0;
                while (j < objects.length) {
                    Number num = valFields.get(i3).getNumber(objects[j]);
                    double longVal = num.doubleValue();
                    doubleValues[j][i3] = longVal + 1.0;
                    ++j;
                }
                ++i3;
            }
            chart.addPieChartSeries(valueLabels, doubleValues);
            chart.getAxisSet().adjustRange();
            return chart;
        }
        catch (PartInitException e) {
            Activator.getDefault().getLog().log(e.getStatus());
            return null;
        }
    }

    public static final Chart produceBarChart(Object[] objects, ISTDataViewersField nameField, List<IChartField> valFields, String title, boolean horizontal) {
        try {
            Color WHITE = PlatformUI.getWorkbench().getDisplay().getSystemColor(1);
            Color BLACK = PlatformUI.getWorkbench().getDisplay().getSystemColor(2);
            Color GRAD = PlatformUI.getWorkbench().getDisplay().getSystemColor(22);
            ChartView view = (ChartView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.dataviewers.charts.view", String.valueOf(ChartView.getSecId()), 1);
            Chart chart = new Chart(view.getParent(), 0);
            chart.setBackground(WHITE);
            chart.setBackgroundInPlotArea(GRAD);
            chart.getTitle().setText(title);
            chart.getTitle().setForeground(BLACK);
            if (horizontal) {
                chart.setOrientation(512);
            } else {
                chart.setOrientation(256);
            }
            chart.getLegend().setPosition(131072);
            String[] textLabels = new String[objects.length];
            int i = 0;
            while (i < objects.length) {
                textLabels[i] = nameField.getValue(objects[i]);
                ++i;
            }
            IAxis xAxis = chart.getAxisSet().getXAxis(0);
            xAxis.getGrid().setStyle(LineStyle.NONE);
            xAxis.getTick().setForeground(BLACK);
            ITitle xTitle = xAxis.getTitle();
            xTitle.setForeground(BLACK);
            xTitle.setText(nameField.getColumnHeaderText());
            xAxis.setCategorySeries(textLabels);
            xAxis.enableCategory(true);
            IAxis yAxis = chart.getAxisSet().getYAxis(0);
            yAxis.getGrid().setStyle(LineStyle.NONE);
            yAxis.getTick().setForeground(BLACK);
            yAxis.getTitle().setVisible(false);
            for (IChartField field : valFields) {
                IBarSeries bs = (IBarSeries)chart.getSeriesSet().createSeries(ISeries.SeriesType.BAR, field.getColumnHeaderText());
                bs.setBarColor(new Color((Device)Display.getDefault(), ChartFactory.getRC(), ChartFactory.getRC(), ChartFactory.getRC()));
                double[] doubleValues = new double[objects.length];
                int i2 = 0;
                while (i2 < objects.length) {
                    double longVal;
                    Number num = field.getNumber(objects[i2]);
                    doubleValues[i2] = longVal = num.doubleValue();
                    ++i2;
                }
                bs.setYSeries(doubleValues);
            }
            chart.getAxisSet().adjustRange();
            return chart;
        }
        catch (PartInitException e) {
            Activator.getDefault().getLog().log(e.getStatus());
            return null;
        }
    }

    private static int getRC() {
        return (int)(Math.random() * 255.0);
    }

    public ISTDataViewersField getLabelField(AbstractSTViewer viewer) {
        return viewer.getAllFields()[0];
    }
}

