/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.parsers.custom;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.Messages;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTraceDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CustomXmlTraceDefinition
extends CustomTraceDefinition {
    public static final String TAG_IGNORE = Messages.CustomXmlTraceDefinition_ignoreTag;
    protected static final String CUSTOM_XML_TRACE_DEFINITIONS_FILE_NAME = "custom_xml_parsers.xml";
    protected static final String CUSTOM_XML_TRACE_DEFINITIONS_PATH_NAME = Activator.getDefault().getStateLocation().addTrailingSeparator().append("custom_xml_parsers.xml").toString();
    private static final String CUSTOM_XML_TRACE_DEFINITION_ROOT_ELEMENT = Messages.CustomXmlTraceDefinition_definitionRootElement;
    private static final String DEFINITION_ELEMENT = Messages.CustomXmlTraceDefinition_definition;
    private static final String NAME_ATTRIBUTE = Messages.CustomXmlTraceDefinition_name;
    private static final String LOG_ENTRY_ATTRIBUTE = Messages.CustomXmlTraceDefinition_logEntry;
    private static final String TIME_STAMP_OUTPUT_FORMAT_ELEMENT = Messages.CustomXmlTraceDefinition_timestampOutputFormat;
    private static final String INPUT_ELEMENT_ELEMENT = Messages.CustomXmlTraceDefinition_inputElement;
    private static final String ATTRIBUTE_ELEMENT = Messages.CustomXmlTraceDefinition_attribute;
    private static final String INPUT_DATA_ELEMENT = Messages.CustomXmlTraceDefinition_inputData;
    private static final String ACTION_ATTRIBUTE = Messages.CustomXmlTraceDefinition_action;
    private static final String FORMAT_ATTRIBUTE = Messages.CustomXmlTraceDefinition_format;
    private static final String OUTPUT_COLUMN_ELEMENT = Messages.CustomXmlTraceDefinition_outputColumn;
    public InputElement rootInputElement;

    public CustomXmlTraceDefinition() {
        this("", null, new ArrayList<CustomTraceDefinition.OutputColumn>(), "");
    }

    public CustomXmlTraceDefinition(String logtype, InputElement rootElement, List<CustomTraceDefinition.OutputColumn> outputs, String timeStampOutputFormat) {
        this.definitionName = logtype;
        this.rootInputElement = rootElement;
        this.outputs = outputs;
        this.timeStampOutputFormat = timeStampOutputFormat;
    }

    @Override
    public void save() {
        this.save(CUSTOM_XML_TRACE_DEFINITIONS_PATH_NAME);
    }

    @Override
    public void save(String path) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            EntityResolver resolver = new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    String empty = "";
                    ByteArrayInputStream bais = new ByteArrayInputStream(empty.getBytes());
                    return new InputSource(bais);
                }
            };
            db.setEntityResolver(resolver);
            db.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException saxparseexception) throws SAXException {
                }

                @Override
                public void warning(SAXParseException saxparseexception) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException saxparseexception) throws SAXException {
                    throw saxparseexception;
                }
            });
            Document doc = null;
            File file = new File(path);
            if (file.canRead()) {
                doc = db.parse(file);
                if (!doc.getDocumentElement().getNodeName().equals(CUSTOM_XML_TRACE_DEFINITION_ROOT_ELEMENT)) {
                    return;
                }
            } else {
                doc = db.newDocument();
                Element node = doc.createElement(CUSTOM_XML_TRACE_DEFINITION_ROOT_ELEMENT);
                doc.appendChild(node);
            }
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node instanceof Element && node.getNodeName().equals(DEFINITION_ELEMENT) && this.definitionName.equals(((Element)node).getAttribute(NAME_ATTRIBUTE))) {
                    root.removeChild(node);
                }
                ++i;
            }
            Element definitionElement = doc.createElement(DEFINITION_ELEMENT);
            root.appendChild(definitionElement);
            definitionElement.setAttribute(NAME_ATTRIBUTE, this.definitionName);
            Element formatElement = doc.createElement(TIME_STAMP_OUTPUT_FORMAT_ELEMENT);
            definitionElement.appendChild(formatElement);
            formatElement.appendChild(doc.createTextNode(this.timeStampOutputFormat));
            if (this.rootInputElement != null) {
                definitionElement.appendChild(this.createInputElementElement(this.rootInputElement, doc));
            }
            if (this.outputs != null) {
                for (CustomTraceDefinition.OutputColumn output : this.outputs) {
                    Element outputColumnElement = doc.createElement(OUTPUT_COLUMN_ELEMENT);
                    definitionElement.appendChild(outputColumnElement);
                    outputColumnElement.setAttribute(NAME_ATTRIBUTE, output.name);
                }
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            String xmlString = result.getWriter().toString();
            FileWriter writer = new FileWriter(file);
            writer.write(xmlString);
            writer.close();
        }
        catch (ParserConfigurationException e) {
            Activator.getDefault().logError("Error saving CustomXmlTraceDefinition: path=" + path, e);
        }
        catch (TransformerConfigurationException e) {
            Activator.getDefault().logError("Error saving CustomXmlTraceDefinition: path=" + path, e);
        }
        catch (TransformerFactoryConfigurationError e) {
            Activator.getDefault().logError("Error saving CustomXmlTraceDefinition: path=" + path, e);
        }
        catch (TransformerException e) {
            Activator.getDefault().logError("Error saving CustomXmlTraceDefinition: path=" + path, e);
        }
        catch (IOException e) {
            Activator.getDefault().logError("Error saving CustomXmlTraceDefinition: path=" + path, e);
        }
        catch (SAXException e) {
            Activator.getDefault().logError("Error saving CustomXmlTraceDefinition: path=" + path, e);
        }
    }

    private Element createInputElementElement(InputElement inputElement, Document doc) {
        Element inputElementElement = doc.createElement(INPUT_ELEMENT_ELEMENT);
        inputElementElement.setAttribute(NAME_ATTRIBUTE, inputElement.elementName);
        if (inputElement.logEntry) {
            inputElementElement.setAttribute(LOG_ENTRY_ATTRIBUTE, Boolean.toString(inputElement.logEntry));
        }
        if (inputElement.parentElement != null) {
            Element inputDataElement = doc.createElement(INPUT_DATA_ELEMENT);
            inputElementElement.appendChild(inputDataElement);
            inputDataElement.setAttribute(NAME_ATTRIBUTE, inputElement.inputName);
            inputDataElement.setAttribute(ACTION_ATTRIBUTE, Integer.toString(inputElement.inputAction));
            if (inputElement.inputFormat != null) {
                inputDataElement.setAttribute(FORMAT_ATTRIBUTE, inputElement.inputFormat);
            }
        }
        if (inputElement.attributes != null) {
            for (InputAttribute attribute : inputElement.attributes) {
                Element inputAttributeElement = doc.createElement(ATTRIBUTE_ELEMENT);
                inputElementElement.appendChild(inputAttributeElement);
                inputAttributeElement.setAttribute(NAME_ATTRIBUTE, attribute.attributeName);
                Element inputDataElement = doc.createElement(INPUT_DATA_ELEMENT);
                inputAttributeElement.appendChild(inputDataElement);
                inputDataElement.setAttribute(NAME_ATTRIBUTE, attribute.inputName);
                inputDataElement.setAttribute(ACTION_ATTRIBUTE, Integer.toString(attribute.inputAction));
                if (attribute.inputFormat == null) continue;
                inputDataElement.setAttribute(FORMAT_ATTRIBUTE, attribute.inputFormat);
            }
        }
        if (inputElement.childElements != null) {
            for (InputElement childInputElement : inputElement.childElements) {
                inputElementElement.appendChild(this.createInputElementElement(childInputElement, doc));
            }
        }
        return inputElementElement;
    }

    public static CustomXmlTraceDefinition[] loadAll() {
        return CustomXmlTraceDefinition.loadAll(CUSTOM_XML_TRACE_DEFINITIONS_PATH_NAME);
    }

    public static CustomXmlTraceDefinition[] loadAll(String path) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            EntityResolver resolver = new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    String empty = "";
                    ByteArrayInputStream bais = new ByteArrayInputStream(empty.getBytes());
                    return new InputSource(bais);
                }
            };
            db.setEntityResolver(resolver);
            db.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException saxparseexception) throws SAXException {
                }

                @Override
                public void warning(SAXParseException saxparseexception) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException saxparseexception) throws SAXException {
                    throw saxparseexception;
                }
            });
            File file = new File(path);
            if (!file.canRead()) {
                return new CustomXmlTraceDefinition[0];
            }
            Document doc = db.parse(file);
            Element root = doc.getDocumentElement();
            if (!root.getNodeName().equals(CUSTOM_XML_TRACE_DEFINITION_ROOT_ELEMENT)) {
                return new CustomXmlTraceDefinition[0];
            }
            ArrayList<CustomXmlTraceDefinition> defList = new ArrayList<CustomXmlTraceDefinition>();
            NodeList nodeList = root.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                CustomXmlTraceDefinition def;
                Node node = nodeList.item(i);
                if (node instanceof Element && node.getNodeName().equals(DEFINITION_ELEMENT) && (def = CustomXmlTraceDefinition.extractDefinition((Element)node)) != null) {
                    defList.add(def);
                }
                ++i;
            }
            return defList.toArray(new CustomXmlTraceDefinition[0]);
        }
        catch (ParserConfigurationException e) {
            Activator.getDefault().logError("Error loading all in CustomXmlTraceDefinition: path=" + path, e);
        }
        catch (SAXException e) {
            Activator.getDefault().logError("Error loading all in CustomXmlTraceDefinition: path=" + path, e);
        }
        catch (IOException e) {
            Activator.getDefault().logError("Error loading all in CustomXmlTraceDefinition: path=" + path, e);
        }
        return new CustomXmlTraceDefinition[0];
    }

    public static CustomXmlTraceDefinition load(String definitionName) {
        Element root;
        block7: {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            EntityResolver resolver = new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    String empty = "";
                    ByteArrayInputStream bais = new ByteArrayInputStream(empty.getBytes());
                    return new InputSource(bais);
                }
            };
            db.setEntityResolver(resolver);
            db.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException saxparseexception) throws SAXException {
                }

                @Override
                public void warning(SAXParseException saxparseexception) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException saxparseexception) throws SAXException {
                    throw saxparseexception;
                }
            });
            File file = new File(CUSTOM_XML_TRACE_DEFINITIONS_PATH_NAME);
            Document doc = db.parse(file);
            root = doc.getDocumentElement();
            if (root.getNodeName().equals(CUSTOM_XML_TRACE_DEFINITION_ROOT_ELEMENT)) break block7;
            return null;
        }
        try {
            NodeList nodeList = root.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node instanceof Element && node.getNodeName().equals(DEFINITION_ELEMENT) && definitionName.equals(((Element)node).getAttribute(NAME_ATTRIBUTE))) {
                    return CustomXmlTraceDefinition.extractDefinition((Element)node);
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            Activator.getDefault().logError("Error loading CustomXmlTraceDefinition: definitionName=" + definitionName, e);
        }
        catch (SAXException e) {
            Activator.getDefault().logError("Error loading CustomXmlTraceDefinition: definitionName=" + definitionName, e);
        }
        catch (IOException e) {
            Activator.getDefault().logError("Error loading CustomXmlTraceDefinition: definitionName=" + definitionName, e);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CustomXmlTraceDefinition extractDefinition(Element definitionElement) {
        CustomXmlTraceDefinition def = new CustomXmlTraceDefinition();
        def.definitionName = definitionElement.getAttribute(NAME_ATTRIBUTE);
        if (def.definitionName == null) {
            return null;
        }
        NodeList nodeList = definitionElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals(TIME_STAMP_OUTPUT_FORMAT_ELEMENT)) {
                Element formatElement = (Element)node;
                def.timeStampOutputFormat = formatElement.getTextContent();
            } else if (nodeName.equals(INPUT_ELEMENT_ELEMENT)) {
                InputElement inputElement = CustomXmlTraceDefinition.extractInputElement((Element)node);
                if (inputElement != null) {
                    if (def.rootInputElement != null) return null;
                    def.rootInputElement = inputElement;
                }
            } else if (nodeName.equals(OUTPUT_COLUMN_ELEMENT)) {
                Element outputColumnElement = (Element)node;
                CustomTraceDefinition.OutputColumn outputColumn = new CustomTraceDefinition.OutputColumn();
                outputColumn.name = outputColumnElement.getAttribute(NAME_ATTRIBUTE);
                def.outputs.add(outputColumn);
            }
            ++i;
        }
        return def;
    }

    private static InputElement extractInputElement(Element inputElementElement) {
        InputElement inputElement = new InputElement();
        inputElement.elementName = inputElementElement.getAttribute(NAME_ATTRIBUTE);
        inputElement.logEntry = Boolean.toString(true).equals(inputElementElement.getAttribute(LOG_ENTRY_ATTRIBUTE));
        NodeList nodeList = inputElementElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Element childInputElementElement;
            InputElement childInputElement;
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals(INPUT_DATA_ELEMENT)) {
                Element inputDataElement = (Element)node;
                inputElement.inputName = inputDataElement.getAttribute(NAME_ATTRIBUTE);
                inputElement.inputAction = Integer.parseInt(inputDataElement.getAttribute(ACTION_ATTRIBUTE));
                inputElement.inputFormat = inputDataElement.getAttribute(FORMAT_ATTRIBUTE);
            } else if (nodeName.equals(ATTRIBUTE_ELEMENT)) {
                Element attributeElement = (Element)node;
                InputAttribute attribute = new InputAttribute();
                attribute.attributeName = attributeElement.getAttribute(NAME_ATTRIBUTE);
                NodeList attributeNodeList = attributeElement.getChildNodes();
                int j = 0;
                while (j < attributeNodeList.getLength()) {
                    Node attributeNode = attributeNodeList.item(j);
                    String attributeNodeName = attributeNode.getNodeName();
                    if (attributeNodeName.equals(INPUT_DATA_ELEMENT)) {
                        Element inputDataElement = (Element)attributeNode;
                        attribute.inputName = inputDataElement.getAttribute(NAME_ATTRIBUTE);
                        attribute.inputAction = Integer.parseInt(inputDataElement.getAttribute(ACTION_ATTRIBUTE));
                        attribute.inputFormat = inputDataElement.getAttribute(FORMAT_ATTRIBUTE);
                    }
                    ++j;
                }
                inputElement.addAttribute(attribute);
            } else if (nodeName.equals(INPUT_ELEMENT_ELEMENT) && (childInputElement = CustomXmlTraceDefinition.extractInputElement(childInputElementElement = (Element)node)) != null) {
                inputElement.addChild(childInputElement);
            }
            ++i;
        }
        return inputElement;
    }

    public static void delete(String definitionName) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            EntityResolver resolver = new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    String empty = "";
                    ByteArrayInputStream bais = new ByteArrayInputStream(empty.getBytes());
                    return new InputSource(bais);
                }
            };
            db.setEntityResolver(resolver);
            db.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException saxparseexception) throws SAXException {
                }

                @Override
                public void warning(SAXParseException saxparseexception) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException saxparseexception) throws SAXException {
                    throw saxparseexception;
                }
            });
            File file = new File(CUSTOM_XML_TRACE_DEFINITIONS_PATH_NAME);
            Document doc = db.parse(file);
            Element root = doc.getDocumentElement();
            if (!root.getNodeName().equals(CUSTOM_XML_TRACE_DEFINITION_ROOT_ELEMENT)) {
                return;
            }
            NodeList nodeList = root.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node instanceof Element && node.getNodeName().equals(DEFINITION_ELEMENT) && definitionName.equals(((Element)node).getAttribute(NAME_ATTRIBUTE))) {
                    root.removeChild(node);
                }
                ++i;
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            String xmlString = result.getWriter().toString();
            FileWriter writer = new FileWriter(file);
            writer.write(xmlString);
            writer.close();
        }
        catch (ParserConfigurationException e) {
            Activator.getDefault().logError("Error deleteing CustomXmlTraceDefinition: definitionName=" + definitionName, e);
        }
        catch (SAXException e) {
            Activator.getDefault().logError("Error deleteing CustomXmlTraceDefinition: definitionName=" + definitionName, e);
        }
        catch (IOException e) {
            Activator.getDefault().logError("Error deleteing CustomXmlTraceDefinition: definitionName=" + definitionName, e);
        }
        catch (TransformerConfigurationException e) {
            Activator.getDefault().logError("Error deleteing CustomXmlTraceDefinition: definitionName=" + definitionName, e);
        }
        catch (TransformerFactoryConfigurationError e) {
            Activator.getDefault().logError("Error deleteing CustomXmlTraceDefinition: definitionName=" + definitionName, e);
        }
        catch (TransformerException e) {
            Activator.getDefault().logError("Error deleteing CustomXmlTraceDefinition: definitionName=" + definitionName, e);
        }
    }

    public static class InputAttribute {
        public String attributeName;
        public String inputName;
        public int inputAction;
        public String inputFormat;

        public InputAttribute() {
        }

        public InputAttribute(String attributeName, String inputName, int inputAction, String inputFormat) {
            this.attributeName = attributeName;
            this.inputName = inputName;
            this.inputAction = inputAction;
            this.inputFormat = inputFormat;
        }
    }

    public static class InputElement {
        public String elementName;
        public boolean logEntry;
        public String inputName;
        public int inputAction;
        public String inputFormat;
        public List<InputAttribute> attributes;
        public InputElement parentElement;
        public InputElement nextElement;
        public List<InputElement> childElements;

        public InputElement() {
        }

        public InputElement(String elementName, boolean logEntry, String inputName, int inputAction, String inputFormat, List<InputAttribute> attributes) {
            this.elementName = elementName;
            this.logEntry = logEntry;
            this.inputName = inputName;
            this.inputAction = inputAction;
            this.inputFormat = inputFormat;
            this.attributes = attributes;
        }

        public void addAttribute(InputAttribute attribute) {
            if (this.attributes == null) {
                this.attributes = new ArrayList<InputAttribute>(1);
            }
            this.attributes.add(attribute);
        }

        public void addChild(InputElement input) {
            if (this.childElements == null) {
                this.childElements = new ArrayList<InputElement>(1);
            } else if (this.childElements.size() > 0) {
                InputElement last = this.childElements.get(this.childElements.size() - 1);
                last.nextElement = input;
            }
            this.childElements.add(input);
            input.parentElement = this;
        }

        public void addNext(InputElement input) {
            if (this.parentElement != null) {
                int index = this.parentElement.childElements.indexOf(this);
                this.parentElement.childElements.add(index + 1, input);
                InputElement next = this.nextElement;
                this.nextElement = input;
                input.nextElement = next;
            }
            input.parentElement = this.parentElement;
        }

        public void moveUp() {
            int index;
            if (this.parentElement != null && (index = this.parentElement.childElements.indexOf(this)) > 0) {
                this.parentElement.childElements.add(index - 1, this.parentElement.childElements.remove(index));
                this.parentElement.childElements.get((int)index).nextElement = this.nextElement;
                this.nextElement = this.parentElement.childElements.get(index);
            }
        }

        public void moveDown() {
            int index;
            if (this.parentElement != null && (index = this.parentElement.childElements.indexOf(this)) < this.parentElement.childElements.size() - 1) {
                this.parentElement.childElements.add(index + 1, this.parentElement.childElements.remove(index));
                this.nextElement = this.parentElement.childElements.get((int)index).nextElement;
                this.parentElement.childElements.get((int)index).nextElement = this;
            }
        }
    }
}

