/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.model.TmfImportHelper;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.AbstractTracePackageOperation;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.AbstractTracePackageWizardPage;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageTraceElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.TracePackageExtractManifestOperation;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.TracePackageImportOperation;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfNavigatorContentProvider;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TraceUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ImportTracePackageWizardPage
extends AbstractTracePackageWizardPage {
    private static final String ICON_PATH = "icons/wizban/trace_import_wiz.png";
    private static final String PAGE_NAME = "ImportTracePackagePage";
    private static final String STORE_PROJECT_NAME_ID = "ImportTracePackagePage.STORE_PROJECT_NAME_ID";
    private String fValidatedFilePath;
    private TmfTraceFolder fTmfTraceFolder;
    private Text fProjectText;
    private List<IProject> fOpenedTmfProjects;

    public ImportTracePackageWizardPage(IStructuredSelection selection) {
        super(PAGE_NAME, Messages.ImportTracePackageWizardPage_Title, Activator.getDefault().getImageDescripterFromPath(ICON_PATH), selection);
        if (this.getSelection().getFirstElement() instanceof TmfTraceFolder) {
            this.fTmfTraceFolder = (TmfTraceFolder)this.getSelection().getFirstElement();
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.createFilePathGroup(composite, Messages.ImportTracePackageWizardPage_FromArchive, 4096);
        this.createElementViewer(composite);
        this.createButtonsGroup(composite);
        if (this.fTmfTraceFolder == null) {
            this.createProjectSelectionGroup(composite);
        }
        this.restoreWidgetValues();
        this.setMessage(Messages.ImportTracePackageWizardPage_Message);
        this.updatePageCompletion();
        this.setControl((Control)composite);
    }

    private void createProjectSelectionGroup(Composite parent) {
        IProject defaultProject;
        Composite projectSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        projectSelectionGroup.setLayout((Layout)layout);
        projectSelectionGroup.setLayoutData((Object)new GridData(272));
        Label projectLabel = new Label(projectSelectionGroup, 0);
        projectLabel.setText(Messages.ImportTracePackageWizardPage_Project);
        this.fProjectText = new Text(projectSelectionGroup, 2060);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.fProjectText.setLayoutData((Object)data);
        this.fOpenedTmfProjects = TraceUtils.getOpenedTmfProjects();
        if (this.fOpenedTmfProjects.isEmpty() && !(defaultProject = ResourcesPlugin.getWorkspace().getRoot().getProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME)).exists()) {
            IProject project = TmfProjectRegistry.createProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME, null, null);
            TmfImportHelper.forceFolderRefresh(project.getFolder("Traces"));
            this.fOpenedTmfProjects.add(project);
        }
        if (!this.fOpenedTmfProjects.isEmpty()) {
            this.selectProject(this.fOpenedTmfProjects.get(0));
        }
        Button button = new Button(projectSelectionGroup, 8);
        button.setText(Messages.ImportTracePackageWizardPage_SelectProjectButton);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ElementListSelectionDialog d = new ElementListSelectionDialog(ImportTracePackageWizardPage.this.getContainer().getShell(), (ILabelProvider)new WorkbenchLabelProvider());
                d.setBlockOnOpen(true);
                d.setTitle(Messages.ImportTracePackageWizardPage_SelectProjectDialogTitle);
                d.setElements((Object[])ImportTracePackageWizardPage.this.fOpenedTmfProjects.toArray(new IProject[0]));
                d.open();
                if (d.getFirstResult() != null) {
                    IProject project = (IProject)d.getFirstResult();
                    ImportTracePackageWizardPage.this.selectProject(project);
                }
            }
        });
        this.setButtonLayoutData(button);
    }

    @Override
    protected void restoreWidgetValues() {
        String projectName;
        super.restoreWidgetValues();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && this.fProjectText != null && (projectName = settings.get(STORE_PROJECT_NAME_ID)) != null && !projectName.isEmpty()) {
            for (IProject project : this.fOpenedTmfProjects) {
                if (!project.getName().equals(projectName)) continue;
                this.selectProject(project);
                break;
            }
        }
    }

    @Override
    protected void saveWidgetValues() {
        super.saveWidgetValues();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_PROJECT_NAME_ID, this.fTmfTraceFolder.getProject().getResource().getName());
        }
    }

    private void selectProject(IProject project) {
        this.fProjectText.setText(project.getName());
        new TmfNavigatorContentProvider().getChildren(project);
        this.fTmfTraceFolder = TmfProjectRegistry.getProject(project).getTracesFolder();
        this.updatePageCompletion();
    }

    @Override
    protected boolean determinePageCompletion() {
        return super.determinePageCompletion() && this.fTmfTraceFolder != null;
    }

    @Override
    protected Object createElementViewerInput() {
        TracePackageElement[] resultElements;
        final TracePackageExtractManifestOperation op = new TracePackageExtractManifestOperation(this.getFilePathValue());
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.ImportTracePackageWizardPage_ReadingPackage, 10);
                    op.run(monitor);
                    monitor.done();
                }
            });
            IStatus status = op.getStatus();
            if (status.getSeverity() == 4) {
                this.handleErrorStatus(status);
            }
        }
        catch (InvocationTargetException e1) {
            this.handleError(Messages.TracePackageExtractManifestOperation_ErrorReadingManifest, e1);
        }
        catch (InterruptedException e1) {
            // empty catch block
        }
        if ((resultElements = op.getResultElement()) == null || resultElements.length == 0) {
            return null;
        }
        return resultElements;
    }

    @Override
    protected void createFilePathGroup(Composite parent, String label, int fileDialogStyle) {
        super.createFilePathGroup(parent, label, fileDialogStyle);
        Combo filePathCombo = this.getFilePathCombo();
        filePathCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTracePackageWizardPage.this.updateWithFilePathSelection();
            }
        });
        filePathCombo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    ImportTracePackageWizardPage.this.updateWithFilePathSelection();
                }
            }
        });
    }

    @Override
    protected void updateWithFilePathSelection() {
        if (!this.isFilePathValid()) {
            this.setErrorMessage(Messages.ImportTracePackageWizardPage_ErrorFileNotFound);
            this.getElementViewer().setInput(null);
            return;
        }
        this.setErrorMessage(null);
        this.getContainer().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                CheckboxTreeViewer elementViewer = ImportTracePackageWizardPage.this.getElementViewer();
                Object elementViewerInput = ImportTracePackageWizardPage.this.createElementViewerInput();
                elementViewer.setInput(elementViewerInput);
                if (elementViewerInput != null) {
                    elementViewer.expandToLevel(2);
                    ImportTracePackageWizardPage.setAllChecked(elementViewer, false, true);
                    ImportTracePackageWizardPage.this.fValidatedFilePath = ImportTracePackageWizardPage.this.getFilePathValue();
                }
                ImportTracePackageWizardPage.this.updatePageCompletion();
            }
        });
    }

    private boolean isFilePathValid() {
        return new File(this.getFilePathValue()).exists();
    }

    public boolean finish() {
        if (!this.checkForOverwrite()) {
            return false;
        }
        this.saveWidgetValues();
        Object input = this.getElementViewer().getInput();
        TracePackageElement[] traceElements = (TracePackageElement[])input;
        final TracePackageImportOperation importOperation = new TracePackageImportOperation(this.fValidatedFilePath, traceElements, this.fTmfTraceFolder);
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    importOperation.run(monitor);
                }
            });
            IStatus status = importOperation.getStatus();
            if (status.getSeverity() == 4) {
                this.handleErrorStatus(status);
            }
        }
        catch (InvocationTargetException e) {
            this.handleError(Messages.ImportTracePackageWizardPage_ErrorOperation, e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return importOperation.getStatus().getSeverity() == 0;
    }

    private boolean checkForOverwrite() {
        TracePackageElement[] traceElements = (TracePackageElement[])this.getElementViewer().getInput();
        ArrayList<TracePackageTraceElement> noImportTraces = new ArrayList<TracePackageTraceElement>();
        boolean noToAll = false;
        TracePackageElement[] tracePackageElementArray = traceElements;
        int n = traceElements.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement packageElement = tracePackageElementArray[n2];
            TracePackageTraceElement traceElement = (TracePackageTraceElement)packageElement;
            if (AbstractTracePackageOperation.isFilesChecked(traceElement)) {
                if (noToAll) {
                    noImportTraces.add(traceElement);
                } else {
                    String traceName = traceElement.getText();
                    if (this.traceExists(traceName)) {
                        int returnCode = this.promptForOverwrite(traceName);
                        String[] response = new String[]{IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.YES_LABEL};
                        if (response[returnCode].equals(IDialogConstants.YES_TO_ALL_LABEL)) break;
                        if (response[returnCode].equals(IDialogConstants.NO_TO_ALL_LABEL)) {
                            noToAll = true;
                            noImportTraces.add(traceElement);
                        } else if (response[returnCode].equals(IDialogConstants.NO_LABEL)) {
                            noImportTraces.add(traceElement);
                        }
                    }
                }
            }
            ++n2;
        }
        for (TracePackageTraceElement t : noImportTraces) {
            TracePackageElement[] tracePackageElementArray2 = t.getChildren();
            int n3 = tracePackageElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TracePackageElement e = tracePackageElementArray2[n4];
                if (e instanceof TracePackageFilesElement) {
                    ((TracePackageFilesElement)e).setChecked(false);
                }
                ++n4;
            }
        }
        return true;
    }

    private boolean traceExists(String traceName) {
        List<TmfTraceElement> traces = this.fTmfTraceFolder.getTraces();
        for (TmfTraceElement t : traces) {
            if (!t.getName().equals(traceName)) continue;
            return true;
        }
        return false;
    }

    private int promptForOverwrite(String traceName) {
        MessageDialog dialog = new MessageDialog(this.getContainer().getShell(), null, null, MessageFormat.format(Messages.ImportTracePackageWizardPage_AlreadyExists, traceName), 3, new String[]{IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.YES_LABEL}, 3){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        return dialog.open();
    }
}

