/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.model;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectModelElement;

public abstract class TmfWithFolderElement
extends TmfProjectModelElement {
    public TmfWithFolderElement(String name, IResource resource, TmfProjectModelElement parent) {
        super(name, resource, parent);
    }

    protected String getResourceName() {
        return String.valueOf(this.fResource.getName()) + this.getSuffix();
    }

    protected String getSuffix() {
        return "";
    }

    public void deleteSupplementaryFolder() {
        IFolder supplFolder = this.getTraceSupplementaryFolder(this.getResourceName());
        if (supplFolder.exists()) {
            try {
                supplFolder.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error deleting supplementary folder " + supplFolder, e);
            }
        }
    }

    public void renameSupplementaryFolder(String newName) {
        IFolder oldSupplFolder = this.getTraceSupplementaryFolder(this.getResourceName());
        IFolder newSupplFolder = this.getTraceSupplementaryFolder(String.valueOf(newName) + this.getSuffix());
        if (oldSupplFolder.exists()) {
            try {
                oldSupplFolder.move(newSupplFolder.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error renaming supplementary folder " + oldSupplFolder, e);
            }
        }
    }

    public void copySupplementaryFolder(String newName) {
        IFolder oldSupplFolder = this.getTraceSupplementaryFolder(this.getResourceName());
        IFolder newSupplFolder = this.getTraceSupplementaryFolder(String.valueOf(newName) + this.getSuffix());
        if (oldSupplFolder.exists()) {
            try {
                oldSupplFolder.copy(newSupplFolder.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error renaming supplementary folder " + oldSupplFolder, e);
            }
        }
    }

    public void copySupplementaryFolder(IFolder destination) {
        IFolder oldSupplFolder = this.getTraceSupplementaryFolder(this.getResourceName());
        if (oldSupplFolder.exists()) {
            try {
                oldSupplFolder.copy(destination.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error copying supplementary folder " + oldSupplFolder, e);
            }
        }
    }

    public void refreshSupplementaryFolder() {
        this.createSupplementaryDirectory();
    }

    public boolean hasSupplementaryResources() {
        IResource[] resources = this.getSupplementaryResources();
        return resources.length > 0;
    }

    public IResource[] getSupplementaryResources() {
        IFolder supplFolder = this.getTraceSupplementaryFolder(this.getResourceName());
        if (supplFolder.exists()) {
            try {
                return supplFolder.members();
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error deleting supplementary folder " + supplFolder, e);
            }
        }
        return new IResource[0];
    }

    public void deleteSupplementaryResources(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            try {
                resources[i].delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error deleting supplementary resource " + resources[i], e);
            }
            ++i;
        }
    }

    public void deleteSupplementaryResources() {
        this.deleteSupplementaryResources(this.getSupplementaryResources());
    }

    private void createSupplementaryDirectory() {
        IFolder supplFolder = this.getTraceSupplementaryFolder(this.getResourceName());
        if (!supplFolder.exists()) {
            try {
                supplFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error creating resource supplementary file " + supplFolder, e);
            }
        }
        try {
            this.fResource.setPersistentProperty(TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER, supplFolder.getLocationURI().getPath());
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error setting persistant property " + TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER, e);
        }
    }

    public IResource copy(String newName, boolean copySuppFiles) {
        IPath newPath = this.getParent().getResource().getFullPath().addTrailingSeparator().append(newName);
        if (copySuppFiles) {
            this.copySupplementaryFolder(newName);
        }
        try {
            this.getResource().copy(newPath, 33, null);
            IFolder folder = ((IFolder)this.getParent().getResource()).getFolder(newName);
            if (folder.exists()) {
                IResource[] iResourceArray = folder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (TmfTrace.class.getCanonicalName().equals(member.getPersistentProperty(TmfCommonConstants.TRACETYPE))) {
                        member.delete(true, null);
                    }
                    if (TmfExperiment.class.getCanonicalName().equals(member.getPersistentProperty(TmfCommonConstants.TRACETYPE))) {
                        member.delete(true, null);
                    }
                    ++n2;
                }
            }
            return folder;
        }
        catch (CoreException coreException) {
            return null;
        }
    }
}

