/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.model;

import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public class TraceTypeHelper {
    private final String fName;
    private final String fCategoryName;
    private final String fCanonicalName;
    private final ITmfTrace fTrace;

    public TraceTypeHelper(String canonicalName, String categoryName, String name, ITmfTrace trace) {
        this.fName = name;
        this.fCategoryName = categoryName;
        this.fCanonicalName = canonicalName;
        this.fTrace = trace;
    }

    public String getName() {
        return this.fName;
    }

    public String getCategoryName() {
        return this.fCategoryName;
    }

    public String getCanonicalName() {
        return this.fCanonicalName;
    }

    public boolean validate(String path) {
        boolean valid = false;
        if (this.fTrace != null) {
            valid = this.standardValidate(path);
        }
        return valid;
    }

    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    private boolean standardValidate(String path) {
        boolean valid = this.fTrace.validate(null, path).equals(Status.OK_STATUS);
        return valid;
    }

    public String toString() {
        return this.fName;
    }
}

