/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.callstack;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.EventIterator;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;

public class CallStackEntry
implements ITimeGraphEntry {
    private final int fQuark;
    private final int fStackLevel;
    private final ITmfTrace fTrace;
    private ITimeGraphEntry fParent = null;
    private String fName;
    private String fFunctionName;
    private long fStartTime;
    private long fEndTime;
    private List<ITimeEvent> fEventList = new ArrayList<ITimeEvent>(1);
    private List<ITimeEvent> fZoomedEventList = null;

    public CallStackEntry(int quark, int stackLevel, ITmfTrace trace) {
        this.fQuark = quark;
        this.fStackLevel = stackLevel;
        this.fTrace = trace;
        this.fFunctionName = "";
    }

    @Override
    public ITimeGraphEntry getParent() {
        return this.fParent;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    public List<CallStackEntry> getChildren() {
        return null;
    }

    @Override
    public String getName() {
        return "";
    }

    public String getFunctionName() {
        return this.fFunctionName;
    }

    public void setFunctionName(String functionName) {
        this.fFunctionName = functionName;
    }

    @Override
    public long getStartTime() {
        return this.fStartTime;
    }

    public void setStartTime(long startTime) {
        this.fStartTime = startTime;
    }

    @Override
    public long getEndTime() {
        return this.fEndTime;
    }

    public void setEndTime(long endTime) {
        this.fEndTime = endTime;
    }

    @Override
    public boolean hasTimeEvents() {
        return this.fEventList != null;
    }

    public Iterator<ITimeEvent> getTimeEventsIterator() {
        return new EventIterator(this.fEventList, this.fZoomedEventList);
    }

    public Iterator<ITimeEvent> getTimeEventsIterator(long startTime, long stopTime, long visibleDuration) {
        return new EventIterator(this.fEventList, this.fZoomedEventList, startTime, stopTime);
    }

    public void setParent(ITimeGraphEntry parent) {
        this.fParent = parent;
    }

    public int getQuark() {
        return this.fQuark;
    }

    public int getStackLevel() {
        return this.fStackLevel;
    }

    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    public void setEventList(List<ITimeEvent> eventList) {
        this.fEventList = eventList;
        if (eventList != null && eventList.size() > 0) {
            this.fStartTime = eventList.get(0).getTime();
            ITimeEvent lastEvent = eventList.get(eventList.size() - 1);
            this.fEndTime = lastEvent.getTime() + lastEvent.getDuration();
        }
    }

    public void setZoomedEventList(List<ITimeEvent> eventList) {
        this.fZoomedEventList = eventList;
    }

    public void addEvent(ITimeEvent timeEvent) {
        this.fEventList.add(timeEvent);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " name=" + this.fName;
    }
}

