/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.environment;

import java.util.Map;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTraceProperties;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class TmfEnvironmentView
extends TmfView {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.views.environment";
    private ITmfTrace fTrace;
    private Tree fTree;

    public TmfEnvironmentView() {
        super("EnvironmentVariables");
    }

    public void createPartControl(Composite parent) {
        this.fTree = new Tree(parent, 0);
        TreeColumn nameCol = new TreeColumn(this.fTree, 0, 0);
        TreeColumn valueCol = new TreeColumn(this.fTree, 0, 1);
        nameCol.setText("Environment Variable");
        valueCol.setText("Value");
        this.fTree.setItemCount(0);
        this.fTree.setHeaderVisible(true);
        nameCol.pack();
        valueCol.pack();
        ITmfTrace trace = this.getActiveTrace();
        if (trace != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
    }

    private void updateTable() {
        this.fTree.setItemCount(0);
        if (this.fTrace == null) {
            return;
        }
        ITmfTrace[] iTmfTraceArray = TmfTraceManager.getTraceSet((ITmfTrace)this.fTrace);
        int n = iTmfTraceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTrace trace = iTmfTraceArray[n2];
            if (trace instanceof ITmfTraceProperties) {
                TreeItem item = new TreeItem(this.fTree, 0);
                item.setText(0, trace.getName());
                ITmfTraceProperties propTrace = (ITmfTraceProperties)trace;
                Map properties = propTrace.getTraceProperties();
                for (Map.Entry entry : properties.entrySet()) {
                    TreeItem subItem = new TreeItem(item, 0);
                    subItem.setText(0, (String)entry.getKey());
                    subItem.setText(1, (String)entry.getValue());
                }
            }
            ++n2;
        }
        int i = 0;
        while (i < this.fTree.getItemCount()) {
            this.fTree.getItem(i).setExpanded(true);
            ++i;
        }
        iTmfTraceArray = this.fTree.getColumns();
        n = iTmfTraceArray.length;
        n2 = 0;
        while (n2 < n) {
            ITmfTrace column = iTmfTraceArray[n2];
            column.pack();
            ++n2;
        }
    }

    public void setFocus() {
        this.fTree.setFocus();
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.fTrace = signal.getTrace();
        this.updateTable();
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        ITmfTrace trace = signal.getTrace();
        if (!trace.equals(this.fTrace)) {
            this.fTrace = trace;
            this.updateTable();
        }
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        if (signal.getTrace() == this.fTrace) {
            this.fTrace = null;
            this.fTree.setItemCount(0);
        }
    }
}

