/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.histogram;

import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfLostEvent;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramDataModel;

public class HistogramRequest
extends TmfEventRequest {
    protected final HistogramDataModel fHistogram;
    private final boolean fFullRange;

    @Deprecated
    public HistogramRequest(HistogramDataModel histogram, TmfTimeRange range, int rank, int nbEvents, int blockSize, ITmfDataRequest.ExecutionType execType) {
        super(ITmfEvent.class, range, (long)rank, nbEvents, blockSize > 0 ? blockSize : 1000, execType);
        this.fHistogram = histogram;
        this.fFullRange = execType != ITmfDataRequest.ExecutionType.FOREGROUND;
    }

    public HistogramRequest(HistogramDataModel histogram, TmfTimeRange range, int rank, int nbEvents, int blockSize, ITmfDataRequest.ExecutionType execType, boolean fullRange) {
        super(ITmfEvent.class, range, (long)rank, nbEvents, blockSize > 0 ? blockSize : 1000, execType);
        this.fHistogram = histogram;
        this.fFullRange = fullRange;
    }

    public void handleData(ITmfEvent event) {
        super.handleData(event);
        if (event != null) {
            if (event instanceof ITmfLostEvent) {
                ITmfLostEvent lostEvents = (ITmfLostEvent)event;
                this.fHistogram.countLostEvent(lostEvents.getTimeRange(), lostEvents.getNbLostEvents(), this.fFullRange);
            } else {
                long timestamp = event.getTimestamp().normalize(0L, -9).getValue();
                this.fHistogram.countEvent(this.getNbRead(), timestamp);
            }
        }
    }

    public void handleCompleted() {
        this.fHistogram.complete();
        super.handleCompleted();
    }
}

