/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.DiagramToolTip;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.ITimeCompressionListener;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.NGC;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.SDView;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.SDWidgetSelectionProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.ScrollView;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.TimeCompressionBar;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.BaseMessage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.BasicExecutionOccurrence;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Frame;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.ITimeRange;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Lifeline;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Metrics;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.dialogs.SDPrintDialog;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.dialogs.SDPrintDialogUI;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IColor;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDCollapseProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.load.LoadersManager;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.preferences.SDViewPref;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.Messages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;

public class SDWidget
extends ScrollView
implements SelectionListener,
IPropertyChangeListener,
DisposeListener,
ITimeCompressionListener {
    private Frame fFrame;
    private Image fOverView = null;
    private MenuItem fZoomIn = null;
    private MenuItem fZoomOut = null;
    private SDWidgetSelectionProvider fSelProvider = null;
    private float fZoomValue = 1.0f;
    private boolean fZoomInMode = false;
    private boolean fZoomOutMode = false;
    private List<GraphNode> fSelectedNodeList = null;
    private boolean fCtrlSelection = false;
    private ViewPart fSite = null;
    private GraphNode fCurrentGraphNode = null;
    private GraphNode fListStart = null;
    private List<GraphNode> fPrevList = null;
    private TimeCompressionBar fTimeBar = null;
    private DiagramToolTip fToolTip = null;
    private Accessible fAccessible = null;
    private GraphNode fToolTipNode;
    private Lifeline fDragAndDrop = null;
    private int fFocusedWidget = -1;
    private float fPrinterZoom = 0.0f;
    private int fPrinterY = 0;
    private int fPrinterX = 0;
    private boolean fIsDragAndDrop = false;
    private int fDragX = 0;
    private int fDragY = 0;
    private boolean fReorderMode = false;
    private Image fCollapaseCaretImg = null;
    private Image fArrowUpCaretImg = null;
    private Image fCurrentCaretImage = null;
    private ISDCollapseProvider fCollapseProvider = null;
    private Caret fInsertionCartet = null;
    private List<Lifeline[]> fReorderList = null;
    private boolean fIsPrinting = false;
    private Printer fPrinter = null;
    private boolean fShiftSelection = false;
    private DiagramToolTip fScrollToolTip = null;
    private AutoScroll fLocalAutoScroll = null;
    private Timer fLocalAutoScrollTimer = null;

    public SDWidget(Composite c, int s) {
        super(c, s | 0x40000, true);
        this.setOverviewEnabled(true);
        this.fSelectedNodeList = new ArrayList<GraphNode>();
        this.fSelProvider = new SDWidgetSelectionProvider();
        SDViewPref.getInstance().addPropertyChangeListener(this);
        this.fToolTip = new DiagramToolTip(this.getViewControl());
        super.addDisposeListener((DisposeListener)this);
        this.fScrollToolTip = new DiagramToolTip((Control)c);
        this.getVerticalBar().addListener(4, new Listener(){

            public void handleEvent(Event event) {
                SDWidget.this.fScrollToolTip.hideToolTip();
            }
        });
        this.fAccessible = this.getViewControl().getAccessible();
        this.fAccessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == 0) {
                    if (SDWidget.this.fToolTipNode != null) {
                        if (SDWidget.this.fToolTipNode instanceof Lifeline) {
                            Lifeline lifeline = (Lifeline)SDWidget.this.fToolTipNode;
                            e.result = lifeline.getToolTipText();
                        } else {
                            e.result = String.valueOf(SDWidget.this.fToolTipNode.getName()) + SDWidget.this.getPostfixForTooltip(true);
                        }
                    }
                } else if (SDWidget.this.getFocusNode() != null) {
                    if (SDWidget.this.getFocusNode() instanceof Lifeline) {
                        e.result = MessageFormat.format(Messages.SequenceDiagram_LifelineNode, String.valueOf(SDWidget.this.getFocusNode().getName()));
                    }
                    if (SDWidget.this.getFocusNode() instanceof BaseMessage) {
                        BaseMessage mes = (BaseMessage)SDWidget.this.getFocusNode();
                        if (mes.getStartLifeline() != null && mes.getEndLifeline() != null) {
                            e.result = MessageFormat.format(Messages.SequenceDiagram_MessageNode, String.valueOf(mes.getName()), String.valueOf(mes.getStartLifeline().getName()), mes.getStartOccurrence(), String.valueOf(mes.getEndLifeline().getName()), mes.getEndOccurrence());
                        } else if (mes.getStartLifeline() == null && mes.getEndLifeline() != null) {
                            e.result = MessageFormat.format(Messages.SequenceDiagram_FoundMessageNode, String.valueOf(mes.getName()), String.valueOf(mes.getEndLifeline().getName()), mes.getEndOccurrence());
                        } else if (mes.getStartLifeline() != null && mes.getEndLifeline() == null) {
                            e.result = MessageFormat.format(Messages.SequenceDiagram_LostMessageNode, String.valueOf(mes.getName()), String.valueOf(mes.getStartLifeline().getName()), mes.getStartOccurrence());
                        }
                    } else if (SDWidget.this.getFocusNode() instanceof BasicExecutionOccurrence) {
                        BasicExecutionOccurrence exec = (BasicExecutionOccurrence)SDWidget.this.getFocusNode();
                        e.result = MessageFormat.format(Messages.SequenceDiagram_ExecutionOccurrenceWithParams, String.valueOf(exec.getName()), String.valueOf(exec.getLifeline().getName()), exec.getStartOccurrence(), exec.getEndOccurrence());
                    }
                }
            }
        });
        this.fAccessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getFocus(AccessibleControlEvent e) {
                e.childID = SDWidget.this.fFocusedWidget == -1 ? -1 : SDWidget.this.fFocusedWidget;
            }

            public void getRole(AccessibleControlEvent e) {
                switch (e.childID) {
                    case -1: {
                        e.detail = 10;
                        break;
                    }
                    case 0: {
                        e.detail = 13;
                        break;
                    }
                    case 1: {
                        e.detail = 41;
                        break;
                    }
                }
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0x100000;
                if (e.childID == -1) {
                    e.detail |= 4;
                } else {
                    e.detail |= 0x200000;
                    if (e.childID == SDWidget.this.fFocusedWidget) {
                        e.detail |= 0x16;
                    }
                }
            }
        });
        this.fInsertionCartet = new Caret((Canvas)this.getViewControl(), 0);
        this.fInsertionCartet.setVisible(false);
        this.fCollapaseCaretImg = Activator.getDefault().getImageFromPath("icons/obj16/arrow_colapse.bmp");
        this.fArrowUpCaretImg = Activator.getDefault().getImageFromPath("icons/obj16/arrow_up.bmp");
        this.fReorderList = new ArrayList<Lifeline[]>();
        this.getViewControl().addTraverseListener((TraverseListener)new LocalTraverseListener());
        this.addTraverseListener(new LocalTraverseListener());
        this.getViewControl().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                SDViewPref.getInstance().setNoFocusSelection(false);
                SDWidget.this.fCtrlSelection = false;
                SDWidget.this.fShiftSelection = false;
                SDWidget.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                SDViewPref.getInstance().setNoFocusSelection(true);
                SDWidget.this.redraw();
            }
        });
    }

    public void setTimeBar(TimeCompressionBar bar) {
        if (bar != null) {
            this.fTimeBar = bar;
            this.fTimeBar.addTimeCompressionListener(this);
        }
    }

    public void resizeContents(Frame frame) {
        int width = Math.round((float)(frame.getWidth() + 20) * this.fZoomValue);
        int height = Math.round((float)(frame.getHeight() + 20) * this.fZoomValue);
        this.resizeContents(width, height);
    }

    public void setFrame(Frame theFrame, boolean resetPosition) {
        this.fReorderList.clear();
        this.fSelectedNodeList.clear();
        this.fSelProvider.setSelection((ISelection)new StructuredSelection());
        this.fFrame = theFrame;
        if (resetPosition) {
            this.setContentsPos(0, 0);
            this.resizeContents(this.fFrame);
            this.redraw();
        }
        if (this.fOverView != null) {
            this.fOverView.dispose();
        }
        this.fOverView = null;
        this.resizeContents(this.fFrame);
    }

    public Frame getFrame() {
        return this.fFrame;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.fSelProvider;
    }

    public List<GraphNode> getSelection() {
        return this.fSelectedNodeList;
    }

    public void addSelection(GraphNode node) {
        if (node == null) {
            return;
        }
        this.fSelectedNodeList.add(node);
        node.setSelected(true);
        this.fCurrentGraphNode = node;
        StructuredSelection selection = new StructuredSelection(this.fSelectedNodeList);
        this.fSelProvider.setSelection((ISelection)selection);
    }

    public void addSelection(List<GraphNode> list) {
        int i = 0;
        while (i < list.size()) {
            if (!this.fSelectedNodeList.contains(list.get(i))) {
                this.fSelectedNodeList.add(list.get(i));
                list.get(i).setSelected(true);
            }
            ++i;
        }
        StructuredSelection selection = new StructuredSelection(this.fSelectedNodeList);
        this.fSelProvider.setSelection((ISelection)selection);
    }

    public void removeSelection(GraphNode node) {
        this.fSelectedNodeList.remove(node);
        node.setSelected(false);
        node.setFocused(false);
        StructuredSelection selection = new StructuredSelection(this.fSelectedNodeList);
        this.fSelProvider.setSelection((ISelection)selection);
    }

    public void removeSelection(List<GraphNode> list) {
        this.fSelectedNodeList.removeAll(list);
        int i = 0;
        while (i < list.size()) {
            list.get(i).setSelected(false);
            list.get(i).setFocused(false);
            ++i;
        }
        StructuredSelection selection = new StructuredSelection(this.fSelectedNodeList);
        this.fSelProvider.setSelection((ISelection)selection);
    }

    public void clearSelection() {
        int i = 0;
        while (i < this.fSelectedNodeList.size()) {
            this.fSelectedNodeList.get(i).setSelected(false);
            this.fSelectedNodeList.get(i).setFocused(false);
            ++i;
        }
        this.fCurrentGraphNode = null;
        this.fSelectedNodeList.clear();
        this.fSelProvider.setSelection((ISelection)new StructuredSelection());
    }

    public void setSite(ViewPart viewSite) {
        this.fSite = viewSite;
        this.fSite.getSite().setSelectionProvider((ISelectionProvider)this.fSelProvider);
        IContextService service = (IContextService)this.fSite.getSite().getWorkbenchWindow().getService(IContextService.class);
        service.activateContext("org.eclipse.linuxtools.tmf.ui.view.uml2sd.context");
        service.activateContext("org.eclipse.ui.contexts.window");
    }

    public GraphNode getMouseOverNode() {
        return this.fCurrentGraphNode;
    }

    public void setZoomInMode(boolean value) {
        if (value) {
            this.setZoomOutMode(false);
        }
        this.fZoomInMode = value;
    }

    public void setZoomOutMode(boolean value) {
        if (value) {
            this.setZoomInMode(false);
        }
        this.fZoomOutMode = value;
    }

    public void setZoomValue(float zoomValue) {
        this.fZoomValue = zoomValue;
    }

    public void moveTo(GraphNode node) {
        if (node == null) {
            return;
        }
        this.clearSelection();
        this.addSelection(node);
        this.ensureVisible(node);
    }

    public void ensureVisible(GraphNode node) {
        if (node == null) {
            return;
        }
        int x = Math.round((float)node.getX() * this.fZoomValue);
        int y = Math.round((float)node.getY() * this.fZoomValue);
        int width = Math.round((float)node.getWidth() * this.fZoomValue);
        int height = Math.round((float)node.getHeight() * this.fZoomValue);
        if (node instanceof BaseMessage && height == 0) {
            int header = 8 + Metrics.getLifelineHeaderFontHeigth();
            height = -Math.round((float)(Metrics.getMessagesSpacing() + header) * this.fZoomValue);
            y += Math.round(10.0f * this.fZoomValue);
        }
        if (node instanceof BasicExecutionOccurrence) {
            width = 1;
            height = 1;
        }
        if (node instanceof Lifeline) {
            y = this.getContentsY();
            height = this.getVisibleHeight();
        }
        this.ensureVisible(x, y, width, height, 0x1000000, true);
        this.redraw();
    }

    public float getZoomFactor() {
        return this.fZoomValue;
    }

    public Printer getPrinter() {
        return this.fPrinter;
    }

    public boolean isPrinting() {
        return this.fIsPrinting;
    }

    public GraphNode getCurrentGraphNode() {
        return this.fCurrentGraphNode;
    }

    public float getZoomValue() {
        return this.fZoomValue;
    }

    public boolean getZoomInMode() {
        return this.fZoomInMode;
    }

    public boolean getZoomOutMode() {
        return this.fZoomOutMode;
    }

    public boolean isCtrlSelection() {
        return this.fCtrlSelection;
    }

    public boolean isShiftSelection() {
        return this.fCtrlSelection;
    }

    public Image getOverview(Rectangle rect) {
        float oldzoom = this.fZoomValue;
        if (this.fOverView != null && (rect.width != this.fOverView.getBounds().width || rect.height != this.fOverView.getBounds().height)) {
            this.fOverView.dispose();
            this.fOverView = null;
        }
        if (this.fOverView == null) {
            int backX = this.getContentsX();
            int backY = this.getContentsY();
            this.setContentsPos(0, 0);
            this.fOverView = new Image((Device)this.getDisplay(), rect.width, rect.height);
            GC gcim = new GC((Drawable)this.fOverView);
            NGC context = new NGC(this, gcim);
            context.setBackground(SDViewPref.getInstance().getBackGroundColor("PREF_FRAME"));
            this.fFrame.draw(context);
            this.setContentsPos(backX, backY);
            gcim.dispose();
            context.dispose();
        }
        this.fZoomValue = oldzoom;
        return this.fOverView;
    }

    public void resetZoomFactor() {
        int currentX = Math.round((float)this.getContentsX() / this.fZoomValue);
        int currentY = Math.round((float)this.getContentsY() / this.fZoomValue);
        this.fZoomValue = 1.0f;
        if (this.fTimeBar != null && !this.fTimeBar.isDisposed()) {
            this.fTimeBar.setZoom(this.fZoomValue);
        }
        this.redraw();
        this.update();
        this.setContentsPos(currentX, currentY);
    }

    public void setReorderMode(boolean mode) {
        this.fReorderMode = mode;
    }

    public List<Lifeline[]> getLifelineReoderList() {
        return this.fReorderList;
    }

    public void setFocus(GraphNode node) {
        if (node == null) {
            return;
        }
        if (this.fCurrentGraphNode != null) {
            this.fCurrentGraphNode.setFocused(false);
        }
        this.fCurrentGraphNode = node;
        node.setFocused(true);
        this.ensureVisible(node);
        this.setFocus(0);
    }

    public GraphNode getFocusNode() {
        return this.fCurrentGraphNode;
    }

    public void traverseRight() {
        GraphNode selectedNode = this.getFocusNode();
        if (selectedNode == null) {
            this.traverseLeft();
        }
        GraphNode node = null;
        if (selectedNode instanceof BaseMessage && ((BaseMessage)selectedNode).getEndLifeline() != null) {
            node = this.fFrame.getCalledMessage((BaseMessage)selectedNode);
        }
        if (selectedNode instanceof BasicExecutionOccurrence) {
            selectedNode = ((BasicExecutionOccurrence)selectedNode).getLifeline();
        }
        if (node == null && selectedNode instanceof Lifeline) {
            int i = 0;
            while (i < this.fFrame.lifeLinesCount()) {
                if (selectedNode == this.fFrame.getLifeline(i) && i < this.fFrame.lifeLinesCount() - 1) {
                    node = this.fFrame.getLifeline(i + 1);
                    break;
                }
                ++i;
            }
        }
        if (node != null) {
            this.setFocus(node);
            this.redraw();
        }
    }

    public void traverseLeft() {
        GraphNode selectedNode = this.getFocusNode();
        GraphNode node = null;
        if (selectedNode instanceof BaseMessage && ((BaseMessage)selectedNode).getStartLifeline() != null) {
            node = this.fFrame.getCallerMessage((BaseMessage)selectedNode);
        }
        if (selectedNode instanceof BasicExecutionOccurrence) {
            selectedNode = ((BasicExecutionOccurrence)selectedNode).getLifeline();
        }
        if (node == null) {
            if (selectedNode instanceof BaseMessage && ((BaseMessage)selectedNode).getEndLifeline() != null) {
                selectedNode = ((BaseMessage)selectedNode).getEndLifeline();
            }
            int i = 0;
            while (i < this.fFrame.lifeLinesCount()) {
                if (selectedNode == this.fFrame.getLifeline(i) && i > 0) {
                    node = this.fFrame.getLifeline(i - 1);
                    break;
                }
                ++i;
            }
            if (this.fFrame.lifeLinesCount() > 0 && node == null) {
                node = this.fFrame.getLifeline(0);
            }
        }
        if (node != null) {
            this.setFocus(node);
            this.redraw();
        }
    }

    public void traverseUp() {
        GraphNode selectedNode = this.getFocusNode();
        if (selectedNode == null) {
            this.traverseLeft();
        }
        GraphNode node = null;
        if (selectedNode instanceof BaseMessage) {
            node = this.fFrame.getPrevLifelineMessage(((BaseMessage)selectedNode).getStartLifeline(), (BaseMessage)selectedNode);
        } else if (selectedNode instanceof Lifeline) {
            node = this.fFrame.getPrevLifelineMessage((Lifeline)selectedNode, null);
            if (!(node instanceof Lifeline)) {
                node = null;
            }
        } else if (selectedNode instanceof BasicExecutionOccurrence && (node = this.fFrame.getPrevExecOccurrence((BasicExecutionOccurrence)selectedNode)) == null) {
            node = ((BasicExecutionOccurrence)selectedNode).getLifeline();
        }
        if (node == null && selectedNode instanceof BaseMessage && ((BaseMessage)selectedNode).getStartLifeline() != null) {
            node = ((BaseMessage)selectedNode).getStartLifeline();
        }
        if (node != null) {
            this.setFocus(node);
            this.redraw();
        }
    }

    public void traverseDown() {
        GraphNode node;
        GraphNode selectedNode = this.getFocusNode();
        if (selectedNode == null) {
            this.traverseLeft();
        }
        if (selectedNode instanceof BaseMessage) {
            node = this.fFrame.getNextLifelineMessage(((BaseMessage)selectedNode).getStartLifeline(), (BaseMessage)selectedNode);
        } else if (selectedNode instanceof Lifeline) {
            node = this.fFrame.getFirstExecution((Lifeline)selectedNode);
        } else if (selectedNode instanceof BasicExecutionOccurrence) {
            node = this.fFrame.getNextExecOccurrence((BasicExecutionOccurrence)selectedNode);
        } else {
            return;
        }
        if (node != null) {
            this.setFocus(node);
            this.redraw();
        }
    }

    public void traverseHome() {
        GraphNode selectedNode = this.getFocusNode();
        if (selectedNode == null) {
            this.traverseLeft();
        }
        GraphNode node = null;
        if (selectedNode instanceof BaseMessage) {
            node = ((BaseMessage)selectedNode).getStartLifeline() != null ? this.fFrame.getNextLifelineMessage(((BaseMessage)selectedNode).getStartLifeline(), null) : this.fFrame.getNextLifelineMessage(((BaseMessage)selectedNode).getEndLifeline(), null);
        } else if (selectedNode instanceof Lifeline) {
            node = this.fFrame.getNextLifelineMessage((Lifeline)selectedNode, null);
        } else if (selectedNode instanceof BasicExecutionOccurrence) {
            node = this.fFrame.getFirstExecution(((BasicExecutionOccurrence)selectedNode).getLifeline());
        } else if (this.fFrame.lifeLinesCount() > 0) {
            Lifeline lifeline = this.fFrame.getLifeline(0);
            node = this.fFrame.getNextLifelineMessage(lifeline, null);
        }
        if (node != null) {
            this.setFocus(node);
            this.redraw();
        }
    }

    public void traverseEnd() {
        GraphNode node;
        GraphNode selectedNode = this.getFocusNode();
        if (selectedNode == null) {
            this.traverseLeft();
        }
        if (selectedNode instanceof BaseMessage) {
            node = this.fFrame.getPrevLifelineMessage(((BaseMessage)selectedNode).getStartLifeline(), null);
        } else if (selectedNode instanceof Lifeline) {
            node = this.fFrame.getPrevLifelineMessage((Lifeline)selectedNode, null);
        } else if (selectedNode instanceof BasicExecutionOccurrence) {
            node = this.fFrame.getLastExecOccurrence(((BasicExecutionOccurrence)selectedNode).getLifeline());
        } else if (this.fFrame.lifeLinesCount() > 0) {
            Lifeline lifeline = this.fFrame.getLifeline(0);
            node = this.fFrame.getPrevLifelineMessage(lifeline, null);
        } else {
            return;
        }
        if (node != null) {
            this.setFocus(node);
            this.redraw();
        }
    }

    public void printUI(SDPrintDialogUI sdPrintDialog) {
        PrinterData data = sdPrintDialog.getPrinterData();
        if (data == null || this.fFrame == null) {
            return;
        }
        this.fPrinter = new Printer(data);
        String jobName = MessageFormat.format(Messages.SequenceDiagram_plus, String.valueOf(this.fSite.getContentDescription()), String.valueOf(this.fFrame.getName()));
        this.fPrinter.startJob(jobName);
        GC gc = new GC((Drawable)this.fPrinter);
        float lastZoom = this.fZoomValue;
        Rectangle area = this.getClientArea();
        GC gcim = null;
        gcim = gc;
        NGC context = new NGC(this, gcim);
        Metrics.setLifelineFontHeight(context.getFontHeight(SDViewPref.getInstance().getFont("PREF_LIFELINE")));
        Metrics.setLifelineFontWidth(context.getFontWidth(SDViewPref.getInstance().getFont("PREF_LIFELINE")));
        Metrics.setLifelineWidth(SDViewPref.getInstance().getLifelineWidth());
        Metrics.setFrameFontHeight(context.getFontHeight(SDViewPref.getInstance().getFont("PREF_FRAME_NAME")));
        Metrics.setLifelineHeaderFontHeight(context.getFontHeight(SDViewPref.getInstance().getFont("PREF_LIFELINE_HEADER")));
        int syncMessFontH = context.getFontHeight(SDViewPref.getInstance().getFont("PREF_SYNC_MESS"));
        int syncMessRetFontH = context.getFontHeight(SDViewPref.getInstance().getFont("PREF_SYNC_MESS_RET"));
        int asyncMessFontH = context.getFontHeight(SDViewPref.getInstance().getFont("PREF_ASYNC_MESS"));
        int asyncMessRetFontH = context.getFontHeight(SDViewPref.getInstance().getFont("PREF_ASYNC_MESS_RET"));
        int messageFontHeight = 0;
        messageFontHeight = syncMessFontH > syncMessRetFontH ? syncMessFontH : syncMessRetFontH;
        if (messageFontHeight < asyncMessFontH) {
            messageFontHeight = asyncMessFontH;
        }
        if (messageFontHeight < asyncMessRetFontH) {
            messageFontHeight = asyncMessRetFontH;
        }
        Metrics.setMessageFontHeight(messageFontHeight);
        context.setFont(SDViewPref.getInstance().getFont("PREF_LIFELINE"));
        int width = Math.round((float)(this.fFrame.getWidth() + 20) * this.fZoomValue);
        int height = Math.round((float)(this.fFrame.getHeight() + 20) * this.fZoomValue);
        if (width < area.width) {
            width = area.width;
        }
        if (height < area.height) {
            height = area.height;
        }
        this.resizeContents(width, height);
        context.setBackground(SDViewPref.getInstance().getBackGroundColor("PREF_FRAME"));
        context.fillRectangle(0, 0, this.getContentsWidth(), 10);
        context.fillRectangle(0, 0, this.fFrame.getX(), this.getContentsHeight());
        context.fillRectangle(this.fFrame.getX() + this.fFrame.getWidth() + 1, 0, this.getContentsWidth() - (this.fFrame.getX() + this.fFrame.getWidth() + 1), this.getContentsHeight());
        context.fillRectangle(0, this.fFrame.getY() + this.fFrame.getHeight() + 1, this.getContentsWidth(), this.getContentsHeight() - (this.fFrame.getY() + this.fFrame.getHeight() + 1));
        gcim.setLineWidth(1);
        this.fPrinter.startPage();
        this.fZoomValue = lastZoom;
        int restoreX = this.getContentsX();
        int restoreY = this.getContentsY();
        float zh = sdPrintDialog.getStepY() * sdPrintDialog.getZoomFactor();
        float zw = sdPrintDialog.getStepX() * sdPrintDialog.getZoomFactor();
        float zoomValueH = (float)this.fPrinter.getClientArea().height / zh;
        float zoomValueW = (float)this.fPrinter.getClientArea().width / zw;
        this.fPrinterZoom = zoomValueH > zoomValueW ? zoomValueH : zoomValueW;
        if (sdPrintDialog.printSelection()) {
            int[] pagesList = sdPrintDialog.getPageList();
            int pageIndex = 0;
            while (pageIndex < pagesList.length) {
                this.printPage(pagesList[pageIndex], sdPrintDialog, context);
                ++pageIndex;
            }
        } else if (sdPrintDialog.printAll()) {
            int pageIndex = 1;
            while (pageIndex <= sdPrintDialog.maxNumOfPages()) {
                this.printPage(pageIndex, sdPrintDialog, context);
                ++pageIndex;
            }
        } else if (sdPrintDialog.printCurrent()) {
            this.printPage(this.getContentsX(), this.getContentsY(), sdPrintDialog, context, 1);
        } else if (sdPrintDialog.printRange()) {
            int pageIndex = sdPrintDialog.getFrom();
            while (pageIndex <= sdPrintDialog.maxNumOfPages() && pageIndex <= sdPrintDialog.getTo()) {
                this.printPage(pageIndex, sdPrintDialog, context);
                ++pageIndex;
            }
        }
        this.fPrinter.endJob();
        this.fIsPrinting = false;
        gc.dispose();
        context.dispose();
        this.fZoomValue = lastZoom;
        this.fPrinter.dispose();
        this.setContentsPos(restoreX, restoreY);
    }

    public void print() {
        SDPrintDialog sdPrinter = new SDPrintDialog(this.getShell(), this);
        try {
            if (sdPrinter.open() != 0) {
                return;
            }
        }
        catch (Exception e) {
            Activator.getDefault().logError("Error creating image", e);
            return;
        }
        this.printUI(sdPrinter.getDialogUI());
    }

    public void printPage(int pageNum, SDPrintDialogUI pd, NGC context) {
        int j = pageNum / pd.getNbRow();
        int i = pageNum % pd.getNbRow();
        if (i != 0) {
            ++j;
        } else {
            i = pd.getNbRow();
        }
        --i;
        --j;
        i = (int)((float)i * pd.getStepX());
        j = (int)((float)j * pd.getStepY());
        this.printPage(i, j, pd, context, pageNum);
        this.fPrinter.endPage();
    }

    public void printPage(int i, int j, SDPrintDialogUI pd, NGC context, int pageNum) {
        this.fIsPrinting = false;
        int pageNumFontZoom = this.fPrinter.getClientArea().height / this.getVisibleHeight();
        this.fPrinterX = i;
        this.fPrinterY = j;
        this.setContentsPos(i, j);
        this.update();
        this.fIsPrinting = true;
        float lastZoom = this.fZoomValue;
        this.fZoomValue = this.fPrinterZoom * lastZoom;
        this.fFrame.draw(context);
        this.fZoomValue = pageNumFontZoom;
        context.setFont(SDViewPref.getInstance().getFont("PREF_LIFELINE"));
        String currentPageNum = String.valueOf(pageNum);
        int ii = context.textExtent(currentPageNum);
        int jj = context.getCurrentFontHeight();
        this.fZoomValue = this.fPrinterZoom * lastZoom;
        context.drawText(currentPageNum, Math.round((float)this.fPrinterX + (float)this.getVisibleWidth() / this.fPrinterZoom - (float)ii / this.fPrinterZoom), Math.round((float)this.fPrinterY + (float)this.getVisibleHeight() / this.fPrinterZoom - (float)jj / this.fPrinterZoom), false);
        this.fIsPrinting = false;
        this.fZoomValue = lastZoom;
    }

    protected void setCollapseProvider(ISDCollapseProvider provider) {
        this.fCollapseProvider = provider;
    }

    protected boolean checkFocusOnChilds(Control children) {
        if (children instanceof Composite) {
            Control[] child = ((Composite)children).getChildren();
            int i = 0;
            while (i < child.length) {
                if (child[i].isFocusControl()) {
                    return true;
                }
                this.checkFocusOnChilds(child[i]);
                ++i;
            }
        }
        return false;
    }

    protected String getPostfixForTooltip(boolean accessible) {
        StringBuffer postfix = new StringBuffer();
        if (this.fCurrentGraphNode != null && this.fCurrentGraphNode instanceof ITimeRange && this.fToolTipNode instanceof ITimeRange && this.fCurrentGraphNode != this.fToolTipNode && ((ITimeRange)((Object)this.fToolTipNode)).hasTimeInfo() && ((ITimeRange)((Object)this.fCurrentGraphNode)).hasTimeInfo()) {
            postfix.append(" -> ");
            postfix.append(this.fCurrentGraphNode.getName());
            postfix.append("\n");
            postfix.append(Messages.SequenceDiagram_Delta);
            postfix.append(" ");
            ITmfTimestamp firstTime = ((ITimeRange)((Object)this.fCurrentGraphNode)).getEndTime();
            ITmfTimestamp lastTime = ((ITimeRange)((Object)this.fToolTipNode)).getEndTime();
            ITmfTimestamp delta = lastTime.getDelta(firstTime);
            postfix.append(delta.toString());
        } else if (this.fToolTipNode instanceof ITimeRange && ((ITimeRange)((Object)this.fToolTipNode)).hasTimeInfo()) {
            postfix.append("\n");
            ITmfTimestamp firstTime = ((ITimeRange)((Object)this.fToolTipNode)).getStartTime();
            ITmfTimestamp lastTime = ((ITimeRange)((Object)this.fToolTipNode)).getEndTime();
            if (firstTime != null) {
                if (lastTime != null && firstTime.compareTo(lastTime, true) != 0) {
                    postfix.append("start: ");
                    postfix.append(firstTime.toString());
                    postfix.append("\n");
                    postfix.append("end: ");
                    postfix.append(lastTime.toString());
                    postfix.append("\n");
                } else {
                    postfix.append(firstTime.toString());
                }
            } else if (lastTime != null) {
                postfix.append(lastTime.toString());
            }
        }
        return postfix.toString();
    }

    protected void setFocus(int newFocusShape) {
        this.fFocusedWidget = newFocusShape;
        if (this.fFocusedWidget == -1) {
            this.getViewControl().getAccessible().setFocus(-1);
        } else {
            this.getViewControl().getAccessible().setFocus(this.fFocusedWidget);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void performSelection(GraphNode node) {
        if (this.fCtrlSelection || this.fShiftSelection) {
            if (node == null) return;
            if (this.fSelectedNodeList.contains(node)) {
                this.removeSelection(node);
                return;
            } else {
                this.addSelection(node);
            }
            return;
        } else {
            this.clearSelection();
            if (node == null) return;
            this.addSelection(node);
        }
    }

    protected Image getDrawBuffer() {
        this.update();
        Rectangle area = this.getClientArea();
        Image dbuffer = new Image((Device)this.getDisplay(), area.width, area.height);
        GC gcim = new GC((Drawable)dbuffer);
        NGC context = new NGC(this, gcim);
        Metrics.setLifelineFontHeight(context.getFontHeight(SDViewPref.getInstance().getFont("PREF_LIFELINE")));
        Metrics.setLifelineFontWidth(context.getFontWidth(SDViewPref.getInstance().getFont("PREF_LIFELINE")));
        Metrics.setLifelineWidth(SDViewPref.getInstance().getLifelineWidth());
        Metrics.setFrameFontHeight(context.getFontHeight(SDViewPref.getInstance().getFont("PREF_FRAME_NAME")));
        Metrics.setLifelineHeaderFontHeight(context.getFontHeight(SDViewPref.getInstance().getFont("PREF_LIFELINE_HEADER")));
        int syncMessFontH = context.getFontHeight(SDViewPref.getInstance().getFont("PREF_SYNC_MESS"));
        int syncMessRetFontH = context.getFontHeight(SDViewPref.getInstance().getFont("PREF_SYNC_MESS_RET"));
        int asyncMessFontH = context.getFontHeight(SDViewPref.getInstance().getFont("PREF_ASYNC_MESS"));
        int asyncMessRetFontH = context.getFontHeight(SDViewPref.getInstance().getFont("PREF_ASYNC_MESS_RET"));
        int messageFontHeight = 0;
        messageFontHeight = syncMessFontH > syncMessRetFontH ? syncMessFontH : syncMessRetFontH;
        if (messageFontHeight < asyncMessFontH) {
            messageFontHeight = asyncMessFontH;
        }
        if (messageFontHeight < asyncMessRetFontH) {
            messageFontHeight = asyncMessRetFontH;
        }
        Metrics.setMessageFontHeight(messageFontHeight);
        context.setFont(SDViewPref.getInstance().getFont("PREF_LIFELINE"));
        int width = (int)((float)(this.fFrame.getWidth() + 20) * this.fZoomValue);
        int height = (int)((float)(this.fFrame.getHeight() + 20) * this.fZoomValue);
        this.resizeContents(width, height);
        context.setBackground(SDViewPref.getInstance().getBackGroundColor("PREF_FRAME"));
        context.fillRectangle(0, 0, this.getContentsWidth(), 10);
        context.fillRectangle(0, 0, this.fFrame.getX(), this.getContentsHeight());
        context.fillRectangle(this.fFrame.getX() + this.fFrame.getWidth() + 1, 0, this.getContentsWidth() - (this.fFrame.getX() + this.fFrame.getWidth() + 1), this.getContentsHeight());
        context.fillRectangle(0, this.fFrame.getY() + this.fFrame.getHeight() + 1, this.getContentsWidth(), this.getContentsHeight() - (this.fFrame.getY() + this.fFrame.getHeight() + 1));
        gcim.setLineWidth(1);
        this.fFrame.draw(context);
        if (this.fDragAndDrop != null) {
            Lifeline node = this.fDragAndDrop;
            boolean isSelected = this.fDragAndDrop.isSelected();
            boolean hasFocus = this.fDragAndDrop.hasFocus();
            node.setSelected(false);
            node.setFocused(false);
            node.draw(context, this.fDragX, this.fDragY);
            node.setSelected(isSelected);
            node.setFocused(hasFocus);
        }
        gcim.dispose();
        context.dispose();
        return dbuffer;
    }

    @Override
    protected void keyPressedEvent(KeyEvent event) {
        if (!this.isFocusControl() && !this.getViewControl().isFocusControl()) {
            Control[] child = this.getParent().getChildren();
            int i = 0;
            while (i < child.length) {
                if (child[i].isFocusControl() && !(child[i] instanceof ScrollView)) {
                    this.getViewControl().setFocus();
                    break;
                }
                ++i;
            }
        }
        this.setFocus(-1);
        if (event.keyCode == 262144) {
            this.fCtrlSelection = true;
        }
        if (event.keyCode == 131072) {
            this.fShiftSelection = true;
            this.fPrevList = new ArrayList<GraphNode>();
            this.fPrevList.addAll(this.getSelection());
        }
        GraphNode prevNode = this.getFocusNode();
        if (event.keyCode == 0x1000004) {
            this.traverseRight();
        }
        if (event.keyCode == 0x1000003) {
            this.traverseLeft();
        }
        if (event.keyCode == 0x1000002) {
            this.traverseDown();
        }
        if (event.keyCode == 0x1000001) {
            this.traverseUp();
        }
        if (event.keyCode == 0x1000007) {
            this.traverseHome();
        }
        if (event.keyCode == 0x1000008) {
            this.traverseEnd();
        }
        if (!this.fShiftSelection && !this.fCtrlSelection) {
            this.fListStart = this.fCurrentGraphNode;
        }
        if (event.character == ' ') {
            this.performSelection(this.fCurrentGraphNode);
            if (!this.fShiftSelection) {
                this.fListStart = this.fCurrentGraphNode;
            }
        }
        if (this.fShiftSelection && prevNode != this.getFocusNode()) {
            this.clearSelection();
            this.addSelection(this.fPrevList);
            this.addSelection(this.fFrame.getNodeList(this.fListStart, this.getFocusNode()));
            if (this.getFocusNode() instanceof Lifeline) {
                this.ensureVisible(this.getFocusNode().getX(), this.getFocusNode().getY(), this.getFocusNode().getWidth(), this.getFocusNode().getHeight(), 0x1000200, true);
            } else {
                this.ensureVisible(this.getFocusNode());
            }
        } else if (!this.fCtrlSelection && !this.fShiftSelection) {
            this.clearSelection();
            if (this.getFocusNode() != null) {
                this.addSelection(this.getFocusNode());
                if (this.getFocusNode() instanceof Lifeline) {
                    this.ensureVisible(this.getFocusNode().getX(), this.getFocusNode().getY(), this.getFocusNode().getWidth(), this.getFocusNode().getHeight(), 0x1000200, true);
                } else {
                    this.ensureVisible(this.getFocusNode());
                }
            }
        }
        if (this.fCurrentGraphNode != null) {
            this.fCurrentGraphNode.setFocused(true);
        }
        this.redraw();
        if (event.character == ' ' && (this.fZoomInMode || this.fZoomOutMode)) {
            int cx = Math.round((float)(this.getContentsX() + this.getVisibleWidth() / 2) / this.fZoomValue);
            int cy = Math.round((float)(this.getContentsY() + this.getVisibleHeight() / 2) / this.fZoomValue);
            if (this.fZoomInMode) {
                if (this.fZoomValue < 64.0f) {
                    this.fZoomValue *= 1.25f;
                }
            } else {
                this.fZoomValue /= 1.25f;
            }
            int x = Math.round((float)cx * this.fZoomValue - (float)this.getVisibleWidth() / 2.0f);
            int y = Math.round((float)cy * this.fZoomValue - (float)this.getVisibleHeight() / 2.0f);
            this.setContentsPos(x, y);
            if (this.fTimeBar != null) {
                this.fTimeBar.setZoom(this.fZoomValue);
            }
            this.redraw();
        }
    }

    @Override
    protected void keyReleasedEvent(KeyEvent event) {
        this.setFocus(-1);
        if (event.keyCode == 262144) {
            this.fCtrlSelection = false;
        }
        if (event.keyCode == 131072) {
            this.fShiftSelection = false;
        }
        super.keyReleasedEvent(event);
        this.setFocus(1);
    }

    public boolean isFocusControl() {
        Control[] child = this.getChildren();
        int i = 0;
        while (i < child.length) {
            if (child[i].isFocusControl()) {
                return true;
            }
            this.checkFocusOnChilds(child[i]);
            ++i;
        }
        return false;
    }

    @Override
    public boolean setContentsPos(int x, int y) {
        int localX = x;
        int localY = y;
        if (localX < 0) {
            localX = 0;
        }
        if (localY < 0) {
            localY = 0;
        }
        if (this.fFrame == null) {
            return false;
        }
        if (localX + this.getVisibleWidth() > this.getContentsWidth()) {
            localX = this.getContentsWidth() - this.getVisibleWidth();
        }
        if (localY + this.getVisibleHeight() > this.getContentsHeight()) {
            localY = this.getContentsHeight() - this.getVisibleHeight();
        }
        int x1 = Math.round((float)localX / this.fZoomValue);
        int y2 = Math.round((float)localY / this.fZoomValue);
        int width = Math.round((float)this.getVisibleWidth() / this.fZoomValue);
        int height = Math.round((float)this.getVisibleHeight() / this.fZoomValue);
        this.fFrame.updateIndex(x1, y2, width, height);
        if (this.fInsertionCartet != null && this.fInsertionCartet.isVisible()) {
            this.fInsertionCartet.setVisible(false);
        }
        return super.setContentsPos(localX, localY);
    }

    @Override
    protected void contentsMouseHover(MouseEvent event) {
        GraphNode graphNode = null;
        if (this.fFrame != null) {
            int y;
            int x = Math.round((float)event.x / this.fZoomValue);
            graphNode = this.fFrame.getNodeAt(x, y = Math.round((float)event.y / this.fZoomValue));
            if (graphNode != null && SDViewPref.getInstance().tooltipEnabled()) {
                this.fToolTipNode = graphNode;
                String postfix = this.getPostfixForTooltip(true);
                if (graphNode instanceof Lifeline) {
                    Lifeline lifeline = (Lifeline)graphNode;
                    this.fToolTip.showToolTip(String.valueOf(lifeline.getToolTipText()) + postfix);
                    this.setFocus(0);
                } else {
                    this.fToolTip.showToolTip(String.valueOf(graphNode.getName()) + postfix);
                    this.setFocus(0);
                }
            } else {
                this.fToolTip.hideToolTip();
            }
        }
    }

    @Override
    protected void contentsMouseMoveEvent(MouseEvent e) {
        this.fScrollToolTip.hideToolTip();
        this.fToolTip.hideToolTip();
        if (!this.isFocusControl() && !this.getViewControl().isFocusControl()) {
            Control[] child = this.getParent().getChildren();
            int i = 0;
            while (i < child.length) {
                if (child[i].isFocusControl() && !(child[i] instanceof ScrollView)) {
                    this.getViewControl().setFocus();
                    break;
                }
                ++i;
            }
        }
        this.setFocus(-1);
        if ((e.stateMask & SWT.BUTTON_MASK) != 0 && (this.fDragAndDrop != null || this.fIsDragAndDrop) && (this.fReorderMode || this.fCollapseProvider != null)) {
            this.fIsDragAndDrop = false;
            if (this.fCurrentGraphNode instanceof Lifeline) {
                this.fDragAndDrop = (Lifeline)this.fCurrentGraphNode;
            }
            if (this.fDragAndDrop != null) {
                int dx = 0;
                int dy = 0;
                if (e.x > this.getContentsX() + this.getVisibleWidth()) {
                    dx = e.x - (this.getContentsX() + this.getVisibleWidth());
                } else if (e.x < this.getContentsX()) {
                    dx = -this.getContentsX() + e.x;
                }
                if (e.y > this.getContentsY() + this.getVisibleHeight()) {
                    dy = e.y - (this.getContentsY() + this.getVisibleHeight());
                } else if (e.y < this.getContentsY()) {
                    dy = -this.getContentsY() + e.y;
                }
                this.fDragX = e.x;
                this.fDragY = e.y;
                if (dx != 0 || dy != 0) {
                    if (this.fLocalAutoScroll == null) {
                        if (this.fLocalAutoScrollTimer == null) {
                            this.fLocalAutoScrollTimer = new Timer(true);
                        }
                        this.fLocalAutoScroll = new AutoScroll(this, dx, dy);
                        this.fLocalAutoScrollTimer.schedule((TimerTask)this.fLocalAutoScroll, 0L, 75L);
                    } else {
                        this.fLocalAutoScroll.fDeltaX = dx;
                        this.fLocalAutoScroll.fDeltaY = dy;
                    }
                } else if (this.fLocalAutoScroll != null) {
                    this.fLocalAutoScroll.cancel();
                    this.fLocalAutoScroll = null;
                }
                this.fDragX = Math.round((float)e.x / this.fZoomValue);
                this.fDragY = Math.round((float)e.y / this.fZoomValue);
                this.redraw();
                Lifeline node = this.fFrame.getCloserLifeline(this.fDragX);
                if (node != null && node != this.fDragAndDrop) {
                    int y = 0;
                    int y1 = 0;
                    int height = Metrics.getLifelineHeaderFontHeigth() + 8;
                    int hMargin = 7;
                    int x = node.getX();
                    int width = node.getWidth();
                    y = this.fFrame.getVisibleAreaY() < node.getY() + node.getHeight() - height - hMargin ? this.contentsToViewY(Math.round((float)(node.getY() + node.getHeight()) * this.fZoomValue)) : Math.round((float)height * this.fZoomValue);
                    y1 = this.fFrame.getVisibleAreaY() < this.contentsToViewY(node.getY() - hMargin) ? this.contentsToViewY(Math.round((float)(node.getY() - hMargin) * this.fZoomValue)) : Math.round((float)height * this.fZoomValue);
                    int rx = Math.round((float)x * this.fZoomValue);
                    this.fInsertionCartet.setVisible(true);
                    if (this.fInsertionCartet.getImage() != null && !this.fInsertionCartet.getImage().isDisposed()) {
                        this.fInsertionCartet.getImage().dispose();
                    }
                    if (rx <= e.x && Math.round((float)rx + (float)width * this.fZoomValue) >= e.x) {
                        if (this.fCollapseProvider != null) {
                            ImageData data = this.fCollapaseCaretImg.getImageData();
                            data = data.scaledTo(Math.round((float)this.fCollapaseCaretImg.getBounds().width * this.fZoomValue), Math.round((float)this.fCollapaseCaretImg.getBounds().height * this.fZoomValue));
                            this.fCurrentCaretImage = new Image((Device)Display.getCurrent(), data);
                            this.fInsertionCartet.setImage(this.fCurrentCaretImage);
                            this.fInsertionCartet.setLocation(this.contentsToViewX(rx + Math.round((float)width / 2.0f * this.fZoomValue)) - this.fCurrentCaretImage.getBounds().width / 2, y);
                        }
                    } else if (this.fReorderMode) {
                        if (rx > e.x) {
                            if (node.getIndex() > 1 && this.fFrame.getLifeline(node.getIndex() - 2) == this.fDragAndDrop) {
                                return;
                            }
                            ImageData data = this.fArrowUpCaretImg.getImageData();
                            data = data.scaledTo(Math.round((float)this.fArrowUpCaretImg.getBounds().width * this.fZoomValue), Math.round((float)this.fArrowUpCaretImg.getBounds().height * this.fZoomValue));
                            this.fCurrentCaretImage = new Image((Device)Display.getCurrent(), data);
                            this.fInsertionCartet.setImage(this.fCurrentCaretImage);
                            this.fInsertionCartet.setLocation(this.contentsToViewX(Math.round((float)(x - 22) * this.fZoomValue)) - this.fCurrentCaretImage.getBounds().width / 2, y1);
                        } else {
                            if (node.getIndex() < this.fFrame.lifeLinesCount() && this.fFrame.getLifeline(node.getIndex()) == this.fDragAndDrop) {
                                return;
                            }
                            ImageData data = this.fArrowUpCaretImg.getImageData();
                            data = data.scaledTo(Math.round((float)this.fArrowUpCaretImg.getBounds().width * this.fZoomValue), Math.round((float)this.fArrowUpCaretImg.getBounds().height * this.fZoomValue));
                            this.fCurrentCaretImage = new Image((Device)Display.getCurrent(), data);
                            this.fInsertionCartet.setImage(this.fCurrentCaretImage);
                            this.fInsertionCartet.setLocation(this.contentsToViewX(Math.round((float)(x + width + 22) * this.fZoomValue)) - this.fCurrentCaretImage.getBounds().width / 2 + 1, y1);
                        }
                    }
                } else {
                    this.fInsertionCartet.setVisible(false);
                }
            }
        } else {
            super.contentsMouseMoveEvent(e);
        }
    }

    @Override
    protected void contentsMouseUpEvent(MouseEvent event) {
        this.fInsertionCartet.setVisible(false);
        if (this.fDragAndDrop != null) {
            if (this.fOverView != null && !this.fOverView.isDisposed()) {
                this.fOverView.dispose();
            }
            this.fOverView = null;
            Lifeline node = this.fFrame.getCloserLifeline(this.fDragX);
            if (node != null) {
                int rx = Math.round((float)node.getX() * this.fZoomValue);
                if (rx <= event.x && Math.round((float)rx + (float)node.getWidth() * this.fZoomValue) >= event.x) {
                    if (this.fCollapseProvider != null && this.fDragAndDrop != node) {
                        this.fCollapseProvider.collapseTwoLifelines(this.fDragAndDrop, node);
                    }
                } else if (rx < event.x) {
                    this.fFrame.insertLifelineAfter(this.fDragAndDrop, node);
                    if (node.getIndex() < this.fFrame.lifeLinesCount()) {
                        Lifeline[] temp = new Lifeline[]{this.fDragAndDrop, this.fFrame.getLifeline(node.getIndex())};
                        this.fReorderList.add(temp);
                    } else {
                        Lifeline[] lifelineArray = new Lifeline[2];
                        lifelineArray[0] = this.fDragAndDrop;
                        Lifeline[] temp = lifelineArray;
                        this.fReorderList.add(temp);
                    }
                } else {
                    this.fFrame.insertLifelineBefore(this.fDragAndDrop, node);
                    Lifeline[] temp = new Lifeline[]{this.fDragAndDrop, node};
                    this.fReorderList.add(temp);
                }
            }
        }
        this.fDragAndDrop = null;
        this.redraw();
        if (this.fFrame == null) {
            return;
        }
        this.fFrame.resetTimeCompression();
        if (this.fLocalAutoScroll != null) {
            this.fLocalAutoScroll.cancel();
            this.fLocalAutoScroll = null;
        }
        super.contentsMouseUpEvent(event);
    }

    @Override
    protected void contentsMouseDownEvent(MouseEvent event) {
        if (this.fCurrentGraphNode != null) {
            this.fCurrentGraphNode.setFocused(false);
        }
        if (this.fFrame == null) {
            return;
        }
        this.fFrame.resetTimeCompression();
        this.fCtrlSelection = (event.stateMask & 0x40000) != 0;
        if ((this.fZoomInMode || this.fZoomOutMode) && event.button == 1) {
            int cx = Math.round((float)event.x / this.fZoomValue);
            int cy = Math.round((float)event.y / this.fZoomValue);
            if (this.fZoomInMode) {
                if (this.fZoomValue < 64.0f) {
                    this.fZoomValue *= 1.25f;
                }
            } else {
                this.fZoomValue /= 1.25f;
            }
            int x = Math.round((float)cx * this.fZoomValue - (float)this.getVisibleWidth() / 2.0f);
            int y = Math.round((float)cy * this.fZoomValue - (float)this.getVisibleHeight() / 2.0f);
            this.setContentsPos(x, y);
            if (this.fTimeBar != null) {
                this.fTimeBar.setZoom(this.fZoomValue);
            }
            this.redraw();
        } else {
            GraphNode node = null;
            int x = Math.round((float)event.x / this.fZoomValue);
            int y = Math.round((float)event.y / this.fZoomValue);
            node = this.fFrame.getNodeAt(x, y);
            if (event.button == 1 || node != null && !node.isSelected()) {
                if (!this.fShiftSelection) {
                    this.fListStart = node;
                }
                if (this.fShiftSelection) {
                    this.clearSelection();
                    this.addSelection(this.fFrame.getNodeList(this.fListStart, node));
                } else {
                    this.performSelection(node);
                }
                this.fCurrentGraphNode = node;
                if (node != null) {
                    node.setFocused(true);
                }
            }
            this.redraw();
        }
        if (this.fDragAndDrop == null) {
            super.contentsMouseDownEvent(event);
        }
        this.fIsDragAndDrop = event.button == 1;
    }

    @Override
    protected void drawContents(GC gc, int clipx, int clipy, int clipw, int cliph) {
        if (this.fFrame == null) {
            gc.setBackground(this.getDisplay().getSystemColor(1));
            gc.fillRectangle(0, 0, this.getVisibleWidth(), this.getVisibleHeight());
            gc.dispose();
            return;
        }
        SDViewPref.getInstance();
        Rectangle area = this.getClientArea();
        Image dbuffer = this.getDrawBuffer();
        int height = Math.round((float)(this.fFrame.getHeight() + 20) * this.fZoomValue);
        try {
            gc.drawImage(dbuffer, 0, 0, area.width, area.height, 0, 0, area.width, area.height);
        }
        catch (Exception e) {
            Activator.getDefault().logError("Error drawin content", e);
        }
        dbuffer.dispose();
        this.setHScrollBarIncrement(Math.round((float)SDViewPref.getInstance().getLifelineWidth() / 2.0f * this.fZoomValue));
        this.setVScrollBarIncrement(Math.round((float)Metrics.getMessagesSpacing() * this.fZoomValue));
        if (this.fTimeBar != null && this.fFrame.hasTimeInfo()) {
            this.fTimeBar.resizeContents(9, height + this.getHorizontalBarHeight());
            this.fTimeBar.setContentsPos(this.getContentsX(), this.getContentsY());
            this.fTimeBar.redraw();
            this.fTimeBar.update();
        }
        float xRatio = (float)this.getContentsWidth() / (float)this.getVisibleWidth();
        float yRatio = (float)this.getContentsHeight() / (float)this.getVisibleHeight();
        if (yRatio > xRatio) {
            this.setOverviewSize((int)((double)this.getVisibleHeight() * 0.75));
        } else {
            this.setOverviewSize((int)((double)this.getVisibleWidth() * 0.75));
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.fZoomIn) {
            this.fZoomValue *= 2.0f;
        } else if (event.widget == this.fZoomOut) {
            this.fZoomValue /= 2.0f;
        }
        this.redraw();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (this.fFrame != null && !this.isDisposed()) {
            this.fFrame.resetTimeCompression();
        }
        if (e.getProperty().equals("PREFOK")) {
            if (this.fOverView != null) {
                this.fOverView.dispose();
            }
            this.fOverView = null;
            this.redraw();
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.fOverView != null) {
            this.fOverView.dispose();
        }
        super.removeDisposeListener((DisposeListener)this);
        if (this.fCurrentCaretImage != null && !this.fCurrentCaretImage.isDisposed()) {
            this.fCurrentCaretImage.dispose();
        }
        if (this.fArrowUpCaretImg != null && !this.fArrowUpCaretImg.isDisposed()) {
            this.fArrowUpCaretImg.dispose();
        }
        if (this.fCollapaseCaretImg != null && !this.fCollapaseCaretImg.isDisposed()) {
            this.fCollapaseCaretImg.dispose();
        }
        SDViewPref.getInstance().removePropertyChangeListener(this);
        LoadersManager lm = LoadersManager.getInstance();
        if (this.fSite instanceof SDView) {
            ((SDView)this.fSite).resetProviders();
            if (lm != null) {
                lm.resetLoader(((SDView)this.fSite).getViewSite().getId());
            }
        }
    }

    @Override
    protected void drawOverview(GC gc, Rectangle r) {
        float oldzoom = this.fZoomValue;
        this.fZoomValue = this.getContentsWidth() > this.getContentsHeight() ? (float)r.width / (float)this.getContentsWidth() * oldzoom : (float)r.height / (float)this.getContentsHeight() * oldzoom;
        if (this.fOverView != null && (r.width != this.fOverView.getBounds().width || r.height != this.fOverView.getBounds().height)) {
            this.fOverView.dispose();
            this.fOverView = null;
        }
        if (this.fOverView == null) {
            int backX = this.getContentsX();
            int backY = this.getContentsY();
            this.setContentsPos(0, 0);
            this.fOverView = new Image((Device)this.getDisplay(), r.width, r.height);
            GC gcim = new GC((Drawable)this.fOverView);
            NGC context = new NGC(this, gcim);
            context.setBackground(SDViewPref.getInstance().getBackGroundColor("PREF_FRAME"));
            this.fFrame.draw(context);
            this.setContentsPos(backX, backY);
            gcim.dispose();
            context.dispose();
        }
        if (this.fOverView != null && r.width == this.fOverView.getBounds().width && r.height == this.fOverView.getBounds().height) {
            gc.drawImage(this.fOverView, 0, 0, r.width, r.height, 0, 0, r.width, r.height);
        }
        this.fZoomValue = oldzoom;
        super.drawOverview(gc, r);
    }

    @Override
    public void deltaSelected(Lifeline lifeline, int startEvent, int nbEvent, IColor color) {
        this.fFrame.highlightTimeCompression(lifeline, startEvent, nbEvent, color);
        this.ensureVisible(lifeline);
        int y1 = lifeline.getY() + lifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * startEvent;
        int y2 = lifeline.getY() + lifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * (startEvent + nbEvent);
        this.ensureVisible(lifeline.getX(), y1 - (Metrics.getLifelineHeaderFontHeigth() + 8), lifeline.getWidth(), y2 - y1 + 3, 0x1000200, true);
        this.redraw();
        this.update();
    }

    @Override
    public int getVisibleWidth() {
        if (this.fIsPrinting) {
            return this.fPrinter.getClientArea().width;
        }
        return super.getVisibleWidth();
    }

    @Override
    public int getVisibleHeight() {
        if (this.fIsPrinting) {
            return this.fPrinter.getClientArea().height;
        }
        return super.getVisibleHeight();
    }

    @Override
    public int contentsToViewX(int x) {
        if (this.fIsPrinting) {
            int v = Math.round((float)this.fPrinterX * this.fPrinterZoom);
            return x - v;
        }
        return x - this.getContentsX();
    }

    @Override
    public int contentsToViewY(int y) {
        if (this.fIsPrinting) {
            int v = Math.round((float)this.fPrinterY * this.fPrinterZoom);
            return y - v;
        }
        return y - this.getContentsY();
    }

    @Override
    public int getContentsX() {
        if (this.fIsPrinting) {
            return Math.round((float)this.fPrinterX * this.fPrinterZoom);
        }
        return super.getContentsX();
    }

    @Override
    public int getContentsY() {
        if (this.fIsPrinting) {
            return Math.round((float)this.fPrinterY * this.fPrinterZoom);
        }
        return super.getContentsY();
    }

    protected static class AutoScroll
    extends TimerTask {
        public int fDeltaX;
        public int fDeltaY;
        public SDWidget fSdWidget;

        public AutoScroll(SDWidget sv, int dx, int dy) {
            this.fSdWidget = sv;
            this.fDeltaX = dx;
            this.fDeltaY = dy;
        }

        @Override
        public void run() {
            Display display = Display.getDefault();
            if (display == null || display.isDisposed()) {
                return;
            }
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (AutoScroll.this.fSdWidget.isDisposed()) {
                        return;
                    }
                    SDWidget sDWidget = AutoScroll.this.fSdWidget;
                    sDWidget.fDragX = sDWidget.fDragX + AutoScroll.this.fDeltaX;
                    SDWidget sDWidget2 = AutoScroll.this.fSdWidget;
                    sDWidget2.fDragY = sDWidget2.fDragY + AutoScroll.this.fDeltaY;
                    AutoScroll.this.fSdWidget.scrollBy(AutoScroll.this.fDeltaX, AutoScroll.this.fDeltaY);
                }
            });
        }
    }

    protected static class LocalTraverseListener
    implements TraverseListener {
        protected LocalTraverseListener() {
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 16 || e.detail == 8) {
                e.doit = true;
            }
        }
    }
}

