/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.preferences;

import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.preferences.SDViewPref;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SDViewerPage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener {
    private static final String TEMP_TAG = "_TEMP";
    private SDViewPref fPreferences = null;
    private ColorFieldEditor fLineColor = null;
    private ColorFieldEditor fBackGroundColor = null;
    private ColorFieldEditor fTextColor = null;
    private List fClassItemList = null;
    private FontFieldEditor fFont = null;
    private BooleanFieldEditor fLink = null;
    private BooleanFieldEditor fTooltip = null;
    private BooleanFieldEditor fNoExternalTime = null;
    private BooleanFieldEditor fUseGrad = null;
    private Composite fButtonArea;
    private IntegerFieldEditor fLifelineWidth = null;

    protected Control createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite page = new Composite(parent, 0);
        GridLayout pageLayout = new GridLayout();
        pageLayout.numColumns = 2;
        GridData pageLayoutdata = new GridData(1808);
        page.setLayoutData((Object)pageLayoutdata);
        page.setLayout((Layout)pageLayout);
        this.fTooltip = new BooleanFieldEditor("PREF_TOOLTIP", Messages.SequenceDiagram_ShowTooltips, page);
        this.fTooltip.setPreferenceStore(this.fPreferences.getPreferenceStore());
        this.fTooltip.load();
        this.fLink = new BooleanFieldEditor("PREF_LINK_FONT", Messages.SequenceDiagram_IncreaseFontSizeWhenZooming, page);
        this.fLink.setPreferenceStore(this.fPreferences.getPreferenceStore());
        this.fLink.load();
        this.fNoExternalTime = new BooleanFieldEditor("PREF_EXCLUDE_EXTERNAL_TIME", Messages.SequenceDiagram_ExcludeExternalTime, page);
        this.fNoExternalTime.setPreferenceStore(this.fPreferences.getPreferenceStore());
        this.fNoExternalTime.load();
        this.fUseGrad = new BooleanFieldEditor("PREF_USE_GRADIENT", Messages.SequenceDiagram_UseGradientColor, page);
        this.fUseGrad.setPreferenceStore(this.fPreferences.getPreferenceStore());
        this.fUseGrad.load();
        Label separator = new Label(page, 290);
        GridData sepData = new GridData(784);
        separator.setLayoutData((Object)sepData);
        Composite prefPage = new Composite(page, 0);
        GridLayout prefPageLayout = new GridLayout();
        prefPage.setLayoutData((Object)pageLayoutdata);
        prefPageLayout.numColumns = 1;
        prefPage.setLayout((Layout)prefPageLayout);
        this.fLifelineWidth = new IntegerFieldEditor("PREF_LIFELINE_WIDTH", Messages.SequenceDiagram_LifelineWidth, prefPage);
        this.fLifelineWidth.setPreferenceStore(this.fPreferences.getPreferenceStore());
        this.fLifelineWidth.setValidRange(119, 500);
        this.fLifelineWidth.load();
        new Label(prefPage, 290);
        new Label(prefPage, 290);
        this.fClassItemList = new List(prefPage, 2820);
        GridData tabItemLayoutdata = new GridData(1808);
        this.fClassItemList.setLayoutData((Object)tabItemLayoutdata);
        String[] fontList2 = SDViewPref.getFontList2();
        int i = 0;
        while (i < fontList2.length) {
            this.fClassItemList.add(fontList2[i]);
            ++i;
        }
        this.fClassItemList.setSelection(0);
        this.fClassItemList.addSelectionListener((SelectionListener)this);
        this.fButtonArea = new Composite(prefPage, 0);
        GridData tabItemLayoutdata2 = new GridData(1296);
        this.fButtonArea.setLayoutData((Object)tabItemLayoutdata2);
        GridLayout buttonAreaLayout = new GridLayout();
        buttonAreaLayout.numColumns = 1;
        this.fButtonArea.setLayout((Layout)buttonAreaLayout);
        String[] fontList = SDViewPref.getFontList();
        this.fFont = new FontFieldEditor(fontList[0], "", Messages.SequenceDiagram_AaBbYyZz, this.fButtonArea);
        this.fFont.getPreviewControl().setSize(500, 500);
        this.fFont.setPreferenceStore(this.fPreferences.getPreferenceStore());
        this.fFont.load();
        this.fBackGroundColor = new ColorFieldEditor(String.valueOf(fontList[0]) + "_BACK_COLOR", Messages.SequenceDiagram_Background, this.fButtonArea);
        this.fBackGroundColor.setPreferenceStore(this.fPreferences.getPreferenceStore());
        this.fBackGroundColor.load();
        this.fLineColor = new ColorFieldEditor(String.valueOf(fontList[0]) + "_FORE_COLOR", Messages.SequenceDiagram_Lines, this.fButtonArea);
        this.fLineColor.setPreferenceStore(this.fPreferences.getPreferenceStore());
        this.fLineColor.load();
        this.fTextColor = new ColorFieldEditor(String.valueOf(fontList[0]) + "_TEXT_COLOR", Messages.SequenceDiagram_Text, this.fButtonArea);
        this.fTextColor.setPreferenceStore(this.fPreferences.getPreferenceStore());
        this.fTextColor.load();
        this.swapPref(true);
        Dialog.applyDialogFont((Control)page);
        return page;
    }

    public void init(IWorkbench workbench) {
        this.fPreferences = SDViewPref.getInstance();
    }

    protected void performApply() {
        if (!this.fLifelineWidth.isValid()) {
            this.fLifelineWidth.showErrorMessage();
            return;
        }
        this.fFont.store();
        this.fBackGroundColor.store();
        this.fLineColor.store();
        this.fLink.store();
        this.fTooltip.store();
        this.fNoExternalTime.store();
        this.fTextColor.store();
        this.fUseGrad.store();
        this.fLifelineWidth.store();
        this.swapPref(false);
        this.fPreferences.apply();
        this.swapPref(true);
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    protected void performDefaults() {
        this.fLink.loadDefault();
        this.fTooltip.loadDefault();
        this.fNoExternalTime.loadDefault();
        this.fUseGrad.loadDefault();
        this.fLifelineWidth.loadDefault();
        Set<String> keySet = SDViewPref.getInstance().getFontPref().keySet();
        for (String prefName : keySet) {
            if (!(prefName instanceof String)) continue;
            this.fFont.setPreferenceName(prefName);
            this.fFont.loadDefault();
            this.fFont.setPreferenceName(String.valueOf(prefName) + TEMP_TAG);
            this.fFont.store();
        }
        keySet = SDViewPref.getInstance().getBackColorPref().keySet();
        for (String prefName : keySet) {
            if (!(prefName instanceof String)) continue;
            this.fBackGroundColor.setPreferenceName(prefName);
            this.fBackGroundColor.loadDefault();
            this.fBackGroundColor.setPreferenceName(String.valueOf(prefName) + TEMP_TAG);
            this.fBackGroundColor.store();
        }
        String[] fontList = SDViewPref.getFontList();
        this.fBackGroundColor.setPreferenceName(String.valueOf(fontList[this.fClassItemList.getSelectionIndex()]) + "_BACK_COLOR" + TEMP_TAG);
        this.fBackGroundColor.load();
        keySet = SDViewPref.getInstance().getForeColorPref().keySet();
        for (String prefName : keySet) {
            if (!(prefName instanceof String)) continue;
            this.fLineColor.setPreferenceName(prefName);
            this.fLineColor.loadDefault();
            this.fLineColor.setPreferenceName(String.valueOf(prefName) + TEMP_TAG);
            this.fLineColor.store();
        }
        this.fLineColor.setPreferenceName(String.valueOf(fontList[this.fClassItemList.getSelectionIndex()]) + "_FORE_COLOR" + TEMP_TAG);
        this.fLineColor.load();
        keySet = SDViewPref.getInstance().getTextColorPref().keySet();
        for (String prefName : keySet) {
            if (!(prefName instanceof String)) continue;
            this.fTextColor.setPreferenceName(prefName);
            this.fTextColor.loadDefault();
            this.fTextColor.setPreferenceName(String.valueOf(prefName) + TEMP_TAG);
            this.fTextColor.store();
        }
        this.fTextColor.setPreferenceName(String.valueOf(fontList[this.fClassItemList.getSelectionIndex()]) + "_TEXT_COLOR" + TEMP_TAG);
        this.fTextColor.load();
    }

    public void widgetSelected(SelectionEvent e) {
        this.fFont.store();
        this.fLineColor.store();
        this.fBackGroundColor.store();
        this.fTextColor.store();
        String[] fontList = SDViewPref.getFontList();
        this.fFont.setPreferenceName(String.valueOf(fontList[this.fClassItemList.getSelectionIndex()]) + TEMP_TAG);
        this.fFont.load();
        this.fBackGroundColor.setPreferenceName(String.valueOf(fontList[this.fClassItemList.getSelectionIndex()]) + "_BACK_COLOR" + TEMP_TAG);
        this.fBackGroundColor.load();
        this.fLineColor.setPreferenceName(String.valueOf(fontList[this.fClassItemList.getSelectionIndex()]) + "_FORE_COLOR" + TEMP_TAG);
        this.fLineColor.load();
        this.fTextColor.setPreferenceName(String.valueOf(fontList[this.fClassItemList.getSelectionIndex()]) + "_TEXT_COLOR" + TEMP_TAG);
        this.fTextColor.load();
        if (fontList[this.fClassItemList.getSelectionIndex()].equals("PREF_SYNC_MESS") || fontList[this.fClassItemList.getSelectionIndex()].equals("PREF_SYNC_MESS_RET") || fontList[this.fClassItemList.getSelectionIndex()].equals("PREF_ASYNC_MESS") || fontList[this.fClassItemList.getSelectionIndex()].equals("PREF_ASYNC_MESS_RET")) {
            this.fBackGroundColor.setEnabled(false, this.fButtonArea);
        } else {
            this.fBackGroundColor.setEnabled(true, this.fButtonArea);
        }
        if (fontList[this.fClassItemList.getSelectionIndex()].equals("PREF_EXEC") || fontList[this.fClassItemList.getSelectionIndex()].equals("PREF_FRAME")) {
            this.fTextColor.setEnabled(false, this.fButtonArea);
        } else {
            this.fTextColor.setEnabled(true, this.fButtonArea);
        }
        if (fontList[this.fClassItemList.getSelectionIndex()].equals("PREF_FRAME")) {
            this.fFont.setEnabled(false, this.fButtonArea);
        } else {
            this.fFont.setEnabled(true, this.fButtonArea);
        }
    }

    protected void swapPref(boolean toTemp) {
        String tag1 = "";
        String tag2 = TEMP_TAG;
        if (!toTemp) {
            tag1 = TEMP_TAG;
            tag2 = "";
        }
        Set<String> keySet = SDViewPref.getInstance().getFontPref().keySet();
        for (String prefName : keySet) {
            if (!(prefName instanceof String)) continue;
            this.fFont.setPreferenceName(String.valueOf(prefName) + tag1);
            this.fFont.load();
            this.fFont.setPreferenceName(String.valueOf(prefName) + tag2);
            this.fFont.store();
        }
        keySet = SDViewPref.getInstance().getBackColorPref().keySet();
        for (String prefName : keySet) {
            if (!(prefName instanceof String)) continue;
            this.fBackGroundColor.setPreferenceName(String.valueOf(prefName) + tag1);
            this.fBackGroundColor.load();
            this.fBackGroundColor.setPreferenceName(String.valueOf(prefName) + tag2);
            this.fBackGroundColor.store();
        }
        keySet = SDViewPref.getInstance().getForeColorPref().keySet();
        for (String prefName : keySet) {
            if (!(prefName instanceof String)) continue;
            this.fLineColor.setPreferenceName(String.valueOf(prefName) + tag1);
            this.fLineColor.load();
            this.fLineColor.setPreferenceName(String.valueOf(prefName) + tag2);
            this.fLineColor.store();
        }
        keySet = SDViewPref.getInstance().getTextColorPref().keySet();
        for (String prefName : keySet) {
            if (!(prefName instanceof String)) continue;
            this.fTextColor.setPreferenceName(String.valueOf(prefName) + tag1);
            this.fTextColor.load();
            this.fTextColor.setPreferenceName(String.valueOf(prefName) + tag2);
            this.fTextColor.store();
        }
        String[] fontList = SDViewPref.getFontList();
        if (toTemp) {
            this.fFont.setPreferenceName(String.valueOf(fontList[this.fClassItemList.getSelectionIndex()]) + TEMP_TAG);
            this.fFont.load();
            this.fBackGroundColor.setPreferenceName(String.valueOf(fontList[this.fClassItemList.getSelectionIndex()]) + "_BACK_COLOR" + TEMP_TAG);
            this.fBackGroundColor.load();
            this.fLineColor.setPreferenceName(String.valueOf(fontList[this.fClassItemList.getSelectionIndex()]) + "_FORE_COLOR" + TEMP_TAG);
            this.fLineColor.load();
            this.fTextColor.setPreferenceName(String.valueOf(fontList[this.fClassItemList.getSelectionIndex()]) + "_TEXT_COLOR" + TEMP_TAG);
            this.fTextColor.load();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

