/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.core.model.ICDebugElement;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.ui.elements.adapters.CRegisterManagerProxy;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextManager;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;

public class CRegisterManagerProxies {
    private static CRegisterManagerProxies fgInstance = new CRegisterManagerProxies();
    private Map<ICDebugTarget, CRegisterManagerProxy> fMap = new HashMap<ICDebugTarget, CRegisterManagerProxy>();

    public static CRegisterManagerProxies getInstance() {
        return fgInstance;
    }

    public void dispose() {
        for (CRegisterManagerProxy proxy : this.fMap.values()) {
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)proxy);
            proxy.dispose();
        }
        this.fMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CRegisterManagerProxy getRegisterManagerProxy(ICDebugTarget target) {
        CRegisterManagerProxy proxy = this.fMap.get(target);
        if (proxy == null) {
            CRegisterManagerProxies cRegisterManagerProxies = this;
            synchronized (cRegisterManagerProxies) {
                proxy = this.fMap.get(target);
                if (proxy == null) {
                    proxy = new CRegisterManagerProxy(((CDebugTarget)target).getRegisterManager());
                    DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)proxy);
                    IDebugContextService service = this.getContextService();
                    if (service != null) {
                        ISelection s = service.getActiveContext();
                        if (s instanceof IStructuredSelection && ((IStructuredSelection)s).size() == 1) {
                            Object context = ((IStructuredSelection)s).getFirstElement();
                            proxy.setContext((ICDebugElement)(context instanceof ICDebugElement ? (ICDebugElement)context : target));
                        }
                        service.addDebugContextListener((IDebugContextListener)proxy);
                    }
                    this.fMap.put(target, proxy);
                }
            }
        }
        return proxy;
    }

    private IDebugContextService getContextService() {
        IWorkbenchWindow window = SelectedResourceManager.getDefault().getActiveWindow();
        if (window != null) {
            IDebugContextManager manager = DebugUITools.getDebugContextManager();
            return manager.getContextService(window);
        }
        return null;
    }
}

