/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.breakpointactions;

import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.breakpointactions.IBreakpointAction;
import org.eclipse.cdt.debug.ui.breakpointactions.ActionsList;
import org.eclipse.cdt.debug.ui.breakpointactions.GlobalActionsList;
import org.eclipse.cdt.debug.ui.breakpointactions.Messages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public class ActionsPropertyPage
extends PropertyPage {
    private ActionsList actionsList;
    private IMarker breakpointMarker;
    private GlobalActionsList globalActionsList;
    private String savedActionNames;

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        IBreakpoint breakpoint = (IBreakpoint)this.getElement().getAdapter(IBreakpoint.class);
        this.breakpointMarker = breakpoint.getMarker();
        this.savedActionNames = this.breakpointMarker.getAttribute("BREAKPOINT_ACTIONS", "");
        Label actionsTriggeredWhenLabel = new Label(container, 0);
        GridData gridData_2 = new GridData();
        gridData_2.horizontalSpan = 2;
        actionsTriggeredWhenLabel.setLayoutData((Object)gridData_2);
        actionsTriggeredWhenLabel.setText(Messages.getString("ActionsPropertyPage.1"));
        this.actionsList = new ActionsList(container, 0);
        GridData gridData = new GridData(784);
        gridData.horizontalSpan = 2;
        this.actionsList.setLayoutData(gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        container.setLayout((Layout)gridLayout);
        Label label = new Label(container, 258);
        GridData gridData_4 = new GridData(256);
        gridData_4.horizontalSpan = 2;
        label.setLayoutData((Object)gridData_4);
        Label allAvailableActionsLabel = new Label(container, 0);
        GridData gridData_3 = new GridData();
        gridData_3.horizontalSpan = 2;
        allAvailableActionsLabel.setLayoutData((Object)gridData_3);
        allAvailableActionsLabel.setText(Messages.getString("ActionsPropertyPage.2"));
        this.globalActionsList = new GlobalActionsList(container, 0, true);
        GridData gridData_1 = new GridData(1808);
        gridData_1.horizontalSpan = 2;
        this.globalActionsList.setLayoutData(gridData_1);
        String actionNames = this.breakpointMarker.getAttribute("BREAKPOINT_ACTIONS", "");
        this.actionsList.setNames(actionNames);
        this.globalActionsList.getAttachButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionsPropertyPage.this.HandleAttachButton();
            }
        });
        this.globalActionsList.getDeleteButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionsPropertyPage.this.HandleDeleteButton();
            }
        });
        return container;
    }

    protected void HandleAttachButton() {
        IBreakpointAction[] selectedActions = this.globalActionsList.getSelectedActions();
        int i = 0;
        while (i < selectedActions.length) {
            this.actionsList.addAction(selectedActions[i]);
            ++i;
        }
    }

    protected void HandleDeleteButton() {
        IBreakpointAction[] selectedActions = this.globalActionsList.getSelectedActions();
        int i = 0;
        while (i < selectedActions.length) {
            this.actionsList.removeAction(selectedActions[i]);
            ++i;
        }
        this.globalActionsList.HandleDeleteButton();
    }

    protected void performDefaults() {
        try {
            this.breakpointMarker.setAttribute("BREAKPOINT_ACTIONS", (Object)"");
            this.actionsList.setNames("");
        }
        catch (CoreException coreException) {}
        super.performDefaults();
    }

    public boolean performCancel() {
        try {
            this.breakpointMarker.setAttribute("BREAKPOINT_ACTIONS", (Object)this.savedActionNames);
            CDebugCorePlugin.getDefault().getBreakpointActionManager().revertActionData();
        }
        catch (CoreException coreException) {}
        return super.performCancel();
    }

    public boolean performOk() {
        try {
            CDebugCorePlugin.getDefault().getBreakpointActionManager().saveActionData();
            this.breakpointMarker.setAttribute("BREAKPOINT_ACTIONS", (Object)this.actionsList.getActionNames());
        }
        catch (CoreException coreException) {}
        return super.performOk();
    }
}

