/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.component;

import org.eclipse.linuxtools.internal.tmf.core.Activator;
import org.eclipse.linuxtools.internal.tmf.core.TmfCoreTracer;
import org.eclipse.linuxtools.tmf.core.component.ITmfDataProvider;
import org.eclipse.linuxtools.tmf.core.component.TmfDataProvider;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;

public class TmfEventThread
implements Runnable {
    private final TmfDataProvider fProvider;
    private final ITmfDataRequest fRequest;
    private final ITmfDataRequest.ExecutionType fExecType;
    private final TmfEventThread fThread;
    private volatile boolean isCompleted = false;
    private final Object fSynchObject = new Object();
    private volatile boolean fIsPaused = false;

    public TmfEventThread(TmfDataProvider provider, ITmfDataRequest request) {
        assert (provider != null);
        assert (request != null);
        this.fProvider = provider;
        this.fRequest = request;
        this.fExecType = request.getExecType();
        this.fThread = null;
    }

    public TmfEventThread(TmfEventThread thread) {
        this.fProvider = thread.fProvider;
        this.fRequest = thread.fRequest;
        this.fExecType = thread.fExecType;
        this.fThread = thread;
    }

    public TmfEventThread getThread() {
        return this.fThread;
    }

    public ITmfDataProvider getProvider() {
        return this.fProvider;
    }

    public ITmfDataRequest getRequest() {
        return this.fRequest;
    }

    public ITmfDataRequest.ExecutionType getExecType() {
        return this.fExecType;
    }

    public boolean isRunning() {
        return this.fRequest.isRunning() && !this.isPaused();
    }

    public boolean isPaused() {
        return this.fIsPaused;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TmfCoreTracer.traceRequest(this.fRequest, "is being serviced by " + this.fProvider.getName());
        this.fRequest.start();
        int nbRequested = this.fRequest.getNbRequested();
        int nbRead = 0;
        this.isCompleted = false;
        ITmfContext context = this.fProvider.armRequest(this.fRequest);
        if (context == null) {
            this.fRequest.cancel();
            return;
        }
        try {
            ITmfEvent event = this.fProvider.getNext(context);
            TmfCoreTracer.traceRequest(this.fRequest, "read first event");
            while (event != null && !this.fProvider.isCompleted(this.fRequest, event, nbRead)) {
                TmfCoreTracer.traceEvent(this.fProvider, this.fRequest, event);
                if (this.fRequest.getDataType().isInstance(event)) {
                    this.fRequest.handleData(event);
                }
                while (this.fIsPaused) {
                    Object object = this.fSynchObject;
                    synchronized (object) {
                        try {
                            this.fSynchObject.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (++nbRead >= nbRequested) continue;
                event = this.fProvider.getNext(context);
            }
            this.isCompleted = true;
            if (this.fRequest.isCancelled()) {
                this.fRequest.cancel();
            } else {
                this.fRequest.done();
            }
        }
        catch (Exception e) {
            Activator.logError("Error in " + this.fProvider.getName() + " handling " + this.fRequest, e);
            this.fRequest.fail();
        }
        context.dispose();
    }

    public void suspend() {
        this.fIsPaused = true;
        TmfCoreTracer.traceRequest(this.fRequest, "SUSPENDED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.fIsPaused = false;
        Object object = this.fSynchObject;
        synchronized (object) {
            this.fSynchObject.notifyAll();
        }
        TmfCoreTracer.traceRequest(this.fRequest, "RESUMED");
    }

    public void cancel() {
        if (!this.fRequest.isCompleted()) {
            this.fRequest.cancel();
        }
    }
}

