/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.component;

import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import org.eclipse.linuxtools.internal.tmf.core.TmfCoreTracer;
import org.eclipse.linuxtools.internal.tmf.core.component.TmfEventThread;
import org.eclipse.linuxtools.internal.tmf.core.component.TmfProviderManager;
import org.eclipse.linuxtools.internal.tmf.core.request.TmfCoalescedDataRequest;
import org.eclipse.linuxtools.internal.tmf.core.request.TmfRequestExecutor;
import org.eclipse.linuxtools.tmf.core.component.ITmfDataProvider;
import org.eclipse.linuxtools.tmf.core.component.TmfComponent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfDataRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfEndSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfStartSynchSignal;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;

public abstract class TmfDataProvider
extends TmfComponent
implements ITmfDataProvider {
    public static final int DEFAULT_BLOCK_SIZE = 50000;
    public static final int DEFAULT_QUEUE_SIZE = 1000;
    protected Class<? extends ITmfEvent> fType;
    protected boolean fLogData;
    protected boolean fLogError;
    protected BlockingQueue<ITmfEvent> fDataQueue;
    protected int fQueueSize = 1000;
    private final TmfRequestExecutor fExecutor;
    private int fSignalDepth = 0;
    private final Object fLock = new Object();
    private int fRequestPendingCounter = 0;
    protected Vector<TmfCoalescedDataRequest> fPendingCoalescedRequests = new Vector();

    public TmfDataProvider() {
        this.fDataQueue = new LinkedBlockingQueue<ITmfEvent>(this.fQueueSize);
        this.fExecutor = new TmfRequestExecutor();
    }

    public void init(String name, Class<? extends ITmfEvent> type) {
        super.init(name);
        this.fType = type;
        this.fDataQueue = this.fQueueSize > 1 ? new LinkedBlockingQueue(this.fQueueSize) : new SynchronousQueue();
        this.fExecutor.init();
        this.fSignalDepth = 0;
        this.fLogData = TmfCoreTracer.isEventTraced();
        TmfProviderManager.register(this.fType, this);
    }

    protected TmfDataProvider(String name, Class<? extends ITmfEvent> type, int queueSize) {
        this();
        this.fQueueSize = queueSize;
        this.init(name, type);
    }

    public TmfDataProvider(TmfDataProvider other) {
        this();
        this.init(other.getName(), other.fType);
    }

    public TmfDataProvider(String name, Class<? extends ITmfEvent> type) {
        this(name, type, 1000);
    }

    @Override
    public void dispose() {
        TmfProviderManager.deregister(this.fType, this);
        this.fExecutor.stop();
        super.dispose();
    }

    public int getQueueSize() {
        return this.fQueueSize;
    }

    public Class<?> getType() {
        return this.fType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendRequest(ITmfDataRequest request) {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fSignalDepth > 0) {
                this.coalesceDataRequest(request);
            } else {
                this.dispatchRequest(request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireRequest() {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fRequestPendingCounter > 0) {
                return;
            }
            if (this.fPendingCoalescedRequests.size() > 0) {
                for (TmfDataRequest tmfDataRequest : this.fPendingCoalescedRequests) {
                    this.dispatchRequest(tmfDataRequest);
                }
                this.fPendingCoalescedRequests.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPendingRequest(boolean isIncrement) {
        Object object = this.fLock;
        synchronized (object) {
            if (isIncrement) {
                if (this.fSignalDepth > 0) {
                    ++this.fRequestPendingCounter;
                }
            } else {
                if (this.fRequestPendingCounter > 0) {
                    --this.fRequestPendingCounter;
                }
                if (this.fRequestPendingCounter == 0) {
                    this.fireRequest();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void newCoalescedDataRequest(ITmfDataRequest request) {
        Object object = this.fLock;
        synchronized (object) {
            TmfCoalescedDataRequest coalescedRequest = new TmfCoalescedDataRequest(request.getDataType(), request.getIndex(), request.getNbRequested(), request.getBlockSize(), request.getExecType());
            coalescedRequest.addRequest(request);
            if (TmfCoreTracer.isRequestTraced()) {
                TmfCoreTracer.traceRequest(request, "COALESCED with " + coalescedRequest.getRequestId());
                TmfCoreTracer.traceRequest(coalescedRequest, "now contains " + coalescedRequest.getSubRequestIds());
            }
            this.fPendingCoalescedRequests.add(coalescedRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void coalesceDataRequest(ITmfDataRequest request) {
        Object object = this.fLock;
        synchronized (object) {
            for (TmfCoalescedDataRequest coalescedRequest : this.fPendingCoalescedRequests) {
                if (!coalescedRequest.isCompatible(request)) continue;
                coalescedRequest.addRequest(request);
                if (TmfCoreTracer.isRequestTraced()) {
                    TmfCoreTracer.traceRequest(request, "COALESCED with " + coalescedRequest.getRequestId());
                    TmfCoreTracer.traceRequest(coalescedRequest, "now contains " + coalescedRequest.getSubRequestIds());
                }
                return;
            }
            this.newCoalescedDataRequest(request);
        }
    }

    private void dispatchRequest(ITmfDataRequest request) {
        if (request.getExecType() == ITmfDataRequest.ExecutionType.FOREGROUND) {
            this.queueRequest(request);
        } else {
            this.queueBackgroundRequest(request, request.getBlockSize(), true);
        }
    }

    protected void queueRequest(ITmfDataRequest request) {
        if (this.fExecutor.isShutdown()) {
            request.cancel();
            return;
        }
        TmfEventThread thread = new TmfEventThread(this, request);
        if (TmfCoreTracer.isRequestTraced()) {
            TmfCoreTracer.traceRequest(request, "QUEUED");
        }
        this.fExecutor.execute(thread);
    }

    protected void queueBackgroundRequest(ITmfDataRequest request, int blockSize, boolean indexing) {
        this.queueRequest(request);
    }

    public abstract ITmfContext armRequest(ITmfDataRequest var1);

    public boolean isCompleted(ITmfDataRequest request, ITmfEvent data, int nbRead) {
        return request.isCompleted() || nbRead >= request.getNbRequested();
    }

    protected boolean executorIsShutdown() {
        return this.fExecutor.isShutdown();
    }

    protected boolean executorIsTerminated() {
        return this.fExecutor.isTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void startSynch(TmfStartSynchSignal signal) {
        Object object = this.fLock;
        synchronized (object) {
            ++this.fSignalDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void endSynch(TmfEndSynchSignal signal) {
        Object object = this.fLock;
        synchronized (object) {
            --this.fSignalDepth;
            if (this.fSignalDepth == 0) {
                this.fireRequest();
            }
        }
    }
}

