/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.event;

import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventType;
import org.eclipse.linuxtools.tmf.core.event.TmfEventTypeManager;

public class TmfEventType
implements ITmfEventType {
    private final String fContext;
    private final String fTypeId;
    private final ITmfEventField fRootField;

    public TmfEventType() {
        this("TmfContext", "TmfType", null);
    }

    public TmfEventType(String context, String typeId, ITmfEventField root) {
        if (context == null || typeId == null) {
            throw new IllegalArgumentException();
        }
        this.fContext = context;
        this.fTypeId = typeId;
        this.fRootField = root;
        TmfEventTypeManager.getInstance().add(context, this);
    }

    public TmfEventType(ITmfEventType type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.fContext = type.getContext();
        this.fTypeId = type.getName();
        this.fRootField = type.getRootField();
    }

    @Override
    public String getContext() {
        return this.fContext;
    }

    @Override
    public String getName() {
        return this.fTypeId;
    }

    @Override
    public ITmfEventField getRootField() {
        return this.fRootField;
    }

    @Override
    public String[] getFieldNames() {
        return this.fRootField != null ? this.fRootField.getFieldNames() : new String[]{};
    }

    @Override
    public String getFieldName(int index) {
        return this.fRootField != null ? this.fRootField.getFieldName(index) : null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fContext.hashCode();
        result = 31 * result + this.fTypeId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TmfEventType)) {
            return false;
        }
        TmfEventType other = (TmfEventType)obj;
        if (!this.fContext.equals(other.fContext)) {
            return false;
        }
        return this.fTypeId.equals(other.fTypeId);
    }

    public String toString() {
        return "TmfEventType [fContext=" + this.fContext + ", fTypeId=" + this.fTypeId + "]";
    }
}

