/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statistics;

import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfLostEvent;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.linuxtools.tmf.core.statevalue.TmfStateValue;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

class StatsProviderEventTypes
extends AbstractTmfStateProvider {
    private static final int VERSION = 2;

    public StatsProviderEventTypes(ITmfTrace trace) {
        super(trace, ITmfEvent.class, "TMF Statistics, events per type");
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public StatsProviderEventTypes getNewInstance() {
        return new StatsProviderEventTypes(this.getTrace());
    }

    @Override
    protected void eventHandle(ITmfEvent event) {
        long ts = event.getTimestamp().normalize(0L, -9).getValue();
        String eventName = event.getType().getName();
        try {
            if (event instanceof ITmfLostEvent) {
                ITmfLostEvent le = (ITmfLostEvent)event;
                int quark = this.ss.getQuarkAbsoluteAndAdd("event_types", eventName);
                int curVal = this.ss.queryOngoingState(quark).unboxInt();
                if (curVal == -1) {
                    curVal = 0;
                }
                TmfStateValue value = TmfStateValue.newValueInt((int)((long)curVal + le.getNbLostEvents()));
                this.ss.modifyAttribute(ts, value, quark);
                return;
            }
            int quark = this.ss.getQuarkAbsoluteAndAdd("event_types", eventName);
            this.ss.incrementAttribute(ts, quark);
        }
        catch (StateValueTypeException e) {
            e.printStackTrace();
        }
        catch (TimeRangeException e) {
            e.printStackTrace();
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
    }
}

