/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statistics;

import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfLostEvent;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

class StatsProviderTotals
extends AbstractTmfStateProvider {
    private static final int VERSION = 2;

    public StatsProviderTotals(ITmfTrace trace) {
        super(trace, ITmfEvent.class, "TMF Statistics, event totals");
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public StatsProviderTotals getNewInstance() {
        return new StatsProviderTotals(this.getTrace());
    }

    @Override
    protected void eventHandle(ITmfEvent event) {
        if (event instanceof ITmfLostEvent) {
            return;
        }
        long ts = event.getTimestamp().normalize(0L, -9).getValue();
        try {
            int quark = this.ss.getQuarkAbsoluteAndAdd("total");
            this.ss.incrementAttribute(ts, quark);
        }
        catch (StateValueTypeException e) {
            e.printStackTrace();
        }
        catch (TimeRangeException e) {
            e.printStackTrace();
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
    }
}

