/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statistics;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateSystemDisposedException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.signal.TmfStatsUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateSystem;
import org.eclipse.linuxtools.tmf.core.statesystem.TmfStateSystemFactory;
import org.eclipse.linuxtools.tmf.core.statistics.ITmfStatistics;
import org.eclipse.linuxtools.tmf.core.statistics.StatsProviderEventTypes;
import org.eclipse.linuxtools.tmf.core.statistics.StatsProviderTotals;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;

public class TmfStateStatistics
implements ITmfStatistics {
    @Deprecated
    public static final String STATE_ID = "org.eclipse.linuxtools.tmf.statistics";
    public static final String TOTALS_STATE_ID = "org.eclipse.linuxtools.tmf.statistics.totals";
    public static final String TYPES_STATE_ID = "org.eclipse.linuxtools.tmf.statistics.types";
    private static final String TOTALS_STATE_FILENAME = "statistics-totals.ht";
    private static final String TYPES_STATE_FILENAME = "statistics-types.ht";
    private final ITmfTrace trace;
    private final ITmfStateSystem totalsStats;
    private final ITmfStateSystem typesStats;

    public TmfStateStatistics() {
        this.totalsStats = null;
        this.typesStats = null;
        this.trace = null;
    }

    public TmfStateStatistics(ITmfTrace trace) throws TmfTraceException {
        this.trace = trace;
        String directory = TmfTraceManager.getSupplementaryFileDir(trace);
        File totalsFile = new File(String.valueOf(directory) + TOTALS_STATE_FILENAME);
        StatsProviderTotals totalsInput = new StatsProviderTotals(trace);
        this.totalsStats = TmfStateSystemFactory.newFullHistory(totalsFile, totalsInput, false);
        File typesFile = new File(String.valueOf(directory) + TYPES_STATE_FILENAME);
        StatsProviderEventTypes typesInput = new StatsProviderEventTypes(trace);
        this.typesStats = TmfStateSystemFactory.newFullHistory(typesFile, typesInput, false);
        this.registerStateSystems();
    }

    @Deprecated
    public TmfStateStatistics(ITmfTrace trace, File historyFile) {
        this();
    }

    public TmfStateStatistics(ITmfTrace trace, File totalsHistoryFile, File typesHistoryFile) throws TmfTraceException {
        this.trace = trace;
        StatsProviderTotals totalsInput = new StatsProviderTotals(trace);
        StatsProviderEventTypes typesInput = new StatsProviderEventTypes(trace);
        this.totalsStats = TmfStateSystemFactory.newFullHistory(totalsHistoryFile, totalsInput, true);
        this.typesStats = TmfStateSystemFactory.newFullHistory(typesHistoryFile, typesInput, true);
        this.registerStateSystems();
    }

    private void registerStateSystems() {
        this.trace.registerStateSystem(TOTALS_STATE_ID, this.totalsStats);
        this.trace.registerStateSystem(TYPES_STATE_ID, this.typesStats);
    }

    @Override
    public void dispose() {
        this.totalsStats.dispose();
        this.typesStats.dispose();
    }

    @Override
    public void updateStats(final boolean isGlobal, final long start, final long end) {
        Thread statsThread = new Thread("Statistics update"){

            @Override
            public void run() {
                if (!TmfStateStatistics.this.waitUntilBuilt()) {
                    return;
                }
                long total = TmfStateStatistics.this.getEventsInRange(start, end);
                Map<String, Long> map = TmfStateStatistics.this.getEventTypesInRange(start, end);
                TmfStatsUpdatedSignal sig = new TmfStatsUpdatedSignal(this, TmfStateStatistics.this.trace, isGlobal, total, map);
                TmfSignalManager.dispatchSignal(sig);
            }
        };
        statsThread.start();
    }

    @Override
    public List<Long> histogramQuery(long start, long end, int nb) {
        long count;
        long curTotal;
        LinkedList<Long> list = new LinkedList<Long>();
        long increment = (end - start) / (long)nb;
        if (!this.totalsStats.waitUntilBuilt()) {
            return list;
        }
        long prevTotal = start == this.totalsStats.getStartTime() ? 0L : this.getEventCountAt(start);
        long curTime = start + increment;
        int i = 0;
        while (i < nb - 1) {
            curTotal = this.getEventCountAt(curTime);
            count = curTotal - prevTotal;
            list.add(count);
            curTime += increment;
            prevTotal = curTotal;
            ++i;
        }
        curTotal = this.getEventCountAt(end);
        count = curTotal - prevTotal;
        list.add(count);
        return list;
    }

    @Override
    public long getEventsTotal() {
        this.totalsStats.waitUntilBuilt();
        long endTime = this.totalsStats.getCurrentEndTime();
        int count = 0;
        try {
            int quark = this.totalsStats.getQuarkAbsolute("total");
            count = this.totalsStats.querySingleState(endTime, quark).getStateValue().unboxInt();
        }
        catch (TimeRangeException e) {
            return 0L;
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
        catch (StateValueTypeException e) {
            e.printStackTrace();
        }
        catch (StateSystemDisposedException e) {
            e.printStackTrace();
        }
        return count;
    }

    @Override
    public Map<String, Long> getEventTypesTotal() {
        this.typesStats.waitUntilBuilt();
        HashMap<String, Long> map = new HashMap<String, Long>();
        long endTime = this.typesStats.getCurrentEndTime();
        try {
            int quark = this.typesStats.getQuarkAbsolute("event_types");
            List<Integer> quarks = this.typesStats.getSubAttributes(quark, false);
            List<ITmfStateInterval> endState = this.typesStats.queryFullState(endTime);
            for (int typeQuark : quarks) {
                String curEventName = this.typesStats.getAttributeName(typeQuark);
                long eventCount = endState.get(typeQuark).getStateValue().unboxInt();
                map.put(curEventName, eventCount);
            }
        }
        catch (TimeRangeException quark) {
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
        catch (StateValueTypeException e) {
            e.printStackTrace();
        }
        catch (StateSystemDisposedException e) {
            e.printStackTrace();
        }
        return map;
    }

    @Override
    public long getEventsInRange(long start, long end) {
        this.totalsStats.waitUntilBuilt();
        long startCount = start == this.totalsStats.getStartTime() ? 0L : this.getEventCountAt(start - 1L);
        long endCount = this.getEventCountAt(end);
        return endCount - startCount;
    }

    @Override
    public Map<String, Long> getEventTypesInRange(long start, long end) {
        this.typesStats.waitUntilBuilt();
        HashMap<String, Long> map = new HashMap<String, Long>();
        long startTime = this.checkStartTime(start);
        long endTime = this.checkEndTime(end);
        try {
            int quark = this.typesStats.getQuarkAbsolute("event_types");
            List<Integer> quarks = this.typesStats.getSubAttributes(quark, false);
            List<ITmfStateInterval> endState = this.typesStats.queryFullState(endTime);
            if (startTime == this.typesStats.getStartTime()) {
                for (int typeQuark : quarks) {
                    String curEventName = this.typesStats.getAttributeName(typeQuark);
                    long eventCount = endState.get(typeQuark).getStateValue().unboxInt();
                    if (eventCount == -1L) {
                        eventCount = 0L;
                    }
                    map.put(curEventName, eventCount);
                }
            } else {
                List<ITmfStateInterval> startState = this.typesStats.queryFullState(startTime - 1L);
                for (int typeQuark : quarks) {
                    String curEventName = this.typesStats.getAttributeName(typeQuark);
                    long countAtStart = startState.get(typeQuark).getStateValue().unboxInt();
                    long countAtEnd = endState.get(typeQuark).getStateValue().unboxInt();
                    if (countAtStart == -1L) {
                        countAtStart = 0L;
                    }
                    if (countAtEnd == -1L) {
                        countAtEnd = 0L;
                    }
                    long eventCount = countAtEnd - countAtStart;
                    map.put(curEventName, eventCount);
                }
            }
        }
        catch (TimeRangeException quark) {
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
        catch (StateValueTypeException e) {
            e.printStackTrace();
        }
        catch (StateSystemDisposedException e) {
            e.printStackTrace();
        }
        return map;
    }

    private long getEventCountAt(long timestamp) {
        long ts = this.checkStartTime(timestamp);
        ts = this.checkEndTime(ts);
        try {
            int quark = this.totalsStats.getQuarkAbsolute("total");
            long count = this.totalsStats.querySingleState(ts, quark).getStateValue().unboxInt();
            return count;
        }
        catch (TimeRangeException quark) {
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
        catch (StateValueTypeException e) {
            e.printStackTrace();
        }
        catch (StateSystemDisposedException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    private long checkStartTime(long initialStart) {
        long start = initialStart;
        if (start < this.totalsStats.getStartTime()) {
            return this.totalsStats.getStartTime();
        }
        return start;
    }

    private long checkEndTime(long initialEnd) {
        long end = initialEnd;
        if (end > this.totalsStats.getCurrentEndTime()) {
            return this.totalsStats.getCurrentEndTime();
        }
        return end;
    }

    private boolean waitUntilBuilt() {
        boolean check1 = this.totalsStats.waitUntilBuilt();
        boolean check2 = this.typesStats.waitUntilBuilt();
        return check1 && check2;
    }

    public static class Attributes {
        public static final String TOTAL = "total";
        public static final String EVENT_TYPES = "event_types";
    }
}

