/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.statesystem.backends;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.IStateHistoryBackend;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.interval.TmfStateInterval;
import org.eclipse.linuxtools.tmf.core.statevalue.ITmfStateValue;

public class InMemoryBackend
implements IStateHistoryBackend {
    private static final Comparator<ITmfStateInterval> END_COMPARATOR = new Comparator<ITmfStateInterval>(){

        @Override
        public int compare(ITmfStateInterval o1, ITmfStateInterval o2) {
            long e1 = o1.getEndTime();
            long e2 = o2.getEndTime();
            int a1 = o1.getAttribute();
            int a2 = o2.getAttribute();
            if (e1 < e2) {
                return -1;
            }
            if (e1 > e2) {
                return 1;
            }
            if (a1 < a2) {
                return -1;
            }
            if (a1 > a2) {
                return 1;
            }
            return 0;
        }
    };
    private final TreeSet<ITmfStateInterval> intervals;
    private final long startTime;
    private long latestTime;

    public InMemoryBackend(long startTime) {
        this.startTime = startTime;
        this.latestTime = startTime;
        this.intervals = new TreeSet<ITmfStateInterval>(END_COMPARATOR);
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.latestTime;
    }

    @Override
    public void insertPastState(long stateStartTime, long stateEndTime, int quark, ITmfStateValue value) throws TimeRangeException {
        if (stateStartTime > stateEndTime || stateStartTime < this.startTime) {
            throw new TimeRangeException();
        }
        TmfStateInterval interval = new TmfStateInterval(stateStartTime, stateEndTime, quark, value);
        if (stateEndTime > this.latestTime) {
            this.latestTime = stateEndTime;
        }
        this.intervals.add(interval);
    }

    @Override
    public void doQuery(List<ITmfStateInterval> currentStateInfo, long t) throws TimeRangeException {
        if (!this.checkValidTime(t)) {
            throw new TimeRangeException();
        }
        Iterator<ITmfStateInterval> iter = InMemoryBackend.serachforEndTime(this.intervals, t);
        int modCount = 0;
        while (iter.hasNext() && modCount < currentStateInfo.size()) {
            ITmfStateInterval entry = iter.next();
            long entryStartTime = entry.getStartTime();
            if (entryStartTime > t) continue;
            currentStateInfo.set(entry.getAttribute(), entry);
            ++modCount;
        }
    }

    @Override
    public ITmfStateInterval doSingularQuery(long t, int attributeQuark) throws TimeRangeException, AttributeNotFoundException {
        if (!this.checkValidTime(t)) {
            throw new TimeRangeException();
        }
        Iterator<ITmfStateInterval> iter = InMemoryBackend.serachforEndTime(this.intervals, t);
        while (iter.hasNext()) {
            ITmfStateInterval entry = iter.next();
            boolean attributeMatches = entry.getAttribute() == attributeQuark;
            long entryStartTime = entry.getStartTime();
            if (!attributeMatches || entryStartTime > t) continue;
            return entry;
        }
        throw new AttributeNotFoundException();
    }

    @Override
    public boolean checkValidTime(long t) {
        return t >= this.startTime && t <= this.latestTime;
    }

    @Override
    public void finishedBuilding(long endTime) throws TimeRangeException {
    }

    @Override
    public FileInputStream supplyAttributeTreeReader() {
        return null;
    }

    @Override
    public File supplyAttributeTreeWriterFile() {
        return null;
    }

    @Override
    public long supplyAttributeTreeWriterFilePosition() {
        return -1L;
    }

    @Override
    public void removeFiles() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void debugPrint(PrintWriter writer) {
        writer.println(this.intervals.toString());
    }

    private static Iterator<ITmfStateInterval> serachforEndTime(TreeSet<ITmfStateInterval> tree, long time) {
        TmfStateInterval dummyInterval = new TmfStateInterval(-1L, time, -1, null);
        ITmfStateInterval myInterval = tree.lower(dummyInterval);
        if (myInterval == null) {
            return tree.iterator();
        }
        SortedSet<ITmfStateInterval> tailSet = tree.tailSet(myInterval);
        Iterator<ITmfStateInterval> retVal = tailSet.iterator();
        retVal.next();
        return retVal;
    }
}

