/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.ctfadaptor;

import org.eclipse.linuxtools.ctf.core.trace.CTFTraceReader;
import org.eclipse.linuxtools.ctf.core.trace.StreamInputReader;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfLocation;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfLocationInfo;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEvent;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEventFactory;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;

public class CtfIterator
extends CTFTraceReader
implements ITmfContext,
Comparable<CtfIterator> {
    private final CtfTmfTrace ctfTmfTrace;
    public static final CtfLocation NULL_LOCATION = new CtfLocation(CtfLocation.INVALID_LOCATION);
    private CtfLocation curLocation;
    private long curRank;

    public CtfIterator(CtfTmfTrace trace) {
        super(trace.getCTFTrace());
        this.ctfTmfTrace = trace;
        if (this.hasMoreEvents()) {
            this.curLocation = new CtfLocation(trace.getStartTime());
            this.curRank = 0L;
        } else {
            this.setUnknownLocation();
        }
    }

    private void setUnknownLocation() {
        this.curLocation = NULL_LOCATION;
        this.curRank = -1L;
    }

    public CtfIterator(CtfTmfTrace trace, CtfLocationInfo ctfLocationData, long rank) {
        super(trace.getCTFTrace());
        this.ctfTmfTrace = trace;
        if (this.hasMoreEvents()) {
            this.curLocation = new CtfLocation(ctfLocationData);
            if (this.getCurrentEvent().getTimestamp().getValue() != ctfLocationData.getTimestamp()) {
                this.seek(ctfLocationData);
                this.curRank = rank;
            }
        } else {
            this.setUnknownLocation();
        }
    }

    public CtfTmfTrace getCtfTmfTrace() {
        return this.ctfTmfTrace;
    }

    public CtfTmfEvent getCurrentEvent() {
        StreamInputReader top = (StreamInputReader)super.getPrio().peek();
        if (top != null) {
            return CtfTmfEventFactory.createEvent(top.getCurrentEvent(), top.getFilename(), this.ctfTmfTrace);
        }
        return null;
    }

    public boolean seek(long timestamp) {
        return this.seek(new CtfLocationInfo(timestamp, 0L));
    }

    public synchronized boolean seek(CtfLocationInfo ctfLocationData) {
        boolean ret = false;
        long currTimestamp = ctfLocationData.getTimestamp();
        long offsetTimestamp = this.getCtfTmfTrace().getCTFTrace().timestampNanoToCycles(currTimestamp);
        ret = offsetTimestamp < 0L ? super.seek(0L) : super.seek(offsetTimestamp);
        long index = 0L;
        CtfTmfEvent currentEvent = this.getCurrentEvent();
        if (currentEvent != null) {
            currTimestamp = currentEvent.getTimestamp().getValue();
            long i = 0L;
            while (i < ctfLocationData.getIndex()) {
                index = currTimestamp == currentEvent.getTimestamp().getValue() ? ++index : 0L;
                this.advance();
                ++i;
            }
        } else {
            ret = false;
        }
        this.curLocation = ret ? new CtfLocation(new CtfLocationInfo(this.getCurrentEvent().getTimestamp().getValue(), index)) : NULL_LOCATION;
        return ret;
    }

    @Override
    public long getRank() {
        return this.curRank;
    }

    @Override
    public void setRank(long rank) {
        this.curRank = rank;
    }

    public CtfIterator clone() {
        CtfIterator clone = null;
        clone = new CtfIterator(this.ctfTmfTrace, this.getLocation().getLocationInfo(), this.curRank);
        return clone;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void setLocation(ITmfLocation location) {
        this.curLocation = (CtfLocation)location;
        this.seek(((CtfLocation)location).getLocationInfo());
    }

    @Override
    public CtfLocation getLocation() {
        return this.curLocation;
    }

    @Override
    public void increaseRank() {
        if (this.hasValidRank()) {
            ++this.curRank;
        }
    }

    @Override
    public boolean hasValidRank() {
        return this.getRank() >= 0L;
    }

    public synchronized boolean advance() {
        long timestampValue;
        long index = this.curLocation.getLocationInfo().getIndex();
        long timestamp = this.curLocation.getLocationInfo().getTimestamp();
        boolean ret = super.advance();
        this.curLocation = ret ? (timestamp == (timestampValue = this.getCurrentEvent().getTimestamp().getValue()) ? new CtfLocation(timestampValue, index + 1L) : new CtfLocation(timestampValue, 0L)) : NULL_LOCATION;
        return ret;
    }

    @Override
    public int compareTo(CtfIterator o) {
        if (this.getRank() < o.getRank()) {
            return -1;
        }
        if (this.getRank() > o.getRank()) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.ctfTmfTrace == null ? 0 : this.ctfTmfTrace.hashCode());
        result = 31 * result + (this.curLocation == null ? 0 : this.curLocation.hashCode());
        result = 31 * result + (int)(this.curRank ^ this.curRank >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CtfIterator)) {
            return false;
        }
        CtfIterator other = (CtfIterator)obj;
        if (this.ctfTmfTrace == null ? other.ctfTmfTrace != null : !this.ctfTmfTrace.equals(other.ctfTmfTrace)) {
            return false;
        }
        if (this.curLocation == null ? other.curLocation != null : !this.curLocation.equals(other.curLocation)) {
            return false;
        }
        return this.curRank == other.curRank;
    }
}

