/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.ctfadaptor;

import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfIterator;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfIteratorManager;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfLocation;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfLocationInfo;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEvent;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;

public class CtfTmfContext
implements ITmfContext {
    private CtfLocation curLocation;
    private long curRank;
    private final CtfTmfTrace fTrace;

    public CtfTmfContext(CtfTmfTrace ctfTmfTrace) {
        this.fTrace = ctfTmfTrace;
        this.curLocation = new CtfLocation(new CtfLocationInfo(0L, 0L));
    }

    @Override
    public long getRank() {
        return this.curRank;
    }

    @Override
    public ITmfLocation getLocation() {
        return this.curLocation;
    }

    @Override
    public boolean hasValidRank() {
        return this.curRank != CtfLocation.INVALID_LOCATION.getTimestamp();
    }

    @Override
    public void setLocation(ITmfLocation location) {
        this.curLocation = (CtfLocation)location;
        if (this.curLocation != null) {
            this.getIterator().seek(this.curLocation.getLocationInfo());
        }
    }

    @Override
    public void setRank(long rank) {
        this.curRank = rank;
    }

    @Override
    public void increaseRank() {
        if (this.hasValidRank()) {
            ++this.curRank;
        }
    }

    public CtfTmfTrace getTrace() {
        return this.fTrace;
    }

    public synchronized CtfTmfEvent getCurrentEvent() {
        return this.getIterator().getCurrentEvent();
    }

    public synchronized boolean advance() {
        CtfLocationInfo curLocationData = this.curLocation.getLocationInfo();
        boolean retVal = this.getIterator().advance();
        CtfTmfEvent currentEvent = this.getIterator().getCurrentEvent();
        if (currentEvent != null) {
            long timestampValue = currentEvent.getTimestamp().getValue();
            this.curLocation = curLocationData.getTimestamp() == timestampValue ? new CtfLocation(timestampValue, curLocationData.getIndex() + 1L) : new CtfLocation(timestampValue, 0L);
        } else {
            this.curLocation = new CtfLocation(CtfLocation.INVALID_LOCATION);
        }
        return retVal;
    }

    @Override
    public void dispose() {
        CtfIteratorManager.removeIterator(this.fTrace, this);
    }

    public synchronized boolean seek(long timestamp) {
        this.curLocation = new CtfLocation(timestamp, 0L);
        return this.getIterator().seek(timestamp);
    }

    public synchronized boolean seek(CtfLocationInfo location) {
        this.curLocation = new CtfLocation(location);
        return this.getIterator().seek(location);
    }

    public CtfTmfContext clone() {
        CtfTmfContext ret = null;
        try {
            ret = (CtfTmfContext)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return ret;
    }

    private CtfIterator getIterator() {
        return CtfIteratorManager.getIterator(this.fTrace, this);
    }
}

