/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.interval;

import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.statevalue.ITmfStateValue;

public final class TmfStateInterval
implements ITmfStateInterval {
    private final long start;
    private final long end;
    private final int attribute;
    private final ITmfStateValue sv;

    public TmfStateInterval(long start, long end, int attribute, ITmfStateValue sv) {
        this.start = start;
        this.end = end;
        this.attribute = attribute;
        this.sv = sv;
    }

    @Override
    public long getStartTime() {
        return this.start;
    }

    @Override
    public long getEndTime() {
        return this.end;
    }

    @Override
    public long getViewerEndTime() {
        return this.end + 1L;
    }

    @Override
    public int getAttribute() {
        return this.attribute;
    }

    @Override
    public ITmfStateValue getStateValue() {
        return this.sv;
    }

    @Override
    public boolean intersects(long timestamp) {
        return this.start <= timestamp && this.end >= timestamp;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(String.valueOf(this.start) + " to ");
        buf.append(String.valueOf(this.end) + ", ");
        buf.append(String.format("key = %4d, ", this.attribute));
        buf.append("value = " + this.sv.toString());
        return buf.toString();
    }
}

