/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.timestamp;

import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestampDelta;

public class TmfNanoTimestamp
extends TmfTimestamp {
    public TmfNanoTimestamp() {
        this(0L);
    }

    public TmfNanoTimestamp(long value) {
        super(value, -9, 0);
    }

    public TmfNanoTimestamp(ITmfTimestamp timestamp) {
        super(timestamp.normalize(0L, -9).getValue(), -9, 0);
    }

    @Override
    public ITmfTimestamp normalize(long offset, int scale) {
        if (scale == -9) {
            return new TmfNanoTimestamp(this.getValue() + offset);
        }
        return super.normalize(offset, scale);
    }

    @Override
    public int compareTo(ITmfTimestamp ts, boolean withinPrecision) {
        if (ts instanceof TmfNanoTimestamp) {
            long delta = this.getValue() - ts.getValue();
            return delta == 0L ? 0 : (delta > 0L ? 1 : -1);
        }
        return super.compareTo(ts, withinPrecision);
    }

    @Override
    public ITmfTimestamp getDelta(ITmfTimestamp ts) {
        if (ts instanceof TmfNanoTimestamp) {
            return new TmfTimestampDelta(this.getValue() - ts.getValue(), -9);
        }
        return super.getDelta(ts);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof TmfNanoTimestamp)) {
            return super.equals(other);
        }
        TmfNanoTimestamp ts = (TmfNanoTimestamp)other;
        return this.compareTo(ts, false) == 0;
    }
}

