/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.trace;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.tmf.core.component.TmfEventProvider;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceRangeUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateSystem;
import org.eclipse.linuxtools.tmf.core.statistics.ITmfStatistics;
import org.eclipse.linuxtools.tmf.core.statistics.TmfStateStatistics;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfEventParser;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTraceIndexer;
import org.eclipse.linuxtools.tmf.core.trace.TmfCheckpointIndexer;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;

public abstract class TmfTrace
extends TmfEventProvider
implements ITmfTrace {
    private IResource fResource;
    private String fPath;
    private int fCacheSize = 1000;
    private long fNbEvents = 0L;
    private ITmfTimestamp fStartTime = TmfTimestamp.BIG_BANG;
    private ITmfTimestamp fEndTime = TmfTimestamp.BIG_BANG;
    private long fStreamingInterval = 0L;
    private ITmfTraceIndexer fIndexer;
    private ITmfEventParser fParser;
    private ITmfStatistics fStatistics;
    protected final Map<String, ITmfStateSystem> fStateSystems = new LinkedHashMap<String, ITmfStateSystem>();

    public TmfTrace() {
    }

    protected TmfTrace(IResource resource, Class<? extends ITmfEvent> type, String path, int cacheSize, long interval, ITmfTraceIndexer indexer, ITmfEventParser parser) throws TmfTraceException {
        this.fCacheSize = cacheSize > 0 ? cacheSize : 1000;
        this.fStreamingInterval = interval;
        this.fIndexer = indexer != null ? indexer : new TmfCheckpointIndexer(this, this.fCacheSize);
        this.fParser = parser;
        this.initialize(resource, path, type);
    }

    public TmfTrace(TmfTrace trace) throws TmfTraceException {
        if (trace == null) {
            throw new IllegalArgumentException();
        }
        this.fCacheSize = trace.getCacheSize();
        this.fStreamingInterval = trace.getStreamingInterval();
        this.fIndexer = new TmfCheckpointIndexer(this);
        this.fParser = trace.fParser;
        this.initialize(trace.getResource(), trace.getPath(), trace.getEventType());
    }

    @Override
    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> type) throws TmfTraceException {
        this.fIndexer = new TmfCheckpointIndexer(this, this.fCacheSize);
        this.initialize(resource, path, type);
    }

    protected void initialize(IResource resource, String path, Class<? extends ITmfEvent> type) throws TmfTraceException {
        String traceName;
        if (path == null) {
            throw new TmfTraceException("Invalid trace path");
        }
        this.fPath = path;
        this.fResource = resource;
        String string = traceName = resource != null ? resource.getName() : null;
        if (traceName == null) {
            int sep = path.lastIndexOf(47);
            String string2 = traceName = sep >= 0 ? path.substring(sep + 1) : path;
        }
        if (this.fParser == null) {
            if (this instanceof ITmfEventParser) {
                this.fParser = (ITmfEventParser)((Object)this);
            } else {
                throw new TmfTraceException("Invalid trace parser");
            }
        }
        super.init(traceName, type);
        TmfSignalManager.registerVIP(this);
    }

    protected boolean fileExists(String path) {
        File file = new File(path);
        return file.exists();
    }

    @Override
    public void indexTrace(boolean waitForCompletion) {
        this.getIndexer().buildIndex(0L, TmfTimeRange.ETERNITY, waitForCompletion);
    }

    protected void buildStatistics() throws TmfTraceException {
        this.fStatistics = this.fResource == null ? null : new TmfStateStatistics(this);
    }

    protected void buildStateSystem() throws TmfTraceException {
    }

    @Override
    public synchronized void dispose() {
        if (this.getIndexer() != null) {
            this.getIndexer().dispose();
        }
        if (this.fStatistics != null) {
            this.fStatistics.dispose();
        }
        for (ITmfStateSystem ss : this.fStateSystems.values()) {
            ss.dispose();
        }
        super.dispose();
    }

    public Class<ITmfEvent> getEventType() {
        return super.getType();
    }

    @Override
    public IResource getResource() {
        return this.fResource;
    }

    @Override
    public String getPath() {
        return this.fPath;
    }

    @Override
    public int getCacheSize() {
        return this.fCacheSize;
    }

    @Override
    public long getStreamingInterval() {
        return this.fStreamingInterval;
    }

    protected ITmfTraceIndexer getIndexer() {
        return this.fIndexer;
    }

    protected ITmfEventParser getParser() {
        return this.fParser;
    }

    @Override
    public ITmfStatistics getStatistics() {
        return this.fStatistics;
    }

    @Override
    public final Map<String, ITmfStateSystem> getStateSystems() {
        return Collections.unmodifiableMap(this.fStateSystems);
    }

    @Override
    public final void registerStateSystem(String id, ITmfStateSystem ss) {
        this.fStateSystems.put(id, ss);
    }

    @Override
    public synchronized long getNbEvents() {
        return this.fNbEvents;
    }

    @Override
    public TmfTimeRange getTimeRange() {
        return new TmfTimeRange(this.fStartTime, this.fEndTime);
    }

    @Override
    public ITmfTimestamp getStartTime() {
        return this.fStartTime;
    }

    @Override
    public ITmfTimestamp getEndTime() {
        return this.fEndTime;
    }

    @Override
    public ITmfTimestamp getInitialRangeOffset() {
        long DEFAULT_INITIAL_OFFSET_VALUE = 100000000L;
        return new TmfTimestamp(100000000L, -9);
    }

    protected void setCacheSize(int cacheSize) {
        this.fCacheSize = cacheSize;
    }

    protected synchronized void setNbEvents(long nbEvents) {
        this.fNbEvents = nbEvents > 0L ? nbEvents : 0L;
    }

    protected void setTimeRange(TmfTimeRange range) {
        this.fStartTime = range.getStartTime();
        this.fEndTime = range.getEndTime();
    }

    protected void setStartTime(ITmfTimestamp startTime) {
        this.fStartTime = startTime;
    }

    protected void setEndTime(ITmfTimestamp endTime) {
        this.fEndTime = endTime;
    }

    protected void setStreamingInterval(long interval) {
        this.fStreamingInterval = interval > 0L ? interval : 0L;
    }

    protected void setIndexer(ITmfTraceIndexer indexer) {
        this.fIndexer = indexer;
    }

    protected void setParser(ITmfEventParser parser) {
        this.fParser = parser;
    }

    @Override
    public synchronized ITmfContext seekEvent(long rank) {
        if (rank <= 0L) {
            ITmfContext context = this.seekEvent((ITmfLocation)null);
            context.setRank(0L);
            return context;
        }
        ITmfContext context = this.fIndexer.seekIndex(rank);
        long pos = context.getRank();
        if (pos < rank) {
            ITmfEvent event = this.getNext(context);
            while (event != null && ++pos < rank) {
                event = this.getNext(context);
            }
        }
        return context;
    }

    @Override
    public synchronized ITmfContext seekEvent(ITmfTimestamp timestamp) {
        if (timestamp == null) {
            ITmfContext context = this.seekEvent((ITmfLocation)null);
            context.setRank(0L);
            return context;
        }
        ITmfContext context = this.fIndexer.seekIndex(timestamp);
        ITmfLocation previousLocation = context.getLocation();
        long previousRank = context.getRank();
        ITmfEvent event = this.getNext(context);
        while (event != null && event.getTimestamp().compareTo(timestamp, false) < 0) {
            previousLocation = context.getLocation();
            previousRank = context.getRank();
            event = this.getNext(context);
        }
        if (event == null) {
            context.setLocation(null);
            context.setRank(-1L);
        } else {
            context.dispose();
            context = this.seekEvent(previousLocation);
            context.setRank(previousRank);
        }
        return context;
    }

    @Override
    public synchronized ITmfEvent getNext(ITmfContext context) {
        ITmfEvent event = this.fParser.parseEvent(context);
        if (event != null) {
            this.updateAttributes(context, event.getTimestamp());
            context.setLocation(this.getCurrentLocation());
            context.increaseRank();
            this.processEvent(event);
        }
        return event;
    }

    protected void processEvent(ITmfEvent event) {
    }

    protected synchronized void updateAttributes(ITmfContext context, ITmfTimestamp timestamp) {
        if (this.fStartTime.equals(TmfTimestamp.BIG_BANG) || this.fStartTime.compareTo(timestamp, false) > 0) {
            this.fStartTime = timestamp;
        }
        if (this.fEndTime.equals(TmfTimestamp.BIG_CRUNCH) || this.fEndTime.compareTo(timestamp, false) < 0) {
            this.fEndTime = timestamp;
        }
        if (context.hasValidRank()) {
            long rank = context.getRank();
            if (this.fNbEvents <= rank) {
                this.fNbEvents = rank + 1L;
            }
            if (this.fIndexer != null) {
                this.fIndexer.updateIndex(context, timestamp);
            }
        }
    }

    @Override
    public synchronized ITmfContext armRequest(ITmfDataRequest request) {
        if (this.executorIsShutdown()) {
            return null;
        }
        if (request instanceof ITmfEventRequest && !TmfTimestamp.BIG_BANG.equals(((ITmfEventRequest)request).getRange().getStartTime()) && request.getIndex() == 0L) {
            ITmfContext context = this.seekEvent(((ITmfEventRequest)request).getRange().getStartTime());
            ((ITmfEventRequest)request).setStartIndex((int)context.getRank());
            return context;
        }
        return this.seekEvent(request.getIndex());
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        boolean signalIsForUs = false;
        ITmfTrace[] iTmfTraceArray = TmfTraceManager.getTraceSet(signal.getTrace());
        int n = iTmfTraceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTrace trace = iTmfTraceArray[n2];
            if (trace == this) {
                signalIsForUs = true;
                break;
            }
            ++n2;
        }
        if (!signalIsForUs) {
            return;
        }
        try {
            this.buildStatistics();
            this.buildStateSystem();
        }
        catch (TmfTraceException e) {
            e.printStackTrace();
        }
        try {
            if (this.fResource != null) {
                this.fResource.getProject().refreshLocal(2, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (signal.getTrace() == this) {
            if (this.getNbEvents() == 0L) {
                return;
            }
            if (this.getStreamingInterval() > 0L) {
                return;
            }
            TmfTimeRange timeRange = new TmfTimeRange(this.getStartTime(), TmfTimestamp.BIG_CRUNCH);
            final TmfTraceRangeUpdatedSignal rangeUpdatedsignal = new TmfTraceRangeUpdatedSignal(this, this, timeRange);
            new Thread(){

                @Override
                public void run() {
                    TmfTrace.this.broadcast(rangeUpdatedsignal);
                }
            }.start();
            return;
        }
    }

    @TmfSignalHandler
    public void traceRangeUpdated(TmfTraceRangeUpdatedSignal signal) {
        if (signal.getTrace() == this) {
            this.getIndexer().buildIndex(this.getNbEvents(), signal.getRange(), false);
        }
    }

    public synchronized String toString() {
        return "TmfTrace [fPath=" + this.fPath + ", fCacheSize=" + this.fCacheSize + ", fNbEvents=" + this.fNbEvents + ", fStartTime=" + this.fStartTime + ", fEndTime=" + this.fEndTime + ", fStreamingInterval=" + this.fStreamingInterval + "]";
    }
}

