/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.trace;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.filter.ITmfFilter;
import org.eclipse.linuxtools.tmf.core.signal.TmfEventFilterAppliedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfRangeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceContext;

public final class TmfTraceManager {
    private final Map<ITmfTrace, TmfTraceContext> fTraces = new LinkedHashMap<ITmfTrace, TmfTraceContext>();
    private ITmfTrace fCurrentTrace = null;
    private static TmfTraceManager tm = null;

    private TmfTraceManager() {
        TmfSignalManager.registerVIP(this);
    }

    public static synchronized TmfTraceManager getInstance() {
        if (tm == null) {
            tm = new TmfTraceManager();
        }
        return tm;
    }

    @Deprecated
    public synchronized ITmfTimestamp getCurrentTime() {
        return this.getCurrentTraceContext().getSelectionBegin();
    }

    public ITmfTimestamp getSelectionBeginTime() {
        return this.getCurrentTraceContext().getSelectionBegin();
    }

    public ITmfTimestamp getSelectionEndTime() {
        return this.getCurrentTraceContext().getSelectionEnd();
    }

    public synchronized TmfTimeRange getCurrentRange() {
        return this.getCurrentTraceContext().getWindowRange();
    }

    public synchronized ITmfFilter getCurrentFilter() {
        return this.getCurrentTraceContext().getFilter();
    }

    public synchronized ITmfTrace getActiveTrace() {
        return this.fCurrentTrace;
    }

    public synchronized ITmfTrace[] getActiveTraceSet() {
        ITmfTrace trace = this.fCurrentTrace;
        return TmfTraceManager.getTraceSet(trace);
    }

    public synchronized Set<ITmfTrace> getOpenedTraces() {
        return Collections.unmodifiableSet(this.fTraces.keySet());
    }

    private TmfTraceContext getCurrentTraceContext() {
        TmfTraceContext curCtx = this.fTraces.get(this.fCurrentTrace);
        if (curCtx == null) {
            return TmfTraceContext.NULL_CONTEXT;
        }
        return curCtx;
    }

    public static ITmfTrace[] getTraceSet(ITmfTrace trace) {
        if (trace == null) {
            return null;
        }
        if (trace instanceof TmfExperiment) {
            TmfExperiment exp = (TmfExperiment)trace;
            return exp.getTraces();
        }
        return new ITmfTrace[]{trace};
    }

    public static String getSupplementaryFileDir(ITmfTrace trace) {
        IResource resource = trace.getResource();
        if (resource == null) {
            return TmfTraceManager.getTemporaryDir(trace);
        }
        String supplDir = null;
        try {
            supplDir = resource.getPersistentProperty(TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER);
        }
        catch (CoreException e) {
            return TmfTraceManager.getTemporaryDir(trace);
        }
        return String.valueOf(supplDir) + File.separator;
    }

    @TmfSignalHandler
    public synchronized void traceOpened(TmfTraceOpenedSignal signal) {
        ITmfTrace trace = signal.getTrace();
        ITmfTimestamp startTs = trace.getStartTime();
        int SCALE = -9;
        long offset = trace.getInitialRangeOffset().normalize(0L, -9).getValue();
        long endTime = startTs.normalize(0L, -9).getValue() + offset;
        TmfTimeRange startTr = new TmfTimeRange(startTs, new TmfTimestamp(endTime, -9));
        TmfTraceContext startCtx = new TmfTraceContext(startTs, startTs, startTr);
        this.fTraces.put(trace, startCtx);
        this.fCurrentTrace = trace;
    }

    @TmfSignalHandler
    public synchronized void traceSelected(TmfTraceSelectedSignal signal) {
        ITmfTrace newTrace = signal.getTrace();
        if (!this.fTraces.containsKey(newTrace)) {
            throw new RuntimeException();
        }
        this.fCurrentTrace = newTrace;
    }

    @TmfSignalHandler
    public synchronized void filterApplied(TmfEventFilterAppliedSignal signal) {
        ITmfTrace newTrace = signal.getTrace();
        TmfTraceContext context = this.fTraces.get(newTrace);
        if (context == null) {
            throw new RuntimeException();
        }
        this.fTraces.put(newTrace, new TmfTraceContext(context, signal.getEventFilter()));
    }

    @TmfSignalHandler
    public synchronized void traceClosed(TmfTraceClosedSignal signal) {
        this.fTraces.remove(signal.getTrace());
        if (this.fTraces.size() == 0) {
            this.fCurrentTrace = null;
        }
    }

    @TmfSignalHandler
    public synchronized void timeUpdated(TmfTimeSynchSignal signal) {
        ITmfTimestamp beginTs = signal.getBeginTime();
        ITmfTimestamp endTs = signal.getEndTime();
        for (Map.Entry<ITmfTrace, TmfTraceContext> entry : this.fTraces.entrySet()) {
            ITmfTrace trace = entry.getKey();
            if (!beginTs.intersects(this.getValidTimeRange(trace)) && !endTs.intersects(this.getValidTimeRange(trace))) continue;
            TmfTraceContext prevCtx = entry.getValue();
            TmfTraceContext newCtx = new TmfTraceContext(prevCtx, beginTs, endTs);
            entry.setValue(newCtx);
        }
    }

    @TmfSignalHandler
    public synchronized void timeRangeUpdated(TmfRangeSynchSignal signal) {
        for (Map.Entry<ITmfTrace, TmfTraceContext> entry : this.fTraces.entrySet()) {
            ITmfTrace trace = entry.getKey();
            TmfTraceContext curCtx = entry.getValue();
            TmfTimeRange validTr = this.getValidTimeRange(trace);
            TmfTimeRange targetTr = signal.getCurrentRange().getIntersection(validTr);
            TmfTimeRange newTr = targetTr == null ? curCtx.getWindowRange() : targetTr;
            TmfTraceContext newCtx = new TmfTraceContext(curCtx, newTr);
            entry.setValue(newCtx);
        }
    }

    private TmfTimeRange getValidTimeRange(ITmfTrace trace) {
        if (!this.fTraces.containsKey(trace)) {
            return null;
        }
        if (!(trace instanceof TmfExperiment)) {
            return trace.getTimeRange();
        }
        ITmfTrace[] traces = ((TmfExperiment)trace).getTraces();
        if (traces.length == 0) {
            return null;
        }
        if (traces.length == 1) {
            return traces[0].getTimeRange();
        }
        ITmfTimestamp start = traces[0].getStartTime();
        ITmfTimestamp end = traces[0].getEndTime();
        int i = 1;
        while (i < traces.length) {
            ITmfTrace curTrace = traces[i];
            if (curTrace.getStartTime().compareTo(start) < 0) {
                start = curTrace.getStartTime();
            }
            if (curTrace.getEndTime().compareTo(end) > 0) {
                end = curTrace.getEndTime();
            }
            ++i;
        }
        return new TmfTimeRange(start, end);
    }

    private static String getTemporaryDir(ITmfTrace trace) {
        return String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + trace.getName() + File.separator;
    }
}

