/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.ui.ICHelpBook;
import org.eclipse.cdt.ui.ICHelpProvider;
import org.eclipse.cdt.ui.ICHelpResourceDescriptor;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.IRequiredInclude;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.cdt.ui.text.IHoverHelpInvocationContext;
import org.eclipse.cdt.ui.text.SharedASTJob;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.IHelpResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.linuxtools.cdt.libhover.ClassInfo;
import org.eclipse.linuxtools.cdt.libhover.FunctionInfo;
import org.eclipse.linuxtools.cdt.libhover.HelpBook;
import org.eclipse.linuxtools.cdt.libhover.LibHoverInfo;
import org.eclipse.linuxtools.cdt.libhover.LibhoverPlugin;
import org.eclipse.linuxtools.cdt.libhover.MemberInfo;
import org.eclipse.linuxtools.internal.cdt.libhover.LibHoverLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibHover
implements ICHelpProvider {
    public static final String LIBHOVER_DOC_EXTENSION = "org.eclipse.linuxtools.cdt.libhover.library";
    private static ConcurrentHashMap<ICHelpBook, LibHoverLibrary> libraries = new ConcurrentHashMap();
    static final String[] constructTypes = new String[]{"dtype", "enum", "function", "groupsynopsis", "struct", "type", "union"};
    static final int dtypeIndex = 0;
    static final int enumIndex = 1;
    static final int functionIndex = 2;
    static final int groupsynopsisIndex = 3;
    static final int structIndex = 4;
    static final int typeIndex = 5;
    static final int unionIndex = 6;
    private static ArrayList<ICHelpBook> helpBooks = new ArrayList();
    private static Map<String, ICHelpBook> helpBooksMap = new HashMap<String, ICHelpBook>();
    public static boolean docsFetched = false;

    public static Collection<LibHoverLibrary> getLibraries() {
        return libraries.values();
    }

    public static void saveLibraries() {
        IPreferenceStore ps = LibhoverPlugin.getDefault().getPreferenceStore();
        if (ps.getBoolean("org.eclipse.linuxtools.cdt.libhover.cacheExtLibhover")) {
            IPath locationBase = LibhoverPlugin.getDefault().getStateLocation();
            for (LibHoverLibrary l : libraries.values()) {
                try {
                    IPath locationDir = locationBase;
                    locationDir = l.isCPP() ? locationBase.append("CPP") : locationBase.append("C");
                    File lDir = new File(locationDir.toOSString());
                    lDir.mkdir();
                    IPath location = locationDir.append(String.valueOf(LibHover.getTransformedName(l.getName())) + ".libhover");
                    File target = new File(location.toOSString());
                    if (target.exists()) continue;
                    FileOutputStream f = new FileOutputStream(locationDir.append("tmpFile").toOSString());
                    ObjectOutputStream out = new ObjectOutputStream(f);
                    out.writeObject(l.getHoverInfo());
                    out.close();
                    File tmp = new File(locationDir.append("tmpFile").toOSString());
                    tmp.renameTo(target);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static synchronized void getLibHoverDocs() {
        if (docsFetched) {
            return;
        }
        libraries.clear();
        helpBooks.clear();
        helpBooksMap.clear();
        IPreferenceStore ps = LibhoverPlugin.getDefault().getPreferenceStore();
        if (ps.getBoolean("org.eclipse.linuxtools.cdt.libhover.cacheExtLibhover")) {
            IFileStore cppDir;
            IPath stateLocation = LibhoverPlugin.getDefault().getStateLocation();
            IFileSystem fs = EFS.getLocalFileSystem();
            IPath CLibraryLocation = stateLocation.append("C");
            IPath CPPLibraryLocation = stateLocation.append("CPP");
            IFileStore cDir = fs.getStore(CLibraryLocation);
            if (cDir.fetchInfo().exists()) {
                LibHover.getCachedLibraries(cDir, "C");
            }
            if ((cppDir = fs.getStore(CPPLibraryLocation)).fetchInfo().exists()) {
                LibHover.getCachedLibraries(cppDir, "C++");
            }
        }
        IExtensionRegistry x = RegistryFactory.getRegistry();
        IConfigurationElement[] ces = x.getConfigurationElementsFor(LIBHOVER_DOC_EXTENSION);
        int i = 0;
        while (i < ces.length) {
            IConfigurationElement ce = ces[i];
            if (ce.getName().equals("library")) {
                String location = ce.getAttribute("location");
                String name = ce.getAttribute("name");
                String helpdocs = ce.getAttribute("docs");
                String type = ce.getAttribute("type");
                String nameSpace = ce.getContributor().getName();
                ICHelpBook book = helpBooksMap.get(name);
                if (book == null) {
                    HelpBook h = new HelpBook(name, type);
                    helpBooks.add(h);
                    helpBooksMap.put(name, h);
                    LibHoverLibrary l = new LibHoverLibrary(name, location, helpdocs, nameSpace, "C++".equals(type));
                    libraries.put(h, l);
                } else {
                    LibHoverLibrary l = libraries.get(book);
                    if (l != null) {
                        l.setDocs(helpdocs);
                    }
                }
                docsFetched = true;
            }
            ++i;
        }
    }

    private static String getTransformedName(String name) {
        return name.replaceAll("\\s", "_");
    }

    private static String getCleanName(String name) {
        return name.replaceAll("_", " ");
    }

    private static void getCachedLibraries(IFileStore dir, String type) {
        try {
            boolean isCPP = type.equals("C++");
            IFileStore[] files = dir.childStores(0, null);
            int i = 0;
            while (i < files.length) {
                File f;
                IFileStore file = files[i];
                String fileName = file.fetchInfo().getName();
                if (fileName.endsWith(".libhover") && (f = file.toLocalFile(0, null)) != null) {
                    String name = LibHover.getCleanName(fileName.substring(0, fileName.length() - 9));
                    HelpBook h = new HelpBook(name, type);
                    helpBooks.add(h);
                    helpBooksMap.put(name, h);
                    String location = file.toURI().toString();
                    LibHoverLibrary l = new LibHoverLibrary(name, location, null, null, isCPP);
                    libraries.put(h, l);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void initialize() {
        LibHover.getLibHoverDocs();
    }

    public ICHelpBook[] getCHelpBooks() {
        ICHelpBook[] chelpbooks = new ICHelpBook[helpBooks.size()];
        return helpBooks.toArray(chelpbooks);
    }

    public boolean isCPPCharacter(int ch) {
        return Character.isLetterOrDigit(ch) || ch == 95 || ch == 58;
    }

    public IFunctionSummary getFunctionInfo(ICHelpInvocationContext context, ICHelpBook[] helpBooks, String name) {
        ICPPFunctionType methodType;
        String className;
        IFunctionSummary f;
        block15: {
            f = null;
            ITranslationUnit t = context.getTranslationUnit();
            className = null;
            methodType = null;
            if (t.isCXXLanguage()) {
                try {
                    IBinding binding;
                    if (!(context instanceof IHoverHelpInvocationContext)) break block15;
                    IRegion region = ((IHoverHelpInvocationContext)context).getHoverRegion();
                    IASTName[] result = new IASTName[1];
                    EnclosingASTNameJob job = new EnclosingASTNameJob(t, region.getOffset(), region.getLength());
                    job.schedule();
                    try {
                        job.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (job.getResult() == Status.OK_STATUS) {
                        result[0] = job.getASTName();
                    }
                    if (result[0] != null && (binding = result[0].getBinding()) instanceof ICPPFunction) {
                        methodType = ((ICPPFunction)binding).getType();
                        IBinding owner = ((ICPPFunction)binding).getOwner();
                        if (owner instanceof ICPPClassType) {
                            className = this.getClassName((ICPPClassType)owner);
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        int i = 0;
        while (i < helpBooks.length) {
            LibHoverLibrary l = libraries.get(helpBooks[i]);
            if (name != null) {
                if (className != null) {
                    if (l.isCPP()) {
                        f = this.getMemberSummary(l, className, name, methodType);
                    }
                } else {
                    f = this.getFunctionSummary(l, name);
                }
                if (f != null) {
                    return f;
                }
            }
            ++i;
        }
        return null;
    }

    private String getClassName(ICPPClassType c) {
        String className = null;
        try {
            String[] qualified = c.getQualifiedName();
            className = qualified[0];
            int k = 1;
            while (k < qualified.length) {
                className = String.valueOf(className) + "::" + qualified[k];
                ++k;
            }
            if (c instanceof ICPPTemplateInstance) {
                ICPPTemplateInstance ti = (ICPPTemplateInstance)c;
                ICPPTemplateParameterMap tiMap = ti.getTemplateParameterMap();
                ICPPTemplateDefinition td = ti.getTemplateDefinition();
                ICPPTemplateParameter[] templateArgs = td.getTemplateParameters();
                className = String.valueOf(className) + "<";
                String separator = "";
                int x = 0;
                while (x < templateArgs.length) {
                    ICPPTemplateParameter tp = templateArgs[x];
                    ICPPTemplateArgument ta = tiMap.getArgument(tp);
                    IType type = null;
                    type = ta.isTypeValue() ? ta.getTypeValue() : ta.getTypeOfNonTypeValue();
                    if (tp.getTemplateNestingLevel() == 0) {
                        className = type instanceof ICPPClassType ? String.valueOf(className) + separator + this.getClassName((ICPPClassType)type) : String.valueOf(className) + separator + type.toString();
                        separator = ",";
                    }
                    ++x;
                }
                className = String.valueOf(className) + ">";
            }
        }
        catch (DOMException e) {
            return null;
        }
        return className;
    }

    private IFunctionSummary getFunctionSummary(LibHoverLibrary l, String name) {
        FunctionInfo x = l.getFunctionInfo(name);
        if (x != null) {
            FunctionSummary f = new FunctionSummary();
            f.ReturnType = x.getReturnType();
            f.Prototype = x.getPrototype();
            f.Summary = x.getDescription();
            f.Name = x.getName();
            ArrayList<String> headers = x.getHeaders();
            int i = 0;
            while (i < headers.size()) {
                f.setIncludeName(headers.get(i));
                ++i;
            }
            return f;
        }
        return null;
    }

    private IFunctionSummary getMemberSummary(LibHoverLibrary l, String className, String memberName, ICPPFunctionType methodType) {
        MemberInfo member;
        ArrayList<String> templateTypes = new ArrayList<String>();
        ClassInfo info = l.getClassInfo(className, templateTypes);
        String[] args = new String[]{};
        IType returnType = null;
        if (info == null) {
            return null;
        }
        if (methodType != null) {
            try {
                args = this.resolveArgs(info, methodType.getParameterTypes(), templateTypes);
                returnType = methodType.getReturnType();
            }
            catch (Exception e) {
                return null;
            }
        }
        if ((member = info.getMember(memberName)) != null) {
            MemberInfo m = null;
            if (!this.isParmMatch(member, args, templateTypes, info)) {
                ArrayList<MemberInfo> members = member.getChildren();
                int i = 0;
                while (i < members.size()) {
                    MemberInfo k = members.get(i);
                    if (this.isParmMatch(k, args, templateTypes, info)) {
                        m = k;
                        break;
                    }
                    ++i;
                }
            } else {
                m = member;
            }
            if (m != null) {
                FunctionSummary f = new FunctionSummary();
                f.ReturnType = m.getReturnType();
                f.Prototype = m.getPrototype();
                f.Summary = m.getDescription();
                f.Name = String.valueOf(className) + "::" + memberName;
                String[] templateParms = info.getTemplateParms();
                int i = 0;
                while (i < templateTypes.size()) {
                    f.ReturnType = f.ReturnType.replaceAll(templateParms[i], templateTypes.get(i));
                    f.Prototype = f.Prototype.replaceAll(templateParms[i], templateTypes.get(i));
                    f.Name = f.Name.replaceAll(templateParms[i], templateTypes.get(i));
                    ++i;
                }
                if (f.ReturnType.indexOf(60) >= 0) {
                    f.ReturnType = f.ReturnType.replaceAll("<", "&lt;");
                    f.ReturnType = f.ReturnType.replaceAll(">", "&gt;");
                }
                if (f.Prototype.indexOf(60) >= 0) {
                    f.Prototype = f.Prototype.replaceAll("<", "&lt;");
                    f.Prototype = f.Prototype.replaceAll(">", "&gt;");
                }
                if (f.Name.indexOf(60) >= 0) {
                    f.Name = f.Name.replaceAll("<", "&lt;");
                    f.Name = f.Name.replaceAll(">", "&gt;");
                }
                f.setPrototypeHasBrackets(true);
                f.setIncludeName(info.getInclude());
                return f;
            }
        }
        return null;
    }

    private boolean isParmMatch(MemberInfo m, String[] args, ArrayList<String> templateTypes, ClassInfo info) {
        Object[] memberParms = m.getParamTypes();
        String className = info.getClassName();
        int index = className.lastIndexOf("::");
        String unqualifiedName = className.substring(index + 2);
        int i = 0;
        while (i < memberParms.length) {
            String[] templateParms = info.getTemplateParms();
            int j = 0;
            while (j < templateTypes.size()) {
                memberParms[i] = ((String)memberParms[i]).replaceAll(templateParms[j], templateTypes.get(j));
                ++j;
            }
            if (((String)memberParms[i]).contains(unqualifiedName) && !((String)memberParms[i]).contains(className)) {
                String classTemplate = "";
                if (templateTypes.size() > 0) {
                    classTemplate = "<";
                    String separator = "";
                    int j2 = 0;
                    while (j2 < templateTypes.size()) {
                        classTemplate = String.valueOf(classTemplate) + separator + templateTypes.get(j2);
                        separator = ",";
                        ++j2;
                    }
                    classTemplate = String.valueOf(classTemplate) + ">";
                }
                memberParms[i] = ((String)memberParms[i]).replaceAll(unqualifiedName, String.valueOf(className) + classTemplate);
            }
            ++i;
        }
        return Arrays.equals(memberParms, args);
    }

    private String[] resolveArgs(ClassInfo info, IType[] parameterTypes, ArrayList<String> templateTypes) {
        String[] templateParms = info.getTemplateParms();
        String[] result = new String[parameterTypes.length];
        int i = 0;
        while (i < parameterTypes.length) {
            String param = parameterTypes[i].toString();
            param = param.replaceAll("\\{.*\\}", "");
            param = param.trim();
            int index = param.indexOf("#");
            while (index >= 0) {
                int digit = param.charAt(index + 1) - 48;
                param = digit < templateTypes.size() ? param.replaceFirst(param.substring(index, index + 2), templateTypes.get(digit)) : param.replaceFirst(param.substring(index, index + 2), templateParms[digit]);
                index = param.indexOf("#");
            }
            result[i] = param;
            ++i;
        }
        return result;
    }

    public IFunctionSummary[] getMatchingFunctions(ICHelpInvocationContext context, ICHelpBook[] helpBooks, String prefix) {
        ArrayList<FunctionSummary> fList = new ArrayList<FunctionSummary>();
        int di = 0;
        while (di < helpBooks.length) {
            LibHoverLibrary l = libraries.get(helpBooks[di]);
            LibHoverInfo cppInfo = l.getHoverInfo();
            SortedMap<String, FunctionInfo> map = cppInfo.functions.tailMap(prefix);
            Set<Map.Entry<String, FunctionInfo>> c = map.entrySet();
            for (Map.Entry<String, FunctionInfo> e : c) {
                FunctionInfo x = e.getValue();
                String name = x.getName();
                if (!name.startsWith(prefix) || name.startsWith("0")) continue;
                FunctionSummary f = new FunctionSummary();
                f.ReturnType = x.getReturnType();
                f.Prototype = x.getPrototype();
                f.Summary = x.getDescription();
                f.Name = x.getName();
                ArrayList<String> headers = x.getHeaders();
                int i1 = 0;
                while (i1 < headers.size()) {
                    f.setIncludeName(headers.get(i1));
                    ++i1;
                }
                fList.add(f);
            }
            ++di;
        }
        IFunctionSummary[] summaries = new IFunctionSummary[fList.size()];
        int k = 0;
        while (k < summaries.length) {
            summaries[k] = (IFunctionSummary)fList.get(k);
            ++k;
        }
        return summaries;
    }

    public ICHelpResourceDescriptor[] getHelpResources(ICHelpInvocationContext context, ICHelpBook[] helpBooks, String name) {
        int i = 0;
        while (i < helpBooks.length) {
            IFunctionSummary fs = this.getFunctionInfo(context, new ICHelpBook[]{helpBooks[i]}, name);
            if (fs != null) {
                return new HelpResourceDescriptor[]{new HelpResourceDescriptor(helpBooks[i])};
            }
            ++i;
        }
        return null;
    }

    public static class ASTDeclarationFinderJob
    extends SharedASTJob {
        private IBinding binding;
        private IASTName[] decls = null;

        public ASTDeclarationFinderJob(ITranslationUnit t, IBinding binding) {
            super("ASTDeclarationFinderJob", t);
            this.binding = binding;
        }

        public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) {
            if (ast != null) {
                this.decls = ast.getDeclarationsInAST(this.binding);
            }
            return Status.OK_STATUS;
        }

        public IASTName[] getDeclarations() {
            return this.decls;
        }
    }

    private static class EnclosingASTNameJob
    extends SharedASTJob {
        private int tlength;
        private int toffset;
        private IASTName result = null;

        public EnclosingASTNameJob(ITranslationUnit t, int toffset, int tlength) {
            super("EnclosingASTNameJob", t);
            this.toffset = toffset;
            this.tlength = tlength;
        }

        public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) {
            if (ast != null) {
                this.result = ast.getNodeSelector(null).findEnclosingName(this.toffset, this.tlength);
            }
            return Status.OK_STATUS;
        }

        public IASTName getASTName() {
            return this.result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FunctionSummary
    implements IFunctionSummary,
    Comparable<FunctionSummary> {
        private String Name;
        private String NameSpace;
        private String ReturnType;
        private String Prototype;
        private String Summary;
        private boolean prototypeHasBrackets;
        private ArrayList<RequiredInclude> Includes = new ArrayList();

        private FunctionSummary() {
        }

        @Override
        public int compareTo(FunctionSummary x) {
            FunctionSummary y = x;
            return this.getName().compareTo(y.getName());
        }

        private void setIncludeName(String iname) {
            RequiredInclude nri = new RequiredInclude(iname);
            this.Includes.add(nri);
        }

        public String getName() {
            return this.Name;
        }

        public String getNamespace() {
            return this.NameSpace;
        }

        public String getDescription() {
            return this.Summary;
        }

        public boolean prototypeHasBrackets() {
            return this.prototypeHasBrackets;
        }

        public void setPrototypeHasBrackets(boolean value) {
            this.prototypeHasBrackets = value;
        }

        public IFunctionSummary.IFunctionPrototypeSummary getPrototype() {
            return new FunctionPrototypeSummary();
        }

        public IRequiredInclude[] getIncludes() {
            IRequiredInclude[] includes = new IRequiredInclude[this.Includes.size()];
            int i = 0;
            while (i < this.Includes.size()) {
                includes[i] = this.Includes.get(i);
                ++i;
            }
            return includes;
        }

        public class FunctionPrototypeSummary
        implements IFunctionSummary.IFunctionPrototypeSummary {
            public String getName() {
                return FunctionSummary.this.Name;
            }

            public String getReturnType() {
                return FunctionSummary.this.ReturnType;
            }

            public String getArguments() {
                return FunctionSummary.this.Prototype;
            }

            public String getPrototypeString(boolean namefirst) {
                if (namefirst) {
                    if (FunctionSummary.this.prototypeHasBrackets()) {
                        return String.valueOf(FunctionSummary.this.Name) + " " + FunctionSummary.this.Prototype + " " + FunctionSummary.this.ReturnType;
                    }
                    return String.valueOf(FunctionSummary.this.Name) + " (" + FunctionSummary.this.Prototype + ") " + FunctionSummary.this.ReturnType;
                }
                if (FunctionSummary.this.prototypeHasBrackets()) {
                    return String.valueOf(FunctionSummary.this.ReturnType) + " " + FunctionSummary.this.Name + " " + FunctionSummary.this.Prototype;
                }
                return String.valueOf(FunctionSummary.this.ReturnType) + " " + FunctionSummary.this.Name + " (" + FunctionSummary.this.Prototype + ")";
            }
        }

        private class RequiredInclude
        implements IRequiredInclude {
            private String include;

            public RequiredInclude(String file) {
                this.include = file;
            }

            public String getIncludeName() {
                return this.include;
            }

            public boolean isStandard() {
                return true;
            }
        }
    }

    private static class HelpResource
    implements IHelpResource {
        private String href;
        private String label;

        public HelpResource(String href, String label) {
            this.href = href;
            this.label = label;
        }

        public String getHref() {
            return this.href;
        }

        public String getLabel() {
            return this.label;
        }
    }

    private static class HelpResourceDescriptor
    implements ICHelpResourceDescriptor {
        private ICHelpBook helpbook;

        public HelpResourceDescriptor(ICHelpBook helpbook) {
            this.helpbook = helpbook;
        }

        public ICHelpBook getCHelpBook() {
            return this.helpbook;
        }

        public IHelpResource[] getHelpResources() {
            LibHoverLibrary l = (LibHoverLibrary)libraries.get(this.helpbook);
            if (l != null) {
                IHelpResource[] hr = new IHelpResource[]{new HelpResource(l.getDocs(), l.getName())};
                return hr;
            }
            return null;
        }
    }
}

