/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.abstractviewers;

import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTViewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.ISTDataViewersField;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractSTTreeViewer
extends AbstractSTViewer {
    public AbstractSTTreeViewer(Composite parent) {
        super(parent, 68354);
    }

    public AbstractSTTreeViewer(Composite parent, boolean init) {
        super(parent, 68354, init);
    }

    public AbstractSTTreeViewer(Composite parent, int style) {
        super(parent, style, true);
    }

    public AbstractSTTreeViewer(Composite parent, int style, boolean init) {
        super(parent, style, init);
    }

    protected TreeViewer createViewer(Composite parent, int style) {
        Tree t = this.createTree(parent, style);
        return new TreeViewer(t);
    }

    protected Tree createTree(Composite parent, int style) {
        Tree tree = new Tree(parent, style);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        return tree;
    }

    @Override
    protected void createColumns() {
        Tree tree = this.getViewer().getTree();
        TableLayout layout = new TableLayout();
        tree.setLayout((Layout)layout);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        int i = 0;
        while (i < this.getAllFields().length) {
            ISTDataViewersField field = this.getAllFields()[i];
            TreeColumn tc = new TreeColumn(tree, field.getAlignment(), i);
            tc.setText(field.getColumnHeaderText());
            tc.setToolTipText(field.getColumnHeaderTooltip());
            tc.setImage(field.getColumnHeaderImage());
            tc.setWidth(field.getPreferredWidth());
            tc.setResizable(true);
            tc.setMoveable(true);
            tc.addSelectionListener(this.createHeaderListener());
            tc.setData((Object)field);
            TreeViewerColumn viewerColumn = new TreeViewerColumn(this.getViewer(), tc);
            viewerColumn.setLabelProvider(this.createColumnLabelProvider((Item)tc));
            ++i;
        }
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Tree tree = (Tree)e.widget;
                TreeItem item = tree.getItem(new Point(e.x, e.y));
                if (item != null) {
                    int i = 0;
                    while (i < tree.getColumnCount()) {
                        Rectangle bounds;
                        ISTDataViewersField field = AbstractSTTreeViewer.this.getAllFields()[i];
                        if (field.isHyperLink(item.getData()) && (bounds = item.getBounds(i)).contains(e.x, e.y)) {
                            AbstractSTTreeViewer.this.handleHyperlink(field, item.getData());
                            return;
                        }
                        ++i;
                    }
                }
            }
        });
        tree.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                Tree tree = (Tree)e.widget;
                TreeItem item = tree.getItem(new Point(e.x, e.y));
                if (item == null) {
                    return;
                }
                int i = 0;
                while (i < tree.getColumnCount()) {
                    Rectangle bounds;
                    ISTDataViewersField field = AbstractSTTreeViewer.this.getAllFields()[i];
                    Cursor cursor = null;
                    if (field.isHyperLink(item.getData()) && (bounds = item.getBounds(i)).contains(e.x, e.y)) {
                        cursor = e.display.getSystemCursor(21);
                        tree.setCursor(cursor);
                        return;
                    }
                    cursor = e.display.getSystemCursor(0);
                    tree.setCursor(cursor);
                    ++i;
                }
            }
        });
    }

    public TreeColumn[] getColumns() {
        return this.getViewer().getTree().getColumns();
    }

    @Override
    public void updateDirectionIndicator(Item column) {
        this.getViewer().getTree().setSortColumn((TreeColumn)column);
        if (this.getTableSorter().getTopPriorityDirection() == 1) {
            this.getViewer().getTree().setSortDirection(128);
        } else {
            this.getViewer().getTree().setSortDirection(1024);
        }
    }

    @Override
    public int[] getColumnOrder() {
        return this.getViewer().getTree().getColumnOrder();
    }

    @Override
    protected void setColumnOrder(int[] order) {
        this.getViewer().getTree().setColumnOrder(order);
    }

    @Override
    public int getColumnIndex(Item column) {
        return this.getViewer().getTree().indexOf((TreeColumn)column);
    }

    @Override
    public int getColumnWidth(Item column) {
        return ((TreeColumn)column).getWidth();
    }

    @Override
    public void setColumnResizable(Item column, boolean resizable) {
        ((TreeColumn)column).setResizable(resizable);
    }

    @Override
    public void setColumnWidth(Item column, int width) {
        ((TreeColumn)column).setWidth(width);
    }

    public TreeViewer getViewer() {
        return (TreeViewer)super.getViewer();
    }

    public void handleHyperlink(ISTDataViewersField field, Object data) {
    }
}

