/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences.formatter;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import org.eclipse.cdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.cdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.PlatformUI;

public class CustomCodeFormatterBlock
extends Observable {
    private HashMap<String, String> idMap = new HashMap();
    private IEclipsePreferences fPrefs;
    private String fDefaultFormatterId;
    private Combo fFormatterCombo;
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ID = "id";
    private static final String DEFAULT = FormatterMessages.CustomCodeFormatterBlock_default_formatter;

    public CustomCodeFormatterBlock(IProject project, PreferencesAccess access) {
        IEclipsePreferences defaults;
        IScopeContext scope;
        if (project != null) {
            scope = access.getProjectScope(project);
            defaults = access.getInstanceScope().getNode("org.eclipse.cdt.core");
        } else {
            scope = access.getInstanceScope();
            defaults = access.getDefaultScope().getNode("org.eclipse.cdt.core");
        }
        this.fPrefs = scope.getNode("org.eclipse.cdt.core");
        this.fDefaultFormatterId = defaults.get("org.eclipse.cdt.core.code_formatter", null);
        if (this.fDefaultFormatterId == null) {
            IEclipsePreferences instance = access.getInstanceScope().getNode("org.eclipse.cdt.ui");
            this.fDefaultFormatterId = instance.get("org.eclipse.cdt.core.code_formatter", null);
            if (this.fDefaultFormatterId != null) {
                instance.remove("org.eclipse.cdt.core.code_formatter");
                if (project != null) {
                    defaults.put("org.eclipse.cdt.core.code_formatter", this.fDefaultFormatterId);
                }
            }
        }
        this.initializeFormatters();
    }

    public void performOk() {
        if (this.fFormatterCombo == null) {
            return;
        }
        String text = this.fFormatterCombo.getText();
        String formatterId = this.idMap.get(text);
        if (formatterId != null && !formatterId.equals(this.fDefaultFormatterId)) {
            this.fPrefs.put("org.eclipse.cdt.core.code_formatter", formatterId);
        } else {
            this.performDefaults();
        }
    }

    public void performDefaults() {
        this.fPrefs.remove("org.eclipse.cdt.core.code_formatter");
        if (this.fFormatterCombo == null) {
            return;
        }
        this.fFormatterCombo.clearSelection();
        this.fFormatterCombo.setText(DEFAULT);
        for (Map.Entry<String, String> entry : this.idMap.entrySet()) {
            String val = entry.getValue();
            if (val == null || !val.equals(this.fDefaultFormatterId)) continue;
            this.fFormatterCombo.setText(entry.getKey());
        }
        this.handleFormatterChanged();
    }

    public void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        if (useProjectSpecificSettings) {
            if (this.fDefaultFormatterId != null) {
                this.fPrefs.put("org.eclipse.cdt.core.code_formatter", this.fDefaultFormatterId);
            }
        } else {
            this.initDefault();
        }
    }

    public String getFormatterId() {
        if (this.fFormatterCombo == null) {
            return this.fPrefs.get("org.eclipse.cdt.core.code_formatter", this.fDefaultFormatterId);
        }
        String formatterId = this.idMap.get(this.fFormatterCombo.getText());
        return formatterId;
    }

    public Control createContents(Composite parent) {
        if (this.getNumberOfAvailableFormatters() == 0) {
            return parent;
        }
        Group composite = ControlFactory.createGroup(parent, FormatterMessages.CustomCodeFormatterBlock_formatter_name, 1);
        ((GridData)composite.getLayoutData()).horizontalSpan = 5;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.cdt.ui.codeformatter_preference_page_context");
        this.fFormatterCombo = new Combo((Composite)composite, 12);
        this.fFormatterCombo.setFont(parent.getFont());
        this.fFormatterCombo.setLayoutData((Object)new GridData(768));
        this.fFormatterCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomCodeFormatterBlock.this.handleFormatterChanged();
            }
        });
        Iterator<String> items = this.idMap.keySet().iterator();
        while (items.hasNext()) {
            this.fFormatterCombo.add(items.next());
        }
        String noteTitle = FormatterMessages.CustomCodeFormatterBlock_formatter_note;
        String noteMessage = FormatterMessages.CustomCodeFormatterBlock_contributed_formatter_warning;
        ControlFactory.createNoteComposite(JFaceResources.getDialogFont(), (Composite)composite, noteTitle, noteMessage);
        this.initDefault();
        return composite;
    }

    private void handleFormatterChanged() {
        this.setChanged();
        String formatterId = this.getFormatterId();
        this.notifyObservers(formatterId);
    }

    private void initDefault() {
        boolean init = false;
        String formatterID = this.fPrefs.get("org.eclipse.cdt.core.code_formatter", this.fDefaultFormatterId);
        if (formatterID != null) {
            for (Map.Entry<String, String> entry : this.idMap.entrySet()) {
                String val = entry.getValue();
                if (val == null || !val.equals(formatterID)) continue;
                this.fFormatterCombo.setText(entry.getKey());
                init = true;
            }
        }
        if (!init) {
            formatterID = null;
            this.fFormatterCombo.setText(DEFAULT);
        }
    }

    private void initializeFormatters() {
        this.idMap = new HashMap();
        this.idMap.put(DEFAULT, "org.eclipse.cdt.core.defaultCodeFormatter");
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "CodeFormatter");
        if (point != null) {
            IExtension[] exts;
            IExtension[] iExtensionArray = exts = point.getExtensions();
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] elements = ext.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    String name = elements[j].getAttribute(ATTR_NAME);
                    String id = elements[j].getAttribute(ATTR_ID);
                    this.idMap.put(name, id);
                    ++j;
                }
                ++n2;
            }
        }
    }

    private final int getNumberOfAvailableFormatters() {
        return this.idMap.size() - 1;
    }
}

