/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.rpmlint.builder;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.linuxtools.internal.rpm.rpmlint.builder.Messages;
import org.eclipse.linuxtools.internal.rpm.rpmlint.builder.RpmlintDeltaVisitor;
import org.eclipse.linuxtools.internal.rpm.rpmlint.builder.RpmlintMarkerVisitor;
import org.eclipse.linuxtools.internal.rpm.rpmlint.builder.RpmlintPreVisitor;
import org.eclipse.linuxtools.internal.rpm.rpmlint.parser.RpmlintItem;
import org.eclipse.linuxtools.internal.rpm.rpmlint.parser.RpmlintParser;

public class RpmlintBuilder
extends IncrementalProjectBuilder {
    public static final int MAX_WORKS = 100;
    public static final String BUILDER_ID = "org.eclipse.linuxtools.rpm.rpmlint.rpmlintBuilder";
    public static final String MARKER_ID = "org.eclipse.linuxtools.rpm.rpmlint.rpmlintProblem";

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.RpmlintBuilder_0, 100);
        monitor.worked(20);
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        RpmlintPreVisitor resourceVisitor = new RpmlintPreVisitor();
        this.getProject().accept((IResourceVisitor)resourceVisitor);
        RpmlintBuilder.checkCancel(monitor);
        monitor.worked(50);
        monitor.setTaskName(Messages.RpmlintBuilder_1);
        List<RpmlintItem> rpmlintItems = RpmlintParser.parseVisisted(resourceVisitor.getVisitedPaths());
        this.visitAndMarkRpmlintItems(monitor, rpmlintItems);
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        RpmlintDeltaVisitor deltaVisitor = new RpmlintDeltaVisitor();
        delta.accept((IResourceDeltaVisitor)deltaVisitor);
        monitor.worked(50);
        monitor.setTaskName(Messages.RpmlintBuilder_1);
        List<RpmlintItem> rpmlintItems = RpmlintParser.parseVisisted(deltaVisitor.getVisitedPaths());
        this.visitAndMarkRpmlintItems(monitor, rpmlintItems);
    }

    private void visitAndMarkRpmlintItems(IProgressMonitor monitor, List<RpmlintItem> rpmlintItems) throws CoreException {
        if (rpmlintItems.size() > 0) {
            RpmlintBuilder.checkCancel(monitor);
            monitor.worked(70);
            monitor.setTaskName(Messages.RpmlintBuilder_2);
            this.getProject().accept((IResourceVisitor)new RpmlintMarkerVisitor(rpmlintItems));
            monitor.worked(100);
        }
    }

    private static void checkCancel(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

