/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIList;
import org.eclipse.cdt.debug.mi.core.output.MIMemory;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIDataReadMemoryInfo
extends MIInfo {
    String addr;
    long nextRow;
    long prevRow;
    long nextPage;
    long prevPage;
    long numBytes;
    long totalBytes;
    MIMemory[] memories;

    public MIDataReadMemoryInfo(MIOutput rr) {
        super(rr);
        this.parse();
    }

    public String getAddress() {
        return this.addr;
    }

    public long getNumberBytes() {
        return this.numBytes;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getNextRow() {
        return this.nextRow;
    }

    public long getPreviousRow() {
        return this.prevRow;
    }

    public long getNextPage() {
        return this.nextPage;
    }

    public long getPreviousPage() {
        return this.prevPage;
    }

    public MIMemory[] getMemories() {
        return this.memories;
    }

    void parse() {
        MIOutput out;
        MIResultRecord rr;
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                MIValue value = results[i].getMIValue();
                String str = "";
                if (value != null && value instanceof MIConst) {
                    str = ((MIConst)value).getCString();
                }
                if (var.equals("addr")) {
                    try {
                        this.addr = str.trim();
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (var.equals("nr-bytes")) {
                    try {
                        this.numBytes = Long.decode(str.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (var.equals("total-bytes")) {
                    try {
                        this.totalBytes = Long.decode(str.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (var.equals("next-row")) {
                    try {
                        this.nextRow = Long.decode(str.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (var.equals("prev-row")) {
                    try {
                        this.prevRow = Long.decode(str.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (var.equals("next-page")) {
                    try {
                        this.nextPage = Long.decode(str.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (var.equals("prev-page")) {
                    try {
                        this.prevPage = Long.decode(str.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (var.equals("memory") && value instanceof MIList) {
                    this.parseMemory((MIList)value);
                }
                ++i;
            }
        }
        if (this.memories == null) {
            this.memories = new MIMemory[0];
        }
    }

    void parseMemory(MIList list) {
        MIValue[] values = list.getMIValues();
        this.memories = new MIMemory[values.length];
        int i = 0;
        while (i < values.length) {
            if (values[i] instanceof MITuple) {
                this.memories[i] = new MIMemory((MITuple)values[i]);
            }
            ++i;
        }
    }
}

