/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.util.ArrayList;
import org.eclipse.cdt.dsf.debug.service.IInstruction;
import org.eclipse.cdt.dsf.debug.service.IMixedInstruction;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInstruction;
import org.eclipse.cdt.dsf.mi.service.command.output.MIList;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

public class MIMixedInstruction
implements IMixedInstruction {
    private String fileName = "";
    private int lineNumber = 0;
    private MIInstruction[] assemblyCode;

    public MIMixedInstruction(MITuple tuple) {
        this.parse(tuple);
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public IInstruction[] getInstructions() {
        return this.assemblyCode;
    }

    private void parse(MITuple tuple) {
        ArrayList<MIInstruction> instructions = new ArrayList<MIInstruction>();
        MIResult[] results = tuple.getMIResults();
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value != null && value instanceof MIConst) {
                str = ((MIConst)value).getCString();
            }
            if (var.equals("line")) {
                try {
                    this.lineNumber = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (var.equals("file")) {
                this.fileName = str;
            } else if (var.equals("line_asm_insn") && value instanceof MIList) {
                MIList list = (MIList)value;
                MIValue[] values = list.getMIValues();
                int j = 0;
                while (j < values.length) {
                    if (values[j] instanceof MITuple) {
                        instructions.add(new MIInstruction((MITuple)values[j]));
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.assemblyCode = instructions.toArray(new MIInstruction[instructions.size()]);
    }
}

