/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.core.control.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.IDomainInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.ISessionInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.ISnapshotInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.TraceSessionState;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.impl.DomainInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.impl.TraceInfo;

public class SessionInfo
extends TraceInfo
implements ISessionInfo {
    private TraceSessionState fState = TraceSessionState.INACTIVE;
    private String fSessionPath = "";
    private final List<IDomainInfo> fDomains = new ArrayList<IDomainInfo>();
    private boolean fIsStreamedTrace = false;
    private ISnapshotInfo fSnapshotInfo = null;

    public SessionInfo(String name) {
        super(name);
    }

    public SessionInfo(SessionInfo other) {
        super(other);
        this.fState = other.fState;
        this.fSessionPath = other.fSessionPath;
        this.fIsStreamedTrace = other.fIsStreamedTrace;
        this.fSnapshotInfo = other.fSnapshotInfo;
        for (IDomainInfo domain : other.fDomains) {
            if (domain instanceof DomainInfo) {
                this.fDomains.add(new DomainInfo((DomainInfo)domain));
                continue;
            }
            this.fDomains.add(domain);
        }
    }

    @Override
    public TraceSessionState getSessionState() {
        return this.fState;
    }

    @Override
    public void setSessionState(TraceSessionState state) {
        this.fState = state;
    }

    @Override
    public void setSessionState(String stateName) {
        if (TraceSessionState.INACTIVE.getInName().equals(stateName)) {
            this.fState = TraceSessionState.INACTIVE;
        } else if (TraceSessionState.ACTIVE.getInName().equals(stateName)) {
            this.fState = TraceSessionState.ACTIVE;
        }
    }

    @Override
    public String getSessionPath() {
        if (this.isSnapshotSession()) {
            return this.fSnapshotInfo.getSnapshotPath();
        }
        return this.fSessionPath;
    }

    @Override
    public void setSessionPath(String path) {
        this.fSessionPath = path;
    }

    @Override
    public IDomainInfo[] getDomains() {
        return this.fDomains.toArray(new IDomainInfo[this.fDomains.size()]);
    }

    @Override
    public void setDomains(List<IDomainInfo> domains) {
        this.fDomains.clear();
        for (IDomainInfo domainInfo : domains) {
            this.fDomains.add(domainInfo);
        }
    }

    @Override
    public boolean isStreamedTrace() {
        if (this.isSnapshotSession()) {
            return this.fSnapshotInfo.isStreamedSnapshot();
        }
        return this.fIsStreamedTrace;
    }

    @Override
    public void setStreamedTrace(boolean isStreamedTrace) {
        this.fIsStreamedTrace = isStreamedTrace;
    }

    @Override
    public boolean isSnapshotSession() {
        return this.fSnapshotInfo != null;
    }

    @Override
    public ISnapshotInfo getSnapshotInfo() {
        return this.fSnapshotInfo;
    }

    @Override
    public void setSnapshotInfo(ISnapshotInfo info) {
        this.fSnapshotInfo = info;
    }

    @Override
    public void addDomain(IDomainInfo domainInfo) {
        this.fDomains.add(domainInfo);
    }

    @Override
    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("[SessionInfo(");
        output.append(super.toString());
        output.append(",Path=");
        output.append(this.getSessionPath());
        output.append(",State=");
        output.append((Object)this.fState);
        output.append(",isStreamedTrace=");
        output.append(this.fIsStreamedTrace);
        if (this.fSnapshotInfo != null) {
            output.append(",snapshotInfo=");
            output.append(this.fSnapshotInfo.toString());
        }
        output.append(",Domains=");
        for (IDomainInfo domain : this.fDomains) {
            output.append(domain.toString());
        }
        output.append(")]");
        return output.toString();
    }
}

