/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.statistics;

import org.eclipse.core.resources.IResource;
import org.eclipse.linuxtools.tmf.core.component.TmfDataProvider;
import org.eclipse.linuxtools.tmf.core.signal.TmfEndSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfStartSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceRangeUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceType;
import org.eclipse.linuxtools.tmf.ui.viewers.ITmfViewer;
import org.eclipse.linuxtools.tmf.ui.viewers.statistics.TmfStatisticsViewer;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.linuxtools.tmf.ui.views.statistics.Messages;
import org.eclipse.linuxtools.tmf.ui.widgets.tabsview.TmfViewerFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class TmfStatisticsView
extends TmfView {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.views.statistics";
    public static final String TMF_STATISTICS_VIEW = "StatisticsView";
    protected final TmfViewerFolder fStatsViewers;
    private ITmfTrace fTrace;

    public TmfStatisticsView(String viewName) {
        super(viewName);
        Shell temporaryParent = new Shell();
        this.fStatsViewers = new TmfViewerFolder((Composite)temporaryParent);
    }

    public TmfStatisticsView() {
        this(TMF_STATISTICS_VIEW);
    }

    public void createPartControl(Composite parent) {
        this.fStatsViewers.setParent(parent);
        this.createStatisticsViewers();
        ITmfTrace trace = this.getActiveTrace();
        if (trace != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fStatsViewers.dispose();
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.fStatsViewers.clear();
        this.fTrace = signal.getTrace();
        this.createStatisticsViewers();
        this.fStatsViewers.layout();
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (signal.getTrace() != this.fTrace) {
            this.fStatsViewers.clear();
            this.fTrace = signal.getTrace();
            this.createStatisticsViewers();
            this.fStatsViewers.layout();
            TmfTraceRangeUpdatedSignal updateSignal = new TmfTraceRangeUpdatedSignal((Object)this, this.fTrace, this.fTrace.getTimeRange());
            if (this.fTrace instanceof TmfDataProvider) {
                ((TmfDataProvider)this.fTrace).startSynch(new TmfStartSynchSignal(0));
            }
            for (ITmfViewer viewer : this.fStatsViewers.getViewers()) {
                TmfStatisticsViewer statsViewer = (TmfStatisticsViewer)viewer;
                statsViewer.sendPartialRequestOnNextUpdate();
                statsViewer.traceRangeUpdated(updateSignal);
            }
            if (this.fTrace instanceof TmfDataProvider) {
                ((TmfDataProvider)this.fTrace).endSynch(new TmfEndSynchSignal(0));
            }
        } else {
            for (ITmfViewer viewer : this.fStatsViewers.getViewers()) {
                TmfStatisticsViewer statsViewer = (TmfStatisticsViewer)viewer;
                statsViewer.sendPartialRequestOnNextUpdate();
            }
        }
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        if (signal.getTrace() != this.fTrace) {
            return;
        }
        this.fTrace = null;
        this.fStatsViewers.clear();
        this.createStatisticsViewers();
        this.fStatsViewers.layout();
    }

    public void setFocus() {
        this.fStatsViewers.setFocus();
    }

    protected void createStatisticsViewers() {
        int defaultStyle = 0;
        Composite folder = this.fStatsViewers.getParentFolder();
        TmfStatisticsViewer globalViewer = this.getGlobalViewer();
        if (this.fTrace != null) {
            if (globalViewer != null) {
                globalViewer.init(folder, String.valueOf(Messages.TmfStatisticsView_GlobalTabName) + " - " + this.fTrace.getName(), this.fTrace);
            }
            this.fStatsViewers.addTab(globalViewer, Messages.TmfStatisticsView_GlobalTabName, defaultStyle);
            ITmfTrace[] iTmfTraceArray = TmfTraceManager.getTraceSet((ITmfTrace)this.fTrace);
            int n = iTmfTraceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITmfTrace trace = iTmfTraceArray[n2];
                String traceName = trace.getName();
                IResource traceResource = trace.getResource();
                TmfStatisticsViewer viewer = TmfStatisticsView.getStatisticsViewer(traceResource);
                if (viewer != null) {
                    viewer.init(folder, traceName, trace);
                    this.fStatsViewers.addTab(viewer, viewer.getName(), defaultStyle);
                }
                ++n2;
            }
        } else {
            if (globalViewer != null) {
                globalViewer.init(folder, Messages.TmfStatisticsView_GlobalTabName, this.fTrace);
            }
            this.fStatsViewers.addTab(globalViewer, Messages.TmfStatisticsView_GlobalTabName, defaultStyle);
        }
        this.fStatsViewers.setSelection(0);
    }

    protected static TmfStatisticsViewer getStatisticsViewer(IResource resource) {
        return (TmfStatisticsViewer)TmfTraceType.getTraceTypeElement(resource, "statisticsViewerType");
    }

    protected TmfStatisticsViewer getGlobalViewer() {
        return new TmfStatisticsViewer();
    }
}

