/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.ITimeRange;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Lifeline;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Metrics;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.SDTimeEvent;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IGC;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.preferences.SDViewPref;

public class BasicFrame
extends GraphNode {
    private ITmfTimestamp fMaxTime = new TmfTimestamp(0L);
    private ITmfTimestamp fMinTime = new TmfTimestamp(0L);
    private boolean fComputeMinMax = true;
    private boolean fLastExternalTimePref = SDViewPref.getInstance().excludeExternalTime();
    private int fVerticalIndex = 0;
    private int fHorizontalIndex = 0;
    private boolean fHasTimeInfo = false;
    private int fVisibleAreaX;
    private int fVisibleAreaY;
    private int fVisibleAreaWidth;
    private int fVisibleAreaHeight;
    private int fForceEventOccurrenceSpacing = -1;
    private boolean fCustomMinMax = false;
    private ITmfTimestamp fMinSDTime = new TmfTimestamp();
    private ITmfTimestamp fMaxSDTime = new TmfTimestamp();
    private boolean fInitSDMin = true;

    public BasicFrame() {
        Metrics.setForcedEventSpacing(this.fForceEventOccurrenceSpacing);
    }

    protected int getMaxEventOccurrence() {
        return this.fVerticalIndex;
    }

    protected void setMaxEventOccurrence(int eventOccurrence) {
        this.fVerticalIndex = eventOccurrence;
    }

    protected int getNewHorizontalIndex() {
        return ++this.fHorizontalIndex;
    }

    protected int getHorizontalIndex() {
        return this.fHorizontalIndex;
    }

    @Override
    public void addNode(GraphNode nodeToAdd) {
        this.setComputeMinMax(true);
        super.addNode(nodeToAdd);
    }

    @Override
    public int getX() {
        return 10;
    }

    @Override
    public int getY() {
        return 10;
    }

    @Override
    public int getWidth() {
        if (this.fHorizontalIndex == 0) {
            return 3 * Metrics.swimmingLaneWidth() + 46 - 10 - 22;
        }
        return this.fHorizontalIndex * Metrics.swimmingLaneWidth() + 46 + 1 - 45;
    }

    @Override
    public int getHeight() {
        if (this.fVerticalIndex == 0) {
            return 5 * (Metrics.getMessagesSpacing() + Metrics.getMessageFontHeigth()) + 14 + 4 + Metrics.getFrameFontHeigth() + 30 + 20 + 14 + 4 + Metrics.getLifelineFontHeigth() * 2;
        }
        if (this.fForceEventOccurrenceSpacing >= 0) {
            Metrics.setForcedEventSpacing(this.fForceEventOccurrenceSpacing);
        }
        return this.fVerticalIndex * (Metrics.getMessagesSpacing() + Metrics.getMessageFontHeigth()) + 14 + 4 + Metrics.getFrameFontHeigth() + 30 + 20 + 14 + 4 + Metrics.getLifelineFontHeigth() * 2;
    }

    protected boolean isComputeMinMax() {
        return this.fComputeMinMax;
    }

    protected boolean isCustomMinMax() {
        return this.fCustomMinMax;
    }

    protected boolean getInitSDMin() {
        return this.fInitSDMin;
    }

    @Override
    protected GraphNode getNodeFromListAt(int x, int y, List<GraphNode> list, int fromIndex) {
        if (list == null) {
            return null;
        }
        int i = fromIndex;
        while (i < list.size()) {
            GraphNode node = list.get(i);
            if (node instanceof Lifeline && node.getX() > this.fVisibleAreaX + this.fVisibleAreaWidth || (node.getHeight() >= 0 ? node.getY() > this.fVisibleAreaY + this.fVisibleAreaHeight : node.getY() + node.getHeight() > this.fVisibleAreaY + this.fVisibleAreaHeight)) break;
            if (node.contains(x, y)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    protected void drawFrame(IGC context) {
        SDViewPref pref = SDViewPref.getInstance();
        context.setBackground(pref.getBackGroundColor("PREF_FRAME"));
        context.setForeground(pref.getForeGroundColor("PREF_FRAME"));
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        context.fillRectangle(x, y, w, h);
        context.drawRectangle(x, y, w, h);
        context.setBackground(pref.getBackGroundColor("PREF_FRAME_NAME"));
        context.setForeground(pref.getForeGroundColor("PREF_FRAME_NAME"));
        context.setFont(pref.getFont("PREF_FRAME_NAME"));
        int nameWidth = context.textExtent(this.getName()) + 16;
        int nameHeight = Metrics.getFrameFontHeigth() + 8;
        if (nameWidth > w) {
            nameWidth = w;
        }
        int[] points = new int[]{x, y, x + nameWidth, y, x + nameWidth, y - 11 + nameHeight, x - 11 + nameWidth, y + nameHeight, x, y + nameHeight, x, y + nameHeight};
        context.fillPolygon(points);
        context.drawPolygon(points);
        context.drawLine(x, y, x, y + nameHeight);
        context.setForeground(pref.getFontColor("PREF_FRAME_NAME"));
        context.drawTextTruncatedCentred(this.getName(), x, y, nameWidth - 11, nameHeight, false);
        context.setBackground(pref.getBackGroundColor("PREF_FRAME"));
        context.setForeground(pref.getForeGroundColor("PREF_FRAME"));
    }

    @Override
    public void draw(IGC context) {
        this.draw(context, true);
    }

    protected void draw(IGC context, boolean drawFrame) {
        this.fVisibleAreaHeight = context.getVisibleHeight();
        this.fVisibleAreaWidth = context.getVisibleWidth();
        this.fVisibleAreaX = context.getContentsX();
        this.fVisibleAreaY = context.getContentsY();
        if (this.fForceEventOccurrenceSpacing >= 0) {
            Metrics.setForcedEventSpacing(this.fForceEventOccurrenceSpacing);
        } else {
            Metrics.setForcedEventSpacing(-1);
        }
        super.drawChildenNodes(context);
    }

    public void forceEventOccurrenceSpacing(int space) {
        this.fForceEventOccurrenceSpacing = space;
    }

    public int getVisibleAreaX() {
        return this.fVisibleAreaX;
    }

    public int getVisibleAreaWidth() {
        return this.fVisibleAreaWidth;
    }

    public int getVisibleAreaHeight() {
        return this.fVisibleAreaHeight;
    }

    public int getVisibleAreaY() {
        return this.fVisibleAreaY;
    }

    public ITmfTimestamp getMinTime() {
        if (this.fLastExternalTimePref != SDViewPref.getInstance().excludeExternalTime()) {
            this.fLastExternalTimePref = SDViewPref.getInstance().excludeExternalTime();
            this.setComputeMinMax(true);
        }
        if (this.fComputeMinMax && !this.fCustomMinMax) {
            this.computeMinMax();
            this.setComputeMinMax(false);
        }
        return this.fMinTime;
    }

    public void setMin(ITmfTimestamp min) {
        this.fMinTime = min;
        this.fCustomMinMax = true;
    }

    public void setMax(ITmfTimestamp max) {
        this.fMaxTime = max;
        this.fCustomMinMax = true;
    }

    public void resetCustomMinMax() {
        this.fCustomMinMax = false;
        this.setComputeMinMax(true);
    }

    public ITmfTimestamp getMaxTime() {
        if (this.fLastExternalTimePref != SDViewPref.getInstance().excludeExternalTime()) {
            this.fLastExternalTimePref = SDViewPref.getInstance().excludeExternalTime();
            this.setComputeMinMax(true);
        }
        if (this.fComputeMinMax) {
            this.computeMinMax();
            this.setComputeMinMax(false);
        }
        return this.fMaxTime;
    }

    protected void computeMaxMinTime() {
        if (!this.fInitSDMin) {
            return;
        }
        List<SDTimeEvent> timeArray = this.buildTimeArray();
        if (timeArray == null || timeArray.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < timeArray.size()) {
            SDTimeEvent m = timeArray.get(i);
            if (m.getTime().compareTo(this.fMaxSDTime, true) > 0) {
                this.fMaxSDTime = m.getTime();
            }
            if (m.getTime().compareTo(this.fMinSDTime, true) < 0 || this.fInitSDMin) {
                this.fMinSDTime = m.getTime();
                this.fInitSDMin = false;
            }
            ++i;
        }
    }

    public ITmfTimestamp getSDMinTime() {
        this.computeMaxMinTime();
        return this.fMinSDTime;
    }

    public ITmfTimestamp getSDMaxTime() {
        this.computeMaxMinTime();
        return this.fMaxSDTime;
    }

    protected void computeMinMax() {
        List<SDTimeEvent> timeArray = this.buildTimeArray();
        if (timeArray == null || timeArray.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < timeArray.size() - 1) {
            SDTimeEvent m1 = timeArray.get(i);
            SDTimeEvent m2 = timeArray.get(i + 1);
            this.updateMinMax(m1, m2);
            ++i;
        }
    }

    protected void updateMinMax(SDTimeEvent m1, SDTimeEvent m2) {
        ITmfTimestamp delta = m2.getTime().getDelta(m1.getTime());
        if (this.fComputeMinMax) {
            this.fMinTime = delta;
            if (this.fMinTime.compareTo(TmfTimestamp.ZERO, false) < 0) {
                this.fMinTime = new TmfTimestamp(0L, m1.getTime().getScale(), m1.getTime().getPrecision());
            }
            this.fMaxTime = this.fMinTime;
            this.setComputeMinMax(false);
        }
        if (delta.compareTo(this.fMinTime, true) < 0 && delta.compareTo(TmfTimestamp.ZERO, false) > 0) {
            this.fMinTime = delta;
        }
        if (delta.compareTo(this.fMaxTime, true) > 0 && delta.compareTo(TmfTimestamp.ZERO, false) > 0) {
            this.fMaxTime = delta;
        }
    }

    protected List<SDTimeEvent> buildTimeArray() {
        if (!this.hasChildren()) {
            return new ArrayList<SDTimeEvent>();
        }
        Iterator<String> it = this.getForwardSortMap().keySet().iterator();
        ArrayList<SDTimeEvent> timeArray = new ArrayList<SDTimeEvent>();
        while (it.hasNext()) {
            String nodeType = it.next();
            List<GraphNode> list = this.getNodeMap().get(nodeType);
            int i = 0;
            while (i < list.size()) {
                GraphNode timedNode = list.get(i);
                if (timedNode instanceof ITimeRange && ((ITimeRange)((Object)timedNode)).hasTimeInfo()) {
                    int event = list.get(i).getStartOccurrence();
                    ITmfTimestamp time = ((ITimeRange)((Object)list.get(i))).getStartTime();
                    SDTimeEvent f = new SDTimeEvent(time, event, (ITimeRange)((Object)list.get(i)));
                    timeArray.add(f);
                    if (event != list.get(i).getEndOccurrence()) {
                        event = list.get(i).getEndOccurrence();
                        time = ((ITimeRange)((Object)list.get(i))).getEndTime();
                        f = new SDTimeEvent(time, event, (ITimeRange)((Object)list.get(i)));
                        timeArray.add(f);
                    }
                }
                ++i;
            }
        }
        return timeArray;
    }

    @Override
    public String getArrayId() {
        return null;
    }

    @Override
    public boolean contains(int x, int y) {
        return false;
    }

    public boolean hasTimeInfo() {
        return this.fHasTimeInfo;
    }

    public void setHasTimeInfo(boolean hasTimeInfo) {
        this.fHasTimeInfo = hasTimeInfo;
    }

    public void setComputeMinMax(boolean computeMinMax) {
        this.fComputeMinMax = computeMinMax;
    }

    public void setInitSDMin(boolean initSDMin) {
        this.fInitSDMin = initSDMin;
    }
}

