/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.core;

import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.BasicExecutionOccurrence;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IGC;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IImage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.preferences.SDViewPref;

public class HotSpot
extends GraphNode {
    public static final String GLYPH = "Glyph";
    private BasicExecutionOccurrence fExecOcc = null;
    private int fOccurrence = 0;
    private IImage fImage = null;

    public HotSpot() {
        this.setColorPrefId("PREF_EXEC");
    }

    public void setImage(IImage img) {
        this.fImage = img;
    }

    protected IImage getImage() {
        return this.fImage;
    }

    @Override
    public int getX() {
        if (this.fExecOcc != null) {
            return this.fExecOcc.getX() - 3;
        }
        return 0;
    }

    @Override
    public int getY() {
        if (this.fExecOcc != null) {
            return this.fExecOcc.getY();
        }
        return 0;
    }

    @Override
    public int getWidth() {
        if (this.fExecOcc != null) {
            return this.fExecOcc.getWidth() + 7;
        }
        return 0;
    }

    @Override
    public int getHeight() {
        if (this.fExecOcc != null) {
            return this.fExecOcc.getWidth() + 10;
        }
        return 0;
    }

    public void setExecution(BasicExecutionOccurrence occ) {
        this.fExecOcc = occ;
        this.fExecOcc.addNode(this);
    }

    public BasicExecutionOccurrence getExecOcc() {
        return this.fExecOcc;
    }

    public int getOccurrence() {
        return this.fOccurrence;
    }

    public void setOccurrence(int occ) {
        this.fOccurrence = occ;
    }

    @Override
    public void draw(IGC context) {
        SDViewPref pref = SDViewPref.getInstance();
        if (this.isSelected() || this.fExecOcc != null && this.fExecOcc.isSelected() || this.fExecOcc != null && this.fExecOcc.getLifeline() != null && this.fExecOcc.getLifeline().isSelected()) {
            context.setBackground(pref.getBackGroundColorSelection());
            context.setForeground(pref.getForeGroundColorSelection());
        } else {
            context.setBackground(pref.getBackGroundColor("PREF_EXEC"));
            context.setForeground(pref.getForeGroundColor("PREF_EXEC"));
        }
        context.drawImage(this.fImage, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    public String getArrayId() {
        return GLYPH;
    }

    @Override
    public boolean isVisible(int x, int y, int width, int height) {
        return true;
    }

    @Override
    public boolean contains(int xValue, int yValue) {
        int height;
        int width;
        int y;
        int x = this.getX();
        return GraphNode.contains(x, y = this.getY(), width = this.getWidth(), height = this.getHeight(), xValue, yValue);
    }
}

